/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.IpSec;
import se.ericsson.security.cppsec.esa.model.IpSecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.IpSecFiles;
import se.ericsson.security.cppsec.esa.model.elements.IpSecEnrollmentDataElement;
import se.ericsson.security.cppsec.esa.model.elements.IpSecFilesElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class IpSecElement
extends StackElement
implements IpSec {
    private static final String TYPE = "type";
    private static final String USER_LABEL = "userLabel";
    private static final String CERT_EXPIR_WARN_TIME = "certExpirWarnTime";
    private static final String AUTO_UPDATE_CERT_ENROLLMENT_SERVER = "autoUpdateCertEnrollmentServer";
    public static final String OAM_TYPE = "OAM";
    public static final String TRAFFIC_TYPE = "Traffic";
    public static final String IPSEC = "ipSec";
    private String type;
    private String userLabel;
    private String certExpirWarnTime;
    private String autoUpdateCertEnrollmentServer;
    private IpSecFilesElement ipsecFiles = null;
    private IpSecEnrollmentDataElement ipsecEnrollmentData = null;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.type = super.getRequiredAttribute(attributes, TYPE);
        this.userLabel = super.getOptionalAttribute(attributes, USER_LABEL, "");
        this.certExpirWarnTime = super.getOptionalAttribute(attributes, CERT_EXPIR_WARN_TIME, "90");
        this.autoUpdateCertEnrollmentServer = super.getOptionalAttribute(attributes, AUTO_UPDATE_CERT_ENROLLMENT_SERVER, "");
        this.validateAttributes();
    }

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("ipsecEnrollmentData".equalsIgnoreCase(string2)) {
            this.ipsecEnrollmentData = stackElement = new IpSecEnrollmentDataElement();
        } else if ("ipsecFiles".equalsIgnoreCase(string2)) {
            stackElement = new IpSecFilesElement();
            this.ipsecFiles = (IpSecFilesElement)stackElement;
        }
        return stackElement;
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        if (!this.type.equalsIgnoreCase("traffic") && !this.type.equalsIgnoreCase("oam")) {
            throw new SecurityActivationInputException("Wrong value for attribute \"type\" in IpSec element, type = \"" + this.type + "\", attribute must be one of \"Traffic\"or \"OAM \"in IpSec element");
        }
        int n = Integer.parseInt(this.certExpirWarnTime.trim());
        if (n < 2 || n > 365) {
            throw new SecurityActivationInputException("attribute certExpirWarnTime in IpSec element out of range ");
        }
        if (!(this.type.equals("") || this.type.equalsIgnoreCase(OAM_TYPE) || this.type.equalsIgnoreCase(TRAFFIC_TYPE))) {
            throw new SecurityActivationInputException("The type attribute in IpSec element has invalid value ");
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.ipsecFiles == null || this.ipsecEnrollmentData == null) {
            throw new SecurityActivationInputException("The ipsec element is not consistent - it must contain the ipsecFiles, and ipsecEnrollmentData elements");
        }
        this.ipsecFiles.checkConsistency();
        this.ipsecEnrollmentData.checkConsistency();
    }

    public IpSecEnrollmentData getEnrollmentData() {
        return this.ipsecEnrollmentData;
    }

    public Integer getCertExpirWarnTime() {
        return Integer.valueOf(this.certExpirWarnTime);
    }

    public IpSecFiles getFiles() {
        return this.ipsecFiles;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public String getType() {
        return this.type;
    }

    public String getAutoUpdateCertEnrollmentServer() {
        return this.autoUpdateCertEnrollmentServer;
    }
}

