/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.parser;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.SecurityConfigurationModel;
import se.ericsson.security.cppsec.esa.model.SecurityConfigurationModelFactory;
import se.ericsson.security.cppsec.esa.model.elements.SecConfDataElement;
import se.ericsson.security.cppsec.esa.parser.InitialSecConfData;
import se.ericsson.security.cppsec.esa.parser.StackElement;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class IscfEventHandler
extends DefaultHandler {
    private SecConfDataElement secConfElement;
    private StringBuffer buffer;
    private Stack context;
    private StackElement currentElement = null;
    public InitialSecConfData initialSecConfData = null;
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    private SecurityConfigurationModel model;

    public void startDocument() throws SAXException {
        this.buffer = new StringBuffer();
        this.context = new Stack();
    }

    public void endDocument() throws SAXException {
        this.buffer = null;
        this.context = null;
        if (this.secConfElement != null) {
            this.model = SecurityConfigurationModelFactory.createModel(this.secConfElement);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(", ").append(attributes.getQName(i)).append('=').append(attributes.getValue(i));
        }
        this.logger.trace(1, "Received startElement " + this.getTagPath() + "/" + string2 + stringBuffer.toString());
        try {
            if (string2.equalsIgnoreCase("InitialSecConfData")) {
                this.initialSecConfData = new InitialSecConfData();
                this.initialSecConfData.fetchAttributes(attributes);
                this.context.push(this.initialSecConfData);
            } else if (string2.equalsIgnoreCase("secConfData")) {
                this.secConfElement = new SecConfDataElement();
                this.secConfElement.fetchAttributes(attributes);
                this.context.push(this.secConfElement);
            } else {
                StackElement stackElement = (StackElement)this.context.peek();
                this.currentElement = stackElement.startElement(string, string2, string3, attributes);
                this.context.push(this.currentElement);
            }
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            throw new SAXException(securityActivationInputException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentElement = (StackElement)this.context.pop();
        String string4 = this.buffer.toString().trim();
        if ("".equals(string4)) {
            this.logger.trace(1, "Received endElement " + this.getTagPath() + ":value=null");
        } else {
            this.logger.trace(1, "Received endElement " + this.getTagPath() + ":value=" + string4);
            this.currentElement.setValue(string4);
        }
        this.currentElement.endElement();
        try {
            this.currentElement.evaluate();
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            throw new SAXException(securityActivationInputException);
        }
        this.flushText();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    private String getTagPath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.context.size(); ++i) {
            stringBuffer.append('/').append(((StackElement)this.context.elementAt(i)).getShortName());
        }
        return stringBuffer.toString();
    }

    protected void flushText() {
        this.buffer.setLength(0);
    }

    public SecurityConfigurationModel getModel() {
        return this.model;
    }
}

