/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.proxy;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.security.cppsec.esa.EsaDataVerification;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.proxy.EsaProxy;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverCalculateHmacReq;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverCalculateHmacRsp;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverDecryptReq;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverDecryptRsp;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverGetSshRsaKeyReq;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverGetSshRsaKeyRsp;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverRunCmdReq;
import se.ericsson.security.cppsec.esa.proxy.IpomCryptoserverRunCmdRsp;

public class EsaProxyImpl
implements EsaProxy {
    private OseProcess cipherProcess = null;
    private static final String CIPHER_PROCESS_NAME = "IPOM_CRYPTOSERVER_SERVICE_NAME";

    protected EsaProxyImpl() {
    }

    protected void findCipherProcess() throws SecurityActivationException {
        if (this.cipherProcess == null) {
            this.cipherProcess = OseNameServer.lookup((String)CIPHER_PROCESS_NAME);
            if (this.cipherProcess == null) {
                throw new SecurityActivationException("Service for deciphering not available!");
            }
        }
    }

    public byte[] decipher(String string, String string2, int n, String string3, String string4, String string5) throws SecurityActivationException {
        this.findCipherProcess();
        IpomCryptoserverDecryptReq ipomCryptoserverDecryptReq = new IpomCryptoserverDecryptReq(string, string2, n, string3, string4, string5);
        IpomCryptoserverDecryptRsp ipomCryptoserverDecryptRsp = (IpomCryptoserverDecryptRsp)SignalHelper.sendAndReceive((OseProcess)this.cipherProcess, (Signal)ipomCryptoserverDecryptReq, (Class)IpomCryptoserverDecryptRsp.class, (int)30000);
        if (ipomCryptoserverDecryptRsp == null) {
            throw new SecurityActivationException("Deciphering operation failed! Result =  Timeout.");
        }
        if (ipomCryptoserverDecryptRsp.getResult() != 0L) {
            throw new SecurityActivationException("Deciphering operation failed! Result = " + ipomCryptoserverDecryptRsp.getResult());
        }
        return ipomCryptoserverDecryptRsp.getData();
    }

    public byte[] calculateHmacSha1(String string, String string2) throws SecurityActivationException {
        this.findCipherProcess();
        byte[] byArray = EsaDataVerification.calculateSha1(string2);
        IpomCryptoserverCalculateHmacReq ipomCryptoserverCalculateHmacReq = new IpomCryptoserverCalculateHmacReq(byArray, string);
        IpomCryptoserverCalculateHmacRsp ipomCryptoserverCalculateHmacRsp = (IpomCryptoserverCalculateHmacRsp)SignalHelper.sendAndReceive((OseProcess)this.cipherProcess, (Signal)ipomCryptoserverCalculateHmacReq, (Class)IpomCryptoserverCalculateHmacRsp.class, (int)30000);
        if (ipomCryptoserverCalculateHmacRsp == null) {
            throw new SecurityActivationException("Could not calculate HMAC-SHA1. Result =  Timeout.");
        }
        if (ipomCryptoserverCalculateHmacRsp.getResult() != 0L) {
            throw new SecurityActivationException("Could not calculate HMAC-SHA1. Result = " + ipomCryptoserverCalculateHmacRsp.getResult());
        }
        return ipomCryptoserverCalculateHmacRsp.getData();
    }

    public int runCommand(String string) throws SecurityActivationException {
        this.findCipherProcess();
        IpomCryptoserverRunCmdReq ipomCryptoserverRunCmdReq = new IpomCryptoserverRunCmdReq(string);
        IpomCryptoserverRunCmdRsp ipomCryptoserverRunCmdRsp = (IpomCryptoserverRunCmdRsp)SignalHelper.sendAndReceive((OseProcess)this.cipherProcess, (Signal)ipomCryptoserverRunCmdReq, (Class)IpomCryptoserverRunCmdRsp.class, (int)100000);
        if (ipomCryptoserverRunCmdRsp == null) {
            throw new SecurityActivationException("Failed to execute command! Timeout.");
        }
        long l = ipomCryptoserverRunCmdRsp.getStatus();
        if (l != 0L && l != 5L) {
            throw new SecurityActivationException("Failed to execute command!Command Status: " + ipomCryptoserverRunCmdRsp.getStatusMessage(l));
        }
        return (int)ipomCryptoserverRunCmdRsp.getResult();
    }

    public String getSshRsaKey() throws SecurityActivationException {
        this.findCipherProcess();
        IpomCryptoserverGetSshRsaKeyReq ipomCryptoserverGetSshRsaKeyReq = new IpomCryptoserverGetSshRsaKeyReq();
        IpomCryptoserverGetSshRsaKeyRsp ipomCryptoserverGetSshRsaKeyRsp = (IpomCryptoserverGetSshRsaKeyRsp)SignalHelper.sendAndReceive((OseProcess)this.cipherProcess, (Signal)ipomCryptoserverGetSshRsaKeyReq, (Class)IpomCryptoserverGetSshRsaKeyRsp.class, (int)30000);
        if (ipomCryptoserverGetSshRsaKeyRsp == null) {
            throw new SecurityActivationException("The get operation for the public ssh/rsa key failed! Result =  Timeout.");
        }
        if (ipomCryptoserverGetSshRsaKeyRsp.getResult() != 0L) {
            throw new SecurityActivationException("The get operation for the public ssh/rsa key failed! Result = " + ipomCryptoserverGetSshRsaKeyRsp.getResult());
        }
        return ipomCryptoserverGetSshRsaKeyRsp.getSshRsaKey();
    }
}

