/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.BlockCipherDES;
import com.ibm.j9.jce.provider.BlockCipherSpi;
import com.ibm.j9.jce.provider.CipherSpiJ9;
import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.SecretKeyDES;
import com.ibm.j9.jce.provider.pkcs.PKCS5;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class CipherP5MD5DES
extends CipherSpiJ9 {
    protected BlockCipherSpi cipherImpl;
    protected byte[] salt;
    protected char[] password;
    protected int iterationCount;
    protected SecureRandom secureRandom;
    protected static final int BLOCK_SIZE = 8;
    protected static final int DEFAULT_ITERATIONS = 1000;
    static /* synthetic */ Class class$0;

    protected int getModeID(String mode) {
        if (mode.equalsIgnoreCase("CBC")) {
            return 0;
        }
        return -1;
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!"PKCS5Padding".equalsIgnoreCase(padding)) {
            throw new NoSuchPaddingException();
        }
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int inputLength) {
        this.validateState();
        return this.cipherImpl.engineGetOutputSize(inputLength);
    }

    protected byte[] engineGetIV() {
        if (this.cipherImpl != null) {
            return this.cipherImpl.engineGetIV();
        }
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        PBEParameterSpec spec = new PBEParameterSpec(this.salt, this.iterationCount);
        AlgorithmParameters ap = null;
        try {
            ap = this.getAlgorithmParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        try {
            ap.init(spec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        return ap;
    }

    protected AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameters.getInstance("PBEWithMD5AndDES", "J9JCE");
    }

    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            try {
                this.init(opMode, random, pbeKey.getPassword(), pbeKey.getSalt(), pbeKey.getIterationCount());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException();
            }
        } else {
            throw new InvalidKeyException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEKey pbeKey = null;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException();
        }
        pbeKey = (PBEKey)key;
        if (params != null) {
            if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException(Msg.getString("JCP013"));
            PBEParameterSpec pbeParams = (PBEParameterSpec)params;
            this.init(opMode, random, pbeKey.getPassword(), pbeParams.getSalt(), pbeParams.getIterationCount());
            return;
        } else {
            this.init(opMode, random, pbeKey.getPassword(), pbeKey.getSalt(), pbeKey.getIterationCount());
        }
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEKey pbeKey = null;
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException();
        }
        pbeKey = (PBEKey)key;
        if (params != null) {
            PBEParameterSpec pbeParams;
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.crypto.spec.PBEParameterSpec");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                pbeParams = (PBEParameterSpec)params.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException();
            }
            this.init(opMode, random, pbeKey.getPassword(), pbeParams.getSalt(), pbeParams.getIterationCount());
        } else {
            this.init(opMode, random, pbeKey.getPassword(), pbeKey.getSalt(), pbeKey.getIterationCount());
        }
    }

    protected byte[] engineUpdate(byte[] input, int start, int inputLen) {
        this.validateState();
        return this.cipherImpl.engineUpdate(input, start, inputLen);
    }

    protected int engineUpdate(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException {
        this.validateState();
        return this.cipherImpl.engineUpdate(input, start, inputLen, output, outputStart);
    }

    protected byte[] engineDoFinal(byte[] input, int start, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        return this.cipherImpl.engineDoFinal(input, start, inputLen);
    }

    protected int engineDoFinal(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        return this.cipherImpl.engineDoFinal(input, start, inputLen, output, outputStart);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] keyBytes;
        if (this.operationMode != 4) {
            throw new IllegalStateException();
        }
        try {
            keyBytes = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException();
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException();
        }
        if (keyType == 3) {
            try {
                PBEKeySpec keySpec = new PBEKeySpec(this.password, this.salt, this.iterationCount);
                SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
                SecretKey key = factory.generateSecret(keySpec);
                return key;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException();
            }
        }
        if (keyType == 1) {
            PublicKey key;
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            try {
                key = factory.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException();
            }
            return key;
        }
        if (keyType == 2) {
            PrivateKey key;
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            try {
                key = factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException();
            }
            return key;
        }
        throw new IllegalArgumentException();
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.operationMode != 3) {
            throw new IllegalStateException();
        }
        byte[] keyBytes = key.getEncoded();
        byte[] result = null;
        try {
            result = this.engineDoFinal(keyBytes, 0, keyBytes.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException();
        }
        return result;
    }

    private void init(int opMode, SecureRandom sr, char[] password, byte[] salt, int iterationCount) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.operationMode = opMode;
        this.secureRandom = sr;
        this.password = password;
        if (!(opMode != 2 && opMode != 4 || salt != null && salt.length == 8 && iterationCount >= 1)) {
            throw new InvalidAlgorithmParameterException("JCP004");
        }
        if (iterationCount < 0) {
            throw new InvalidKeyException(Msg.getString("JCP014"));
        }
        this.iterationCount = iterationCount == 0 ? 1000 : iterationCount;
        if (salt != null) {
            this.salt = salt;
        } else {
            this.salt = new byte[8];
            this.secureRandom.nextBytes(this.salt);
        }
        byte[] keyAndIVMaterial = this.getKeyMaterialAndIV();
        if (keyAndIVMaterial == null) {
            throw new InvalidKeyException(Msg.getString("JCP015"));
        }
        byte[] keyMaterial = new byte[this.getKeyMaterialSize()];
        System.arraycopy(keyAndIVMaterial, 0, keyMaterial, 0, this.getKeyMaterialSize());
        SecretKey key = this.createKey(keyMaterial);
        IvParameterSpec parameters = new IvParameterSpec(keyAndIVMaterial, this.getKeyMaterialSize(), 8);
        try {
            this.cipherImpl = this.getCipher();
            this.cipherImpl.engineSetMode("CBC");
            this.cipherImpl.engineSetPadding("PKCS5Padding");
            this.cipherImpl.engineInit(opMode, (Key)key, parameters, sr);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(Msg.getString("JCP015"));
        }
    }

    protected SecretKey createKey(byte[] keyMaterial) {
        return new SecretKeyDES(keyMaterial);
    }

    protected BlockCipherSpi getCipher() {
        return new BlockCipherDES();
    }

    protected int getKeyMaterialSize() {
        return 8;
    }

    protected byte[] getKeyMaterialAndIV() {
        return PKCS5.PKCS5_PBKDF1("MD5", this.password, this.salt, this.iterationCount, this.getKeyMaterialSize() + 8);
    }

    protected void validateState() throws IllegalStateException {
        if (this.cipherImpl == null) {
            throw new IllegalStateException();
        }
    }

    protected void reset() {
    }

    protected Key validateKey(Key key, int opMode2) throws InvalidKeyException {
        return null;
    }
}

