/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.ibm.j9.jsse.support.Msg;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactory {
    private final TrustManagerFactorySpi impl;
    private final Provider provider;
    private final String algorithm;
    private static final String TRUSTMANAGERFACTORY_PREFIX = "TrustManagerFactory.";
    private static final String TRUSTMANAGERFACTORY_DEFAULT_ALGORITHM_NAME = "IBMJ9X509";
    private static final String configuredDefaultAlgorithmName = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.TRUSTMANAGERFACTORY_DEFAULT_ALGORITHM_NAME);
        }
    });

    protected TrustManagerFactory(TrustManagerFactorySpi tmFactImpl, Provider provider, String algorithm) {
        this.impl = tmFactImpl;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final String getDefaultAlgorithm() {
        return configuredDefaultAlgorithmName;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final TrustManagerFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers;
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03bd"));
        }
        try {
            providers = Security.getProviders(TRUSTMANAGERFACTORY_PREFIX + algorithm);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new NoSuchAlgorithmException(Msg.getString("K03b5", algorithm));
        }
        if (providers == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03b5", algorithm));
        }
        return TrustManagerFactory.getInstance(algorithm, providers[0]);
    }

    public static final TrustManagerFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider == "") {
            throw new IllegalArgumentException(Msg.getString("K03b6"));
        }
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c4"));
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("K03b7", provider));
        }
        return TrustManagerFactory.getInstance(algorithm, p);
    }

    public static final TrustManagerFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Msg.getString("K03b6"));
        }
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c4"));
        }
        String className = provider.getProperty(TRUSTMANAGERFACTORY_PREFIX + algorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c2", algorithm, provider.getName()));
        }
        Class<?> generatorClass = null;
        try {
            generatorClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        TrustManagerFactorySpi implementationClass = null;
        try {
            implementationClass = (TrustManagerFactorySpi)generatorClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new TrustManagerFactory(implementationClass, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyStore keyStore) throws KeyStoreException {
        this.impl.engineInit(keyStore);
    }

    public final void init(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        this.impl.engineInit(params);
    }

    public final TrustManager[] getTrustManagers() {
        return this.impl.engineGetTrustManagers();
    }
}

