/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.framework;

import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;

public class SignedIntArrayParameter
extends Parameter {
    private int[] arrayValue;

    public SignedIntArrayParameter(String string, int[] nArray) throws IllegalParameterValueException {
        super(string);
        if (nArray == null) {
            throw new IllegalParameterValueException("NULL not allowed");
        }
        this.arrayValue = nArray;
    }

    public int[] getValue() {
        return this.arrayValue;
    }

    public String getValueAsString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        int[] nArray = this.getValue();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(String.valueOf(nArray[i]));
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public Object[] getArrayValueAsObjects() {
        int[] nArray = this.getValue();
        int n = nArray.length;
        Object[] objectArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new Integer(nArray[i]);
        }
        return objectArray;
    }

    public void accept(ParameterVisitor parameterVisitor) throws Exception {
        parameterVisitor.visitSignedIntArrayParameter(this);
    }
}

