/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.HashMap;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.VpnInterfaceMoGen;
import se.ericsson.cello.ipsec.ipcp_vpni_mi;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;

public class VpnInterfaceMoImpl
extends VpnInterfaceMoGen
implements VpnInterfaceBuildIF,
IpHostLinkIpInterfaceBuildIF {
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(ipcp_vpni_mi.class);

    public VpnInterfaceMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
    }

    public VpnInterfaceMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = ((IpAccessHostEtMo)setRequestContext.getAttributeFromRequest("ipAccessHostEtRef")).getIpInterfaceMoRef(coordinator);
        int n2 = 0;
        if (managedObject instanceof IpInterfaceMo) {
            ManagedObject managedObject2 = managedObject;
            n = ((IpInterfaceMo)managedObject).getFroId(coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject2);
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            n = ((Ipv6InterfaceMo)managedObject).getFroId(coordinator);
            ManagedObject managedObject3 = (ManagedObject)managedObject.getAttribute("ethernetRef", coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject3);
        } else {
            throw new InvalidReferenceException("VpnInterface", "The referenced instance of IpAccessHostEt MO must refer to IpInterface MO or Ipv6Interface Mo");
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("autoDetectIpVersion", 0));
        setRequestContext.addParameter(this.froProxy, (Parameter)new UnsignedIntParameter("ipInterfaceFroId", (long)n));
        setRequestContext.addParameter(this.froProxy, (Parameter)new UnsignedIntParameter("piuFroId", (long)n2));
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("vpnInterfaceMoRdn", this.getRelativeDistinguishedName()));
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("networkPrefixLength") || setRequestContext.isIncludedInRequest("subnet")) {
            throw new AttrNotSettableException("networkPrefixLength/subnet", "VpnInterface");
        }
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("availabilityStatus");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: availabilityStatus", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalState");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: operationalState", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("subnet")) {
                signedIntParameter = (StringParameter)getRequestContextImpl.getParameter("subnet");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: subnet", "getAttributes", -1);
                }
                objectArray[i] = signedIntParameter.getValue();
            } else if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("networkPrefixLength");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: networkPrefixLength", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("pmOutDroppedPacketsPolicyControl")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmOutDroppedPacketsPolicyControl", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                signedIntParameter = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)signedIntParameter, (Coordinator)coordinator);
            } else if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("configurationMode")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("configurationMode");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: configurationMode", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else if (stringArray[i].equalsIgnoreCase("ipVersion")) {
                signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("ipVersion");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("VpnInterface", "Missing parameter from FRO: ipVersion", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntParameter.getValue());
            } else {
                throw new NoSuchAttributeException(stringArray[i], "VpnInterface");
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    protected void validateSubnet(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (!string.equals("")) {
            new IpAddress(string);
        }
    }

    public int getAutoDetectIpVersion(Coordinator coordinator) throws MoAccessException {
        SignedIntParameter signedIntParameter = (SignedIntParameter)this.froProxy.getAttribute(coordinator, this.getFroId(coordinator), "autoDetectIpVersion");
        return signedIntParameter.getValue();
    }

    public void setAutoDetectIpVersion(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkEnumAttribute((String)"autoDetectIpVersion", (int)n, (int[])AUTO_DETECT_IP_VERSION_VALUES, (String)"VpnInterface");
        SignedIntParameter signedIntParameter = new SignedIntParameter("autoDetectIpVersion", n);
        this.froProxy.setAttribute(coordinator, this.getFroId(coordinator), (Parameter)signedIntParameter);
    }

    public int getConnectedPiuFroId(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = ((IpAccessHostEtMo)this.getIpAccessHostEtRef(coordinator)).getIpInterfaceMoRef(coordinator);
        if (managedObject instanceof Ipv6InterfaceMo) {
            managedObject = ((Ipv6InterfaceMo)managedObject).getEthernetRef(coordinator);
        }
        return PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
    }

    public int getFroType(Coordinator coordinator) throws MoAccessException {
        return Integer.parseInt("A0B", 16);
    }

    public NetworkAddress getNetworkAddress(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"subnet", "networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return new NetworkAddress((String)objectArray[0], ((Integer)objectArray[1]).intValue());
    }

    public void helpAssignVpnAddress(int n, IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        if (n < 1 || n > 32) {
            throw new ValueOutOfRangeException("networkPrefixLength", "VpnInterface");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("networkPrefixLength", new SignedIntParameter("networkPrefixLength", n));
        hashMap.put("subnet", new StringParameter("subnet", ipAddress.getSubnetAddress(n).toString()));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        ManagedObject[] managedObjectArray;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("VpnInterface", "Cannot be reserved by 'null' reference");
        }
        if (this.getConfigurationMode(coordinator) == 1) {
            int n2;
            managedObjectArray = this.getReservedBy(coordinator);
            n = managedObjectArray.length;
            if (managedObject.getType().equalsIgnoreCase("IpAccessHostEt")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by IpHostLink MO.", "VpnInterface");
                }
            } else if (managedObject.getType().equalsIgnoreCase("IpHostLink")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (managedObjectArray[n2].getType().equalsIgnoreCase("IpAccessHostEt")) {
                        throw new MoNotPossibleToReserveException("This MO already reserved by IpAccessHostEt MO.", "VpnInterface");
                    }
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by another IpHostLink MO.", "VpnInterface");
                }
            }
        }
        managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObject instanceof IpHostLinkMo && managedObjectArray[n] instanceof IpHostLinkMo) {
                throw new MoNotPossibleToReserveException("Only one IpHostLink instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (managedObject instanceof IpAccessHostEtMo && managedObjectArray[n] instanceof IpAccessHostEtMo) {
                throw new MoNotPossibleToReserveException("Only one IpAccessHostEt instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (this.getConfigurationMode(coordinator) != 1 || !(managedObject instanceof IpSecTunnelMo) || !(managedObjectArray[n] instanceof IpSecTunnelMo)) continue;
            throw new MoNotPossibleToReserveException("Only one IpSecTunnelMo instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void checkIfIpAddressInSubnet(IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = this.getNetworkAddress(coordinator);
        ipAddress.validateIpAddrWithinSubnet(networkAddress.getNetworkPrefix(), new IpAddress(networkAddress.getSubnet()), "VpnInterface");
    }
}

