/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mao.TransactionListener;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Status;

public class TransactionWrapper {
    private Coordinator coordinator;
    private List resources;

    public TransactionWrapper(Coordinator coordinator, TransactionListener transactionListener) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
        try {
            coordinator.registerResource((Resource)new InternalResource(this, transactionListener));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw new TransactionRequiredException();
        }
        this.coordinator = coordinator;
        this.resources = new ArrayList();
    }

    public void register(Resource resource) throws TransactionRequiredException, NullPointerException {
        if (resource == null) {
            throw new NullPointerException("resource was null");
        }
        if (this.getCoordinator().getStatus() != Status.ACTIVE) {
            throw new TransactionRequiredException();
        }
        this.resources.add(resource);
    }

    public Iterator resources() {
        return this.resources.iterator();
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    private static class InternalResource
    implements Resource {
        private TransactionWrapper wrapper;
        private TransactionListener listener;

        public InternalResource(TransactionWrapper transactionWrapper, TransactionListener transactionListener) {
            this.wrapper = transactionWrapper;
            this.listener = transactionListener;
        }

        public boolean prepare() {
            Iterator iterator = this.wrapper.resources();
            while (iterator.hasNext()) {
                if (((Resource)iterator.next()).prepare()) continue;
                return false;
            }
            return true;
        }

        public void rollback() {
            Iterator iterator = this.wrapper.resources();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).rollback();
            }
            this.notifyListener();
        }

        public void commit() {
            Iterator iterator = this.wrapper.resources();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).commit();
            }
            this.notifyListener();
        }

        private void notifyListener() {
            if (this.listener != null) {
                this.listener.transactionDone(this.wrapper);
            }
        }
    }
}

