/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.mao.MapAction;
import se.ericsson.cello.mao.PutEntryAction;
import se.ericsson.cello.mao.RemoveEntryAction;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionWrapper;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class TransactionalFroIdMap {
    private Map storage;
    private TransactionHandler handler;

    public TransactionalFroIdMap(TransactionHandler transactionHandler) {
        this.handler = transactionHandler;
        this.storage = new HashMap();
    }

    public ManagedObject get(int n, Coordinator coordinator) throws TransactionRequiredException {
        Object object = this.storage.get(new Integer(n));
        if (coordinator != null) {
            Iterator iterator = this.getWrapper(coordinator).resources();
            while (iterator.hasNext()) {
                MapAction mapAction = (MapAction)iterator.next();
                object = mapAction.preview(n, object);
            }
        }
        return (ManagedObject)object;
    }

    public void put(int n, ManagedObject managedObject) {
        Integer n2 = new Integer(n);
        if (this.storage.containsKey(n2)) {
            MessageLog.traceError(this.getClass(), (String)("FroId " + n + " was already mapped to (" + ((ManagedObject)this.storage.get(n2)).getLocalDistinguishedName() + "), changed to (" + managedObject.getLocalDistinguishedName() + ")"));
        }
        this.storage.put(new Integer(n), managedObject);
    }

    public void put(int n, ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException {
        this.getWrapper(coordinator).register(new PutEntryAction(n, managedObject, this.storage));
    }

    public void remove(int n, Coordinator coordinator) throws TransactionRequiredException {
        this.getWrapper(coordinator).register(new RemoveEntryAction(n, this.storage));
    }

    private TransactionWrapper getWrapper(Coordinator coordinator) throws TransactionRequiredException {
        return this.handler.getTransaction(coordinator);
    }
}

