/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.ObjectLifeCycleEvent;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.ProxyAdapter;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.pmapp.fropxy.PmIndicationEvent;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Coordinator;

public class CelloScanner
extends BasicScanner
implements ActionListener {
    private Map motype2ProxyMap = new HashMap();
    private ObservationClass[] classes;
    private ObservationObject[] instances;
    private boolean isSubscribed;
    private PmAppPortal myPmAppPortal;
    private DataConsumer dataConsumer;
    private List listOfProxyAdapterConnectors = new ArrayList();

    public CelloScanner(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator, PmAppPortal pmAppPortal) throws OverloadException, GranularityAndAttributeActivationException, GenericPmFroProxyException {
        super(granularityPeriod, performanceMonitoringState, dataConsumer, string, coordinator);
        ObservationClass[] observationClassArray2 = ExtendedMoTypeHandler.convertToExtendedClasses(observationClassArray);
        ObservationObject[] observationObjectArray2 = ExtendedMoTypeHandler.convertToExtendedObjects(observationObjectArray);
        this.myPmAppPortal = pmAppPortal;
        this.classes = observationClassArray2;
        this.instances = observationObjectArray2;
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("constructor(): gp.inSeconds()=" + granularityPeriod.inSeconds() + ", label=" + string));
        this.createProxyAdapters(observationClassArray2, observationObjectArray2);
        this.validateProxyAdapters();
        this.registerForPmEvents(coordinator);
        this.setScannerState(performanceMonitoringState, coordinator);
        this.myPmAppPortal = pmAppPortal;
        this.dataConsumer = dataConsumer;
        new ObjectLifeCycleEvent(this.myPmAppPortal.getCelloScannerFactory(), this, true, coordinator);
    }

    public void delete(Coordinator coordinator) {
        new ObjectLifeCycleEvent(this.myPmAppPortal.getCelloScannerFactory(), this, false, coordinator);
        if (this.isSubscribed) {
            this.sendPmUnsubscribe(coordinator);
        }
        this.unregisterForPmEvents(coordinator);
        super.delete(coordinator);
    }

    public void scan() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"scan(): PMS expects data soon!");
        Iterator iterator = this.motype2ProxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next().getValue();
            proxyAdapter.scan();
        }
    }

    public boolean isSubscribed() {
        return this.isSubscribed;
    }

    public void setScannerState(PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException, GenericPmFroProxyException {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("setScannerState(): (state==ACTIVE)=" + (performanceMonitoringState.value() == 0) + " isSubscribed=" + this.isSubscribed));
        new ObjectLifeCycleEvent((ActionListener)this, performanceMonitoringState, coordinator);
        if (!this.isSubscribed && performanceMonitoringState.value() == 0) {
            this.sendPmSubscribe(coordinator);
        } else if (this.isSubscribed && performanceMonitoringState.value() == 1) {
            this.sendPmUnsubscribe(coordinator);
        }
        super.setScannerState(performanceMonitoringState, coordinator);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            try {
                MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("actionPerformed(): actionEvent.getID()=" + actionEvent.getID()));
                if (actionEvent.getID() == 100) {
                    this.handlePmIndication((PmIndicationEvent)actionEvent.getSource());
                    break block12;
                }
                if (actionEvent.getID() == 107 || actionEvent.getID() == 111 || actionEvent.getID() == 113) {
                    this.handleSubscribeUpdate((ManagedObject)actionEvent.getSource(), actionEvent.getID());
                    break block12;
                }
                if (actionEvent.getID() == 112 || actionEvent.getID() == 114) {
                    this.handleUnsubscribeUpdate((ManagedObject)actionEvent.getSource(), actionEvent.getID());
                    break block12;
                }
                if (actionEvent.getID() == 104) {
                    this.isSubscribed = true;
                    break block12;
                }
                if (actionEvent.getID() == 106) {
                    this.isSubscribed = false;
                    break block12;
                }
                if (actionEvent.getID() == 101) {
                    this.registerForPmEventsWhenCommitted();
                    break block12;
                }
                if (actionEvent.getID() == 102) {
                    this.rollbackScanner();
                    break block12;
                }
                if (actionEvent.getID() == 105) {
                    this.rollbackScanner();
                    break block12;
                }
                if (actionEvent.getID() == 103) {
                    this.unregisterForPmEventsWhenCommitted();
                    break block12;
                }
                if (actionEvent.getID() == 109 || actionEvent.getID() == 110) {
                    return;
                }
                MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("Received unknown event: " + actionEvent.getSource()));
                return;
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"Method actionPerformed() generated a runtime exception.", (Throwable)runtimeException);
                return;
            }
        }
    }

    private void handleSubscribeUpdate(ManagedObject managedObject, int n) {
        int n2 = -1;
        Map map = ExtendedMoTypeHandler.getMoTypeMap();
        List list = (List)map.get(managedObject.getType());
        for (int i = 0; i < list.size(); ++i) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(list.get(i));
            if (!this.isSubscribed || proxyAdapter == null) continue;
            MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("handleSubscribeUpdate(): subscribedMos =" + list.get(i) + ", proxyAdapter=" + proxyAdapter));
            n2 = Mo2FroIdTranslator.getFroId(managedObject, (String)list.get(i));
            if (n == 107) {
                proxyAdapter.subscribeUpdateMoCreation(n2, managedObject);
                continue;
            }
            if (n == 111) {
                proxyAdapter.subscribeUpdateCounterActivation(n2, managedObject);
                continue;
            }
            if (n == 113) {
                proxyAdapter.subscribeUpdatePdfActivation(n2, managedObject);
                continue;
            }
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("handleSubscribeUpdate(): Wrong eventId " + n));
        }
    }

    private void handleUnsubscribeUpdate(ManagedObject managedObject, int n) {
        int n2 = -1;
        Map map = ExtendedMoTypeHandler.getMoTypeMap();
        List list = (List)map.get(managedObject.getType());
        for (int i = 0; i < list.size(); ++i) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(list.get(i));
            if (!this.isSubscribed || proxyAdapter == null) continue;
            MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("handleUnsubscribeUpdate(): unsubscribedMos =" + list.get(i) + ", proxyAdapter=" + proxyAdapter));
            n2 = Mo2FroIdTranslator.getFroId(managedObject, (String)list.get(i));
            if (n == 112) {
                proxyAdapter.unsubscribeUpdateCounterActivation(n2, managedObject);
                continue;
            }
            if (n == 114) {
                proxyAdapter.unsubscribeUpdatePdfActivation(n2, managedObject);
                continue;
            }
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("handleUnsubscribeUpdate(): Wrong eventId " + n));
        }
    }

    boolean isActivated(ManagedObject managedObject) {
        try {
            return ((GenPmMao)managedObject).getCounterActivation(null);
        }
        catch (PmAppException pmAppException) {
            return true;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ProxyAdapter.class, (String)"isActivated()", (Throwable)moAccessException);
            return false;
        }
    }

    public void handlePmIndication(PmIndicationEvent pmIndicationEvent) {
        int n;
        ProxyAdapter proxyAdapter;
        String string;
        int n2;
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("handlePmIndication(): event=" + pmIndicationEvent));
        ArrayList<MeasuredData> arrayList = new ArrayList<MeasuredData>();
        GenericPmFroProxy genericPmFroProxy = pmIndicationEvent.getPmFroProxy();
        List list = this.getProxyAdapters(genericPmFroProxy);
        for (n2 = 0; n2 < this.instances.length; ++n2) {
            String[] stringArray = this.instances[n2].instance_list;
            string = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(stringArray[0]);
            String[] stringArray2 = this.instances[n2].instance_attribute_list;
            proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(string);
            MeasuredData[] measuredDataArray = pmIndicationEvent.getMeasuredDataForMo(proxyAdapter.filterAttributes(stringArray2, true), stringArray, proxyAdapter.getMiAttributeHandler());
            if (measuredDataArray == null) continue;
            for (n = 0; n < measuredDataArray.length; ++n) {
                arrayList.add(measuredDataArray[n]);
            }
        }
        for (n2 = 0; n2 < this.classes.length; ++n2) {
            string = this.classes[n2].object_class_name;
            String[] stringArray = this.classes[n2].class_attribute_list;
            proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(string);
            MeasuredData[] measuredDataArray = pmIndicationEvent.getMeasuredDataForMoType(proxyAdapter.filterAttributes(stringArray, true), string, list, proxyAdapter.getMiAttributeHandler());
            if (measuredDataArray == null) continue;
            for (n = 0; n < measuredDataArray.length; ++n) {
                arrayList.add(measuredDataArray[n]);
            }
        }
        MeasuredData[] measuredDataArray = new MeasuredData[arrayList.size()];
        arrayList.toArray(measuredDataArray);
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("handlePmIndication(): measuredDataList.size()=" + arrayList.size()));
        this.dataConsumer.push(measuredDataArray, this.getSeqNo());
    }

    public void handleHighCapacityPmIndication(PmIndicationEvent pmIndicationEvent) {
        int n;
        ProxyAdapter proxyAdapter;
        String string;
        int n2;
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"handleHighCapacityPmIndication()");
        ArrayList<MeasuredData> arrayList = new ArrayList<MeasuredData>();
        GenericPmFroProxy genericPmFroProxy = pmIndicationEvent.getPmFroProxy();
        List list = this.getProxyAdapters(genericPmFroProxy);
        for (n2 = 0; n2 < this.instances.length; ++n2) {
            String[] stringArray = this.instances[n2].instance_list;
            string = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(stringArray[0]);
            String[] stringArray2 = this.instances[n2].instance_attribute_list;
            proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(string);
            MeasuredData[] measuredDataArray = pmIndicationEvent.getHighCapPMMeasuredDataForMo(proxyAdapter.filterAttributes(stringArray2, false), stringArray, proxyAdapter.getMiAttributeHandler());
            if (measuredDataArray == null) continue;
            for (n = 0; n < measuredDataArray.length; ++n) {
                arrayList.add(measuredDataArray[n]);
            }
        }
        for (n2 = 0; n2 < this.classes.length; ++n2) {
            string = this.classes[n2].object_class_name;
            String[] stringArray = this.classes[n2].class_attribute_list;
            proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(string);
            MeasuredData[] measuredDataArray = pmIndicationEvent.getHighCapPMMeasuredDataForMoType(proxyAdapter.filterAttributes(stringArray, false), string, list, proxyAdapter.getMiAttributeHandler());
            if (measuredDataArray == null) continue;
            for (n = 0; n < measuredDataArray.length; ++n) {
                arrayList.add(measuredDataArray[n]);
            }
        }
        MeasuredData[] measuredDataArray = new MeasuredData[arrayList.size()];
        arrayList.toArray(measuredDataArray);
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("handlePmIndication(): measuredDataList.size()=" + arrayList.size()));
        this.dataConsumer.push(measuredDataArray, this.getSeqNo());
    }

    private void createProxyAdapters(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) throws GenericPmFroProxyException {
        int n;
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("createProxyAdapters(): classes.length=" + observationClassArray.length + ", instances.length=" + observationObjectArray.length));
        for (n = 0; n < observationClassArray.length; ++n) {
            String string = observationClassArray[n].object_class_name;
            String[] stringArray = observationClassArray[n].class_attribute_list;
            if (!this.motype2ProxyMap.containsKey(string)) {
                GenericPmFroProxy genericPmFroProxy = this.myPmAppPortal.getGenericPmFroProxyFactory().lookupByMoType(string);
                if (genericPmFroProxy == null) {
                    throw new RuntimeException("PM FRO proxy could not be found for mo type=" + string + ". Scanner creation fails.");
                }
                ProxyAdapter proxyAdapter = new ProxyAdapter(this, genericPmFroProxy, this.granularityPeriod);
                proxyAdapter.setObservationClass(string);
                this.motype2ProxyMap.put(string, proxyAdapter);
                this.addProxyAdapter(genericPmFroProxy, proxyAdapter);
            }
            ((ProxyAdapter)this.motype2ProxyMap.get(string)).addAttributes(stringArray);
        }
        for (n = 0; n < observationObjectArray.length; ++n) {
            String string = observationObjectArray[n].instance_list[0];
            String string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(string);
            String[] stringArray = observationObjectArray[n].instance_attribute_list;
            if (!this.motype2ProxyMap.containsKey(string2)) {
                GenericPmFroProxy genericPmFroProxy = this.myPmAppPortal.getGenericPmFroProxyFactory().lookupByDistinguishedName(string);
                if (genericPmFroProxy == null) {
                    throw new RuntimeException("PM FRO proxy could not be found for dn=" + string + ". Scanner creation fails.");
                }
                ProxyAdapter proxyAdapter = new ProxyAdapter(this, genericPmFroProxy, this.granularityPeriod);
                this.motype2ProxyMap.put(string2, proxyAdapter);
                this.addProxyAdapter(genericPmFroProxy, proxyAdapter);
            }
            ProxyAdapter proxyAdapter = (ProxyAdapter)this.motype2ProxyMap.get(string2);
            proxyAdapter.addAttributes(stringArray);
            for (int i = 0; i < observationObjectArray[n].instance_list.length; ++i) {
                proxyAdapter.addObservationInstance(observationObjectArray[n].instance_list[i]);
            }
        }
    }

    private void rollbackScanner() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"rollbackScanner()");
        Iterator iterator = this.motype2ProxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next().getValue();
            proxyAdapter.rollbackAdapter();
        }
    }

    private void validateProxyAdapters() throws GenericPmFroProxyException {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("validateProxyAdapters(): motype2ProxyMap.size()=" + this.motype2ProxyMap.size()));
        Iterator iterator = this.motype2ProxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next().getValue();
            proxyAdapter.validate();
        }
    }

    private void registerForPmEvents(Coordinator coordinator) {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("registerForPmEvents(): c=" + coordinator));
        if (coordinator != null) {
            new ObjectLifeCycleEvent(this, this, true, coordinator);
        } else {
            this.registerForPmEventsWhenCommitted();
        }
    }

    private void registerForPmEventsWhenCommitted() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("registerForPmEventsWhenCommitted(): motype2ProxyMap.size()=" + this.motype2ProxyMap.size()));
        Iterator iterator = this.getListOfFirstProxyAdapterForEachConnector().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next();
            proxyAdapter.addActionListener(this);
        }
    }

    private void unregisterForPmEvents(Coordinator coordinator) {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("unregisterForPmEvents(): c=" + coordinator));
        if (coordinator != null) {
            new ObjectLifeCycleEvent(this, this, false, coordinator);
        } else {
            this.unregisterForPmEventsWhenCommitted();
        }
    }

    private void unregisterForPmEventsWhenCommitted() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("unregisterForPmEventsWhenCommitted(): motype2ProxyMap.size()=" + this.motype2ProxyMap.size()));
        Iterator iterator = this.getListOfFirstProxyAdapterForEachConnector().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next();
            proxyAdapter.removeActionListener(this);
        }
    }

    private void sendPmSubscribe(Coordinator coordinator) throws GranularityAndAttributeActivationException, GenericPmFroProxyException {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("sendPmSubscribe(): motype2ProxyMap.size()=" + this.motype2ProxyMap.size()));
        Iterator iterator = this.motype2ProxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next().getValue();
            try {
                proxyAdapter.subscribe(coordinator);
            }
            catch (GenericPmFroProxyException genericPmFroProxyException) {
                if (genericPmFroProxyException.getResultCode() == 2) {
                    throw new GranularityAndAttributeActivationException(proxyAdapter.getObservationClasses());
                }
                throw genericPmFroProxyException;
            }
        }
    }

    private void sendPmUnsubscribe(Coordinator coordinator) throws GenericPmFroProxyException {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("sendPmUnsubscribe(): motype2ProxyMap.size()=" + this.motype2ProxyMap.size()));
        Iterator iterator = this.motype2ProxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ProxyAdapter proxyAdapter = (ProxyAdapter)iterator.next().getValue();
            proxyAdapter.unsubscribe(coordinator);
        }
    }

    public PerformanceMonitoringState getScannerState() {
        return super.getScannerState();
    }

    ObservationClass[] getObservationClassList() {
        return this.classes;
    }

    ObservationObject[] getObservationObjectList() {
        return this.instances;
    }

    public List getListOfFirstProxyAdapterForEachConnector() {
        ArrayList<ProxyAdapter> arrayList = new ArrayList<ProxyAdapter>();
        ProxyAdapterConnector proxyAdapterConnector = null;
        List list = null;
        ProxyAdapter proxyAdapter = null;
        Iterator iterator = this.listOfProxyAdapterConnectors.iterator();
        while (iterator.hasNext()) {
            proxyAdapterConnector = (ProxyAdapterConnector)iterator.next();
            list = proxyAdapterConnector.getListOfProxyAdapters();
            proxyAdapter = (ProxyAdapter)list.iterator().next();
            arrayList.add(proxyAdapter);
        }
        return arrayList;
    }

    private void addProxyAdapter(GenericPmFroProxy genericPmFroProxy, ProxyAdapter proxyAdapter) {
        Iterator iterator = this.listOfProxyAdapterConnectors.iterator();
        boolean bl = true;
        ProxyAdapterConnector proxyAdapterConnector = null;
        while (iterator.hasNext()) {
            proxyAdapterConnector = (ProxyAdapterConnector)iterator.next();
            if (proxyAdapterConnector.pmFroProxy != genericPmFroProxy) continue;
            bl = false;
            break;
        }
        if (bl) {
            proxyAdapterConnector = new ProxyAdapterConnector(genericPmFroProxy);
            this.listOfProxyAdapterConnectors.add(proxyAdapterConnector);
        }
        proxyAdapterConnector.addProxyAdapter(proxyAdapter);
    }

    private List getProxyAdapters(GenericPmFroProxy genericPmFroProxy) {
        Iterator iterator = this.listOfProxyAdapterConnectors.iterator();
        ProxyAdapterConnector proxyAdapterConnector = null;
        while (iterator.hasNext() && (proxyAdapterConnector = (ProxyAdapterConnector)iterator.next()).pmFroProxy != genericPmFroProxy) {
        }
        return proxyAdapterConnector.getListOfProxyAdapters();
    }

    static class ProxyAdapterConnector {
        private GenericPmFroProxy pmFroProxy;
        private List listOfProxyAdapter = new ArrayList();

        public ProxyAdapterConnector(GenericPmFroProxy genericPmFroProxy) {
            this.pmFroProxy = genericPmFroProxy;
        }

        public GenericPmFroProxy getPmFroProxy() {
            return this.pmFroProxy;
        }

        public void addProxyAdapter(ProxyAdapter proxyAdapter) {
            this.listOfProxyAdapter.add(proxyAdapter);
        }

        public List getListOfProxyAdapters() {
            return this.listOfProxyAdapter;
        }
    }
}

