/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.support.debug.MessageLog;

public class Mo2FroIdTranslator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getFroIds(String string) {
        Object object;
        String string2 = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string);
        MoIterator moIterator = MoRepository.instance().lookupType(string2);
        if (moIterator == null) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            while (moIterator.hasMoreElements()) {
                object = moIterator.nextMo();
                if (object.isCreated()) {
                    GenPmMao genPmMao = (GenPmMao)object;
                    if (genPmMao.hasPdfActivationAttribute()) {
                        arrayList.add(new Integer(genPmMao.getPmFroId(string, null)));
                        continue;
                    }
                    if (genPmMao.hasCounterActivationAttribute()) {
                        try {
                            if (!genPmMao.getCounterActivation(null)) continue;
                            arrayList.add(new Integer(genPmMao.getPmFroId(string, null)));
                        }
                        catch (PmAppException pmAppException) {}
                        continue;
                    }
                    arrayList.add(new Integer(genPmMao.getPmFroId(string, null)));
                    continue;
                }
                MessageLog.info((String)("Mo with LDN " + object.getLocalDistinguishedName() + " is NOT yet created"));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)Mo2FroIdTranslator.class, (String)"getFroId()", (Throwable)moAccessException);
        }
        object = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            object[n] = (ManagedObject)((Integer)arrayList.get(n));
            ++n;
        }
        return object;
    }

    public static int[] getFroIds(Set set) {
        Object object;
        Iterator iterator = set.iterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        GenPmMao genPmMao = null;
        String string = null;
        String string2 = null;
        ManagedObject managedObject = null;
        try {
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException("Bad type in Set.");
                }
                string = (String)object;
                string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(string);
                String string3 = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string2);
                String string4 = ExtendedMoTypeHandler.replaceMoTypeinDistinguishedName(string3, string);
                genPmMao = (GenPmMao)MoRepository.instance().lookup(string4);
                managedObject = MoRepository.instance().lookup(string4);
                if (genPmMao == null) {
                    MessageLog.info((Class)(class$se$ericsson$cello$pmapp$fropxy$Mo2FroIdTranslator == null ? Mo2FroIdTranslator.class$("se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator") : class$se$ericsson$cello$pmapp$fropxy$Mo2FroIdTranslator), (String)("getFroIds(): DN='" + string + "' does not exist."));
                    continue;
                }
                if (managedObject.isCreated()) {
                    arrayList.add(new Integer(genPmMao.getPmFroId(string2, null)));
                    continue;
                }
                MessageLog.info((String)("Mo with LDN " + managedObject.getLocalDistinguishedName() + " is NOT yet created"));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)Mo2FroIdTranslator.class, (String)"getFroId()", (Throwable)moAccessException);
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public static int getFroId(String string) {
        int n = -1;
        GenPmMao genPmMao = null;
        ManagedObject managedObject = null;
        String string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(string);
        String string3 = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string2);
        String string4 = ExtendedMoTypeHandler.replaceMoTypeinDistinguishedName(string3, string);
        managedObject = MoRepository.instance().lookup(string4);
        try {
            genPmMao = (GenPmMao)MoRepository.instance().lookup(string4);
            if (genPmMao == null) {
                return n;
            }
            if (managedObject.isCreated()) {
                n = genPmMao.getPmFroId(string2, null);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)Mo2FroIdTranslator.class, (String)"getFroId()", (Throwable)moAccessException);
        }
        return n;
    }

    public static int getFroId(ManagedObject managedObject, String string) {
        int n = -1;
        try {
            GenPmMao genPmMao = (GenPmMao)managedObject;
            if (managedObject.isCreated()) {
                n = genPmMao.getPmFroId(string, null);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)Mo2FroIdTranslator.class, (String)"getFroId()", (Throwable)moAccessException);
        }
        return n;
    }

    public static String extractMoTypeFromDistinguishedName(String string) {
        int n = string.lastIndexOf(44) + 1;
        int n2 = string.lastIndexOf(61);
        String string2 = string.substring(n, n2);
        return string2;
    }
}

