/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.seclev;

import se.ericsson.cello.seclev.SecurityEventException;

public class SecurityEvent {
    public static final int SECLEVEL_1 = 1;
    public static final int SECLEVEL_1_ROLLBACK = 2;
    public static final int SECLEVEL_2 = 3;
    public static final int SECLEVEL_2_ROLLBACK = 4;
    public static final int SECLEVEL_3 = 5;
    public static final int SECLEVEL_3_UNCONFIRMED = 6;
    private static final String SECLEVEL_UNDEFINED = "SECLEVEL_UNDEFINED";
    private final int oldSeclevel;
    private final int newSeclevel;
    private final boolean newNodecreds;
    private final boolean telnetFtpSecure;
    private final boolean targetMonitorSecure;
    private final boolean debugServerSecure;
    private final boolean fileTransferClientSecure;

    public SecurityEvent(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SecurityEventException {
        if (this.seclevelToString(n).equals(SECLEVEL_UNDEFINED)) {
            throw new SecurityEventException("Undefined security level supplied for parameter oldSeclevel: " + n);
        }
        if (this.seclevelToString(n2).equals(SECLEVEL_UNDEFINED)) {
            throw new SecurityEventException("Undefined security level supplied for parameter newSeclevel: " + n2);
        }
        this.oldSeclevel = n;
        this.newSeclevel = n2;
        this.newNodecreds = bl;
        this.telnetFtpSecure = bl2;
        this.targetMonitorSecure = bl3;
        this.debugServerSecure = bl4;
        this.fileTransferClientSecure = bl5;
    }

    public boolean equals(SecurityEvent securityEvent) {
        if (securityEvent == null) {
            return false;
        }
        return this.oldSeclevel == securityEvent.getOldSeclevel() && this.newSeclevel == securityEvent.getNewSeclevel() && this.newNodecreds == securityEvent.getNewNodecreds() && this.telnetFtpSecure == securityEvent.getTelnetFtpSecure() && this.targetMonitorSecure == securityEvent.getTargetMonitorSecure() && this.debugServerSecure == securityEvent.getDebugServerSecure() && this.fileTransferClientSecure == securityEvent.getFileTransferClientSecure();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SecurityEvent)) {
            return false;
        }
        return this.oldSeclevel == ((SecurityEvent)object).getOldSeclevel() && this.newSeclevel == ((SecurityEvent)object).getNewSeclevel() && this.newNodecreds == ((SecurityEvent)object).getNewNodecreds() && this.telnetFtpSecure == ((SecurityEvent)object).getTelnetFtpSecure() && this.targetMonitorSecure == ((SecurityEvent)object).getTargetMonitorSecure() && this.debugServerSecure == ((SecurityEvent)object).getDebugServerSecure() && this.fileTransferClientSecure == ((SecurityEvent)object).getFileTransferClientSecure();
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashcode not defined for class SecurityEvent");
    }

    public int getOldSeclevel() {
        return this.oldSeclevel;
    }

    public int getNewSeclevel() {
        return this.newSeclevel;
    }

    public boolean getNewNodecreds() {
        return this.newNodecreds;
    }

    public boolean getTelnetFtpSecure() {
        return this.telnetFtpSecure;
    }

    public boolean getTargetMonitorSecure() {
        return this.targetMonitorSecure;
    }

    public boolean getDebugServerSecure() {
        return this.debugServerSecure;
    }

    public boolean getFileTransferClientSecure() {
        return this.fileTransferClientSecure;
    }

    public String getOldSeclevelAsString() {
        return this.seclevelToString(this.oldSeclevel);
    }

    public String getNewSeclevelAsString() {
        return this.seclevelToString(this.newSeclevel);
    }

    private String seclevelToString(int n) {
        switch (n) {
            case 1: {
                return "SECLEVEL_1";
            }
            case 2: {
                return "SECLEVEL_1_ROLLBACK";
            }
            case 3: {
                return "SECLEVEL_2";
            }
            case 4: {
                return "SECLEVEL_2_ROLLBACK";
            }
            case 5: {
                return "SECLEVEL_3";
            }
            case 6: {
                return "SECLEVEL_3_UNCONFIRMED";
            }
        }
        return SECLEVEL_UNDEFINED;
    }
}

