/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import CelloAlarmIRPExtension.GetAllModifiedSeverity;
import CelloAlarmIRPExtension.RemoveSeverityConfiguration;
import CelloAlarmIRPExtension.SetSeverity;
import CelloAlarmIRPExtension.SeverityInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public final class SeverityConfiguration {
    private static SeverityConfiguration theInstance = new SeverityConfiguration();
    private static final String TABLE_NAME = "severity_config";
    private static final int TX_TIME = 600;
    private Map configurations = new Hashtable();
    private Map pKeys = new Hashtable();
    private int nextKey;

    static SeverityConfiguration instance() {
        return theInstance;
    }

    synchronized void setSeverity(String string, short s) throws SetSeverity {
        if (this.configurations.containsKey(string)) {
            this.updateDBEntry(Short.toString(s) + string, (Integer)this.pKeys.get(string));
        } else {
            this.createDBEntry(Short.toString(s) + string);
            this.configurations.put(string, new Short(s));
            this.pKeys.put(string, new Integer(this.nextKey));
        }
    }

    synchronized short getSeverity(String string) {
        if (this.configurations.size() == 0 || !this.configurations.containsKey(string)) {
            return 0;
        }
        return (Short)this.configurations.get(string);
    }

    synchronized SeverityInfo[] getAllSeverityConfigurations() throws GetAllModifiedSeverity {
        SeverityInfo[] severityInfoArray = null;
        if (this.configurations.size() == 0) {
            severityInfoArray = new SeverityInfo[]{};
        } else {
            severityInfoArray = new SeverityInfo[this.configurations.size()];
            Iterator iterator = this.configurations.keySet().iterator();
            Iterator iterator2 = this.configurations.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                severityInfoArray[n++] = new SeverityInfo((Short)iterator2.next(), (String)iterator.next());
            }
        }
        return severityInfoArray;
    }

    synchronized void removeSeverityConfiguration(String[] stringArray) throws RemoveSeverityConfiguration {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.pKeys.containsKey(stringArray[i])) {
                this.deleteDBEntry((Integer)this.pKeys.get(stringArray[i]));
                this.pKeys.remove(stringArray[i]);
                this.configurations.remove(stringArray[i]);
                continue;
            }
            this.configurations.remove(stringArray[i]);
        }
    }

    private SeverityConfiguration() {
        this.restoreFromDB();
    }

    private void createDBEntry(String string) throws SetSeverity {
        try {
            Control control = SeverityConfiguration.createTransaction();
            DbStringWrapper dbStringWrapper = new DbStringWrapper(TABLE_NAME);
            dbStringWrapper.connectToDatabase();
            dbStringWrapper.createRow(control.getCoordinator().getTransactionID(), ++this.nextKey, string);
            control.getTerminator().commit();
            dbStringWrapper.disconnectFromDatabase();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"transaction rolledback (create)", (Throwable)transactionRolledBackException);
            throw new SetSeverity(transactionRolledBackException.toString());
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"transaction inactive (create)", (Throwable)inactiveTransactionException);
            throw new SetSeverity(inactiveTransactionException.toString());
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError(this.getClass(), (String)"db failure (create)", (Throwable)dbAccessException);
            throw new SetSeverity(dbAccessException.toString());
        }
    }

    private void updateDBEntry(String string, int n) throws SetSeverity {
        try {
            Control control = SeverityConfiguration.createTransaction();
            DbStringWrapper dbStringWrapper = new DbStringWrapper(TABLE_NAME);
            dbStringWrapper.connectToDatabase();
            dbStringWrapper.updateRow(control.getCoordinator().getTransactionID(), n, string);
            control.getTerminator().commit();
            dbStringWrapper.disconnectFromDatabase();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"transaction rolledback (update)", (Throwable)transactionRolledBackException);
            throw new SetSeverity(transactionRolledBackException.toString());
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"transaction inactive (update)", (Throwable)inactiveTransactionException);
            throw new SetSeverity(inactiveTransactionException.toString());
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError(this.getClass(), (String)"db failure (update)", (Throwable)dbAccessException);
            throw new SetSeverity(dbAccessException.toString());
        }
    }

    private void deleteDBEntry(int n) throws RemoveSeverityConfiguration {
        try {
            Control control = SeverityConfiguration.createTransaction();
            DbStringWrapper dbStringWrapper = new DbStringWrapper(TABLE_NAME);
            dbStringWrapper.connectToDatabase();
            dbStringWrapper.deleteRow(control.getCoordinator().getTransactionID(), n);
            control.getTerminator().commit();
            dbStringWrapper.disconnectFromDatabase();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"transaction failure (delete)", (Throwable)transactionRolledBackException);
            throw new RemoveSeverityConfiguration(transactionRolledBackException.toString());
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"transaction inactive (delete)", (Throwable)inactiveTransactionException);
            throw new RemoveSeverityConfiguration(inactiveTransactionException.toString());
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError(this.getClass(), (String)"db failure (delete)", (Throwable)dbAccessException);
            throw new RemoveSeverityConfiguration(dbAccessException.toString());
        }
    }

    private void restoreFromDB() {
        try {
            DbStringWrapper dbStringWrapper = new DbStringWrapper(TABLE_NAME);
            dbStringWrapper.connectToDatabase();
            int[] nArray = dbStringWrapper.retrieveAllPrimaryKeys();
            for (int i = 0; i < nArray.length; ++i) {
                String string = dbStringWrapper.retrieveRow(nArray[i]);
                try {
                    this.configurations.put(string.substring(1), Short.valueOf(string.substring(0, 1)));
                    this.pKeys.put(string.substring(1), new Integer(nArray[i]));
                }
                catch (NumberFormatException numberFormatException) {
                    MessageLog.traceError(this.getClass(), (String)("db entry (" + nArray[i] + ") is corrupt"), (Throwable)numberFormatException);
                }
                if (this.nextKey >= nArray[i]) continue;
                this.nextKey = nArray[i];
            }
            dbStringWrapper.disconnectFromDatabase();
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError(this.getClass(), (String)"error when restoring db table", (Throwable)dbAccessException);
        }
    }

    private static Control createTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        return TransactionServiceImpl.instance().getTransactionFactory().create(600);
    }
}

