/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class StringAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 201212237626519827L;
    private String myValue;
    private transient String myBackup;

    public StringAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = "";
    }

    public StringAttribute(String string, boolean bl, String string2) {
        super(string, bl);
        this.myValue = this.removeSpecialChar(string2);
    }

    public StringAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        this.myValue = string2.substring(2);
    }

    public synchronized String getValue(Coordinator coordinator) {
        if (coordinator == null && this.myBackup != null) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(String string) {
        Assert.cppAssert((Object)string);
        this.myValue = this.removeSpecialChar(string);
    }

    synchronized void rollback() {
        this.myValue = this.myBackup == null ? "" : this.myBackup;
    }

    synchronized void commit() {
        this.myBackup = null;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
    }

    Object getValueAsObject(Coordinator coordinator) {
        return this.getValue(coordinator);
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return this.myBackup;
    }

    boolean isModified() {
        if (this.myBackup != null) {
            return !this.myValue.equals(this.myBackup);
        }
        return false;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        String string = "";
        string = this.getNotificationType() != 0 ? "T" : "F";
        return "^s" + string + this.myValue;
    }

    private String removeSpecialChar(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf("\u00a4") != -1) {
            string = this.removeChar(string, "\u00a4");
        }
        if (string.indexOf("|") != -1) {
            string = this.removeChar(string, "|");
        }
        if (string.indexOf("^") != -1) {
            string = this.removeChar(string, "^");
        }
        if (string.indexOf("'") != -1) {
            string = this.removeChar(string, "'");
        }
        return string;
    }

    private String removeChar(String string, String string2) {
        String string3 = string;
        int n = string.indexOf(string2);
        while (n != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(string2);
        }
        MessageLog.info(this.getClass(), (String)("Removed illegal character " + string2 + " from string '" + string3));
        return string;
    }
}

