/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.notification;

import CelloNotificationIRPExtension.AttachPushExt;
import CelloNotificationIRPExtension.ChangeSubscriptionFilterExt;
import CelloNotificationIRPExtension.FilterHolder;
import CelloNotificationIRPExtension.GetSubscriptionStatusExt;
import CelloNotificationIRPExtension.NotificationIRPExtensionOperations;
import CelloNotificationIRPExtension.NotificationIRPExtensionPOATie;
import CelloNotificationIRPExtension.SpecificProblemMOPair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullSupplierHolder;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPushSupplierHolder;
import org.omg.CosNotifyComm.SequencePushConsumer;
import org.omg.CosNotifyComm.SequencePushConsumerHelper;
import org.threegppsa5.NotificationIRPConstDefs.EventTypesSetHolder;
import org.threegppsa5.NotificationIRPConstDefs.ExtendedEventTypesSetHolder;
import org.threegppsa5.NotificationIRPConstDefs.SubscriptionState;
import org.threegppsa5.NotificationIRPConstDefs.SubscriptionStateHolder;
import org.threegppsa5.NotificationIRPSystem.AlreadySubscribed;
import org.threegppsa5.NotificationIRPSystem.AtLeastOneNotificationCategoryNotSupported;
import org.threegppsa5.NotificationIRPSystem.Attach;
import org.threegppsa5.NotificationIRPSystem.ChangeSubscriptionFilter;
import org.threegppsa5.NotificationIRPSystem.DetachException;
import org.threegppsa5.NotificationIRPSystem.GetNotificationCategories;
import org.threegppsa5.NotificationIRPSystem.GetSubscriptionIds;
import org.threegppsa5.NotificationIRPSystem.GetSubscriptionStatus;
import org.threegppsa5.NotificationIRPSystem.InvalidParameter;
import org.threegppsa5.NotificationIRPSystem.OperationNotSupported;
import org.threegppsa5.NotificationIRPSystem.ParameterNotSupported;
import se.ericsson.cello.notification.Filter;
import se.ericsson.cello.notification.NotificationCommunicator;
import se.ericsson.cello.notification.SubscriptionList;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;

public final class NotificationIRPImpl
implements NotificationIRPExtensionOperations {
    private static NotificationIRPImpl theOneAndOnly = new NotificationIRPImpl();
    private SubscriptionList mySubscriptions = new SubscriptionList();
    private Vector myConsumers = new Vector();
    private String subscriptionFile;
    private String ALARMSUBSCR_DAT_FILE_OLDPATH = "/c/logs/obj_logs/";
    private String ALARMSUBSCR_DAT_FILE_NEWPATH = "/c/configuration/";
    private String ALARMSUBSCR_DAT_FILE = "alarmsubscr.dat";
    private String TEMP_FILE = "/host/tmp";
    private static final String IRP_NAME_AND_VERSION = "NOTIFICATION_IRP_VERSION_1_1";
    private static int notificationId = 0;
    private static long lastUsedSubscriptionId = 0L;

    public static NotificationIRPImpl instance() {
        return theOneAndOnly;
    }

    public static void init() throws UserException, SystemException {
        NotificationIRPImpl notificationIRPImpl = NotificationIRPImpl.instance();
        NotificationIRPExtensionPOATie notificationIRPExtensionPOATie = new NotificationIRPExtensionPOATie(notificationIRPImpl);
        notificationIRPImpl.restoreSubscriptions();
        CelloOrb.instance().connect(IRP_NAME_AND_VERSION, notificationIRPExtensionPOATie);
        NameComponent nameComponent = new NameComponent(IRP_NAME_AND_VERSION, "");
        NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
        CelloOrb.instance().rebind(nameComponentArray, CelloOrb.instance().servant_to_reference(notificationIRPExtensionPOATie));
    }

    public String attach_push_ext(Object object, int n, String[] stringArray, CelloNotificationIRPExtension.Filter filter) throws AttachPushExt, InvalidParameter, AlreadySubscribed, AtLeastOneNotificationCategoryNotSupported {
        Filter filter2 = null;
        try {
            filter2 = new Filter(filter);
        }
        catch (Filter.EmptyFilterException emptyFilterException) {
        }
        catch (Filter.FilterSeverityException filterSeverityException) {
            throw new InvalidParameter(filterSeverityException.toString());
        }
        catch (Filter.FilterSizeException filterSizeException) {
            throw new InvalidParameter(filterSizeException.toString());
        }
        try {
            return this.attach(object, n, stringArray, filter2);
        }
        catch (Attach attach) {
            throw new AttachPushExt(attach.toString());
        }
    }

    public String attach_push(Object object, int n, String[] stringArray, String string) throws Attach, ParameterNotSupported, InvalidParameter, AlreadySubscribed, AtLeastOneNotificationCategoryNotSupported {
        if (string != null && string.length() != 0) {
            throw new ParameterNotSupported("Filter not supported!");
        }
        return this.attach(object, n, stringArray, null);
    }

    public String attach_push_b(Object object, int n, String[] stringArray, String string, SequenceProxyPushSupplierHolder sequenceProxyPushSupplierHolder) throws Attach, OperationNotSupported, ParameterNotSupported, InvalidParameter, AlreadySubscribed, AtLeastOneNotificationCategoryNotSupported {
        throw new OperationNotSupported("Not implemented");
    }

    public String attach_pull(Object object, int n, String[] stringArray, String string, SequenceProxyPullSupplierHolder sequenceProxyPullSupplierHolder) throws Attach, OperationNotSupported, ParameterNotSupported, InvalidParameter, AlreadySubscribed, AtLeastOneNotificationCategoryNotSupported {
        throw new OperationNotSupported("Not implemented");
    }

    public synchronized void detach(Object object, String string) throws DetachException, InvalidParameter {
        try {
            long l = 0L;
            if (object == null || !object._is_a("IDL:omg.org/CosNotifyComm/SequencePushConsumer:1.0")) {
                throw new InvalidParameter("Invalid callback reference specified!");
            }
            if (string != null && string.length() > 0) {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidParameter("Bad format on subscriptionId");
                }
            }
            this.mySubscriptions.removeSubscription(SequencePushConsumerHelper.narrow(object), l);
            while (this.myConsumers.removeElement(new PersistentSubscription(CelloOrb.instance().object_to_string(object), l, 0, null))) {
            }
            this.storeConsumers();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"detach: ", (Throwable)runtimeException);
            throw new DetachException(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"detach: ", (Throwable)error);
            throw new DetachException(error.toString());
        }
    }

    public String[] get_notification_IRP_version() {
        return new String[]{"1n1", "1nx1"};
    }

    public synchronized String[] get_subscription_status_ext(String string, FilterHolder filterHolder, SubscriptionStateHolder subscriptionStateHolder, IntHolder intHolder) throws GetSubscriptionStatusExt, InvalidParameter {
        try {
            long l;
            subscriptionStateHolder.value = SubscriptionState.DontKnow;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidParameter("Bad format on subscriptionId");
            }
            if (this.mySubscriptions.isSubscriptionRegistered(l)) {
                intHolder.value = this.mySubscriptions.getTimetick(l);
                this.mySubscriptions.getNotCom(l).restartTimer();
                Filter filter = this.mySubscriptions.getFilter(l);
                if (filter == null) {
                    short s = 0;
                    filterHolder.value = new CelloNotificationIRPExtension.Filter(s, new String[0], new SpecificProblemMOPair[0]);
                } else {
                    filterHolder.value = new CelloNotificationIRPExtension.Filter(filter.getSeverity(), filter.getSpecficProblem(), filter.getSpecificProblemMOPair());
                }
                String[] stringArray = new String[]{"1f1"};
                return stringArray;
            }
            throw new InvalidParameter("Subscription doesn't exist");
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_subscription_status: ", (Throwable)runtimeException);
            throw new GetSubscriptionStatusExt(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_subscription_status: ", (Throwable)error);
            throw new GetSubscriptionStatusExt(error.toString());
        }
    }

    public synchronized String[] get_subscription_status(String string, StringHolder stringHolder, SubscriptionStateHolder subscriptionStateHolder, IntHolder intHolder) throws GetSubscriptionStatus, OperationNotSupported, InvalidParameter {
        try {
            long l;
            stringHolder.value = "";
            subscriptionStateHolder.value = SubscriptionState.DontKnow;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidParameter("Bad format on subscriptionId");
            }
            if (this.mySubscriptions.isSubscriptionRegistered(l)) {
                intHolder.value = this.mySubscriptions.getTimetick(l);
                this.mySubscriptions.getNotCom(l).restartTimer();
                String[] stringArray = new String[]{"1f1"};
                return stringArray;
            }
            throw new InvalidParameter("Subscription doesn't exist");
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_subscription_status: ", (Throwable)runtimeException);
            throw new GetSubscriptionStatus(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_subscription_status: ", (Throwable)error);
            throw new GetSubscriptionStatus(error.toString());
        }
    }

    public String[] get_subscription_ids(Object object) throws GetSubscriptionIds, OperationNotSupported, InvalidParameter {
        throw new OperationNotSupported("Not implemented");
    }

    public synchronized void change_subscription_filter_ext(String string, CelloNotificationIRPExtension.Filter filter) throws ChangeSubscriptionFilterExt, InvalidParameter {
        try {
            Filter filter2;
            long l = 0L;
            if (string != null && string.length() > 0) {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidParameter("Bad format on subscriptionId");
                }
            } else {
                throw new InvalidParameter("No value set for subscriptionId");
            }
            try {
                filter2 = new Filter(filter);
            }
            catch (Filter.EmptyFilterException emptyFilterException) {
                throw new InvalidParameter(emptyFilterException.toString());
            }
            catch (Filter.FilterSeverityException filterSeverityException) {
                throw new InvalidParameter(filterSeverityException.toString());
            }
            catch (Filter.FilterSizeException filterSizeException) {
                throw new InvalidParameter(filterSizeException.toString());
            }
            if (this.mySubscriptions.updateSubscription(l, filter2)) {
                Enumeration enumeration = ((Vector)this.myConsumers.clone()).elements();
                while (enumeration.hasMoreElements()) {
                    PersistentSubscription persistentSubscription = (PersistentSubscription)enumeration.nextElement();
                    if (persistentSubscription.getSubId() != l) continue;
                    persistentSubscription.setFilter(filter2);
                    break;
                }
            } else {
                throw new InvalidParameter("Specified subscription does not exist");
            }
            this.storeConsumers();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"change_subscription_filter_ext: ", (Throwable)runtimeException);
            throw new ChangeSubscriptionFilterExt(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"change_subscription_filter_ext: ", (Throwable)error);
            throw new ChangeSubscriptionFilterExt(error.toString());
        }
    }

    public void change_subscription_filter(String string, String string2) throws ChangeSubscriptionFilter, OperationNotSupported, InvalidParameter {
        throw new OperationNotSupported("Not implemented");
    }

    public String[] get_notification_categories(EventTypesSetHolder eventTypesSetHolder, ExtendedEventTypesSetHolder extendedEventTypesSetHolder) throws GetNotificationCategories, OperationNotSupported {
        throw new OperationNotSupported("Not implemented");
    }

    public synchronized void enqueue(StructuredEvent structuredEvent) {
        Enumeration enumeration = this.mySubscriptions.getAllNotCom();
        while (enumeration.hasMoreElements()) {
            ((NotificationCommunicator)enumeration.nextElement()).enqueue(structuredEvent);
        }
    }

    public synchronized void enqueue(StructuredEvent structuredEvent, short s, String string, String string2) {
        Enumeration enumeration = this.mySubscriptions.getAllNotCom(s, string, string2);
        while (enumeration.hasMoreElements()) {
            ((NotificationCommunicator)enumeration.nextElement()).enqueue(structuredEvent);
        }
    }

    public synchronized int getNotificationId() {
        return ++notificationId;
    }

    public boolean isSubscriptionRegistered(long l) {
        return this.mySubscriptions.isSubscriptionRegistered(l);
    }

    public Filter getFilter(long l) {
        return this.mySubscriptions.getFilter(l);
    }

    private String attach(Object object, int n, String[] stringArray, Filter filter) throws Attach, InvalidParameter, AlreadySubscribed, AtLeastOneNotificationCategoryNotSupported {
        try {
            if (object == null || !object._is_a("IDL:omg.org/CosNotifyComm/SequencePushConsumer:1.0")) {
                throw new InvalidParameter("Invalid callback reference!");
            }
            if (n <= 0) {
                n = 0;
            } else if (n >= 1 && n <= 15) {
                n = 15;
            }
            if (stringArray == null) {
                throw new InvalidParameter("Category parameter can't be null!");
            }
            if (stringArray.length != 1 || !stringArray[0].equals("1f1")) {
                throw new AtLeastOneNotificationCategoryNotSupported();
            }
            if (this.mySubscriptions.isSubscriptionRegistered(SequencePushConsumerHelper.narrow(object))) {
                throw new AlreadySubscribed();
            }
            return this.addSubscription(SequencePushConsumerHelper.narrow(object), n, filter);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"attach_push: ", (Throwable)runtimeException);
            throw new Attach(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"attach_push: ", (Throwable)error);
            throw new Attach(error.toString());
        }
    }

    private synchronized String addSubscription(SequencePushConsumer sequencePushConsumer, int n, Filter filter) throws Attach {
        long l = ++lastUsedSubscriptionId;
        NotificationCommunicator notificationCommunicator = new NotificationCommunicator(sequencePushConsumer, l, n);
        this.mySubscriptions.addSubscription(notificationCommunicator, sequencePushConsumer, l, n, filter);
        notificationCommunicator.start();
        PersistentSubscription persistentSubscription = new PersistentSubscription(CelloOrb.instance().object_to_string(sequencePushConsumer), l, n, filter);
        this.myConsumers.addElement(persistentSubscription);
        this.storeConsumers();
        return new Long(l).toString();
    }

    public void removeAllStoredSubscriptions() {
        this.myConsumers.removeAllElements();
        this.storeConsumers();
    }

    private synchronized void storeConsumers() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.subscriptionFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.myConsumers);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageLog.info(this.getClass(), (String)"A subscription is not stored since the file system is temporarily unavailable");
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"File system error.", (Throwable)exception);
        }
    }

    private synchronized void restoreConsumers() throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException {
        this.myConsumers.removeAllElements();
        if (new File(this.subscriptionFile).exists()) {
            FileInputStream fileInputStream = new FileInputStream(this.subscriptionFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.myConsumers = (Vector)objectInputStream.readObject();
            fileInputStream.close();
        }
    }

    void restoreSubscriptions() {
        Serializable serializable;
        java.lang.Object object;
        boolean bl = false;
        this.myConsumers = null;
        this.mySubscriptions = new SubscriptionList();
        this.myConsumers = new Vector();
        try {
            object = null;
            if (System.getProperty("SIM") == null) {
                this.checkOldFileLocation();
                object = "/c/configuration/";
            } else {
                object = System.getProperty("SIM") != null ? (new File(this.TEMP_FILE).isDirectory() ? "/host/tmp" : System.getProperty("user.dir")) : (new File("/tmp").isDirectory() ? "/tmp" : System.getProperty("user.dir"));
                if (!((String)object).endsWith(System.getProperty("file.separator"))) {
                    object = (String)object + System.getProperty("file.separator");
                }
            }
            serializable = new File((String)object);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            this.subscriptionFile = (String)object + "alarmsubscr.dat";
            this.restoreConsumers();
        }
        catch (Throwable throwable) {
            this.myConsumers = new Vector();
            MessageLog.traceError(this.getClass(), (String)"Failure in restoreSubscriptions() when trying to read file alarmsubscr.dat.", (Throwable)throwable);
        }
        if (this.myConsumers.size() >= SubscriptionList.MAX_NO_OF_SUBSCRIPTIONS) {
            this.removeAllStoredSubscriptions();
            MessageLog.info((Class)NotificationIRPImpl.class, (String)"File alarmsubscr.dat contains too many subscriptions, removing all");
        } else {
            object = this.myConsumers.elements();
            serializable = new Vector();
            while (object.hasMoreElements()) {
                try {
                    PersistentSubscription persistentSubscription = (PersistentSubscription)object.nextElement();
                    SequencePushConsumer sequencePushConsumer = SequencePushConsumerHelper.narrow(CelloOrb.instance().string_to_object(persistentSubscription.getIor()));
                    NotificationCommunicator notificationCommunicator = new NotificationCommunicator(sequencePushConsumer, persistentSubscription.getSubId(), persistentSubscription.getTimeTick());
                    notificationCommunicator.start();
                    this.mySubscriptions.addSubscription(notificationCommunicator, sequencePushConsumer, persistentSubscription.getSubId(), persistentSubscription.getTimeTick(), persistentSubscription.getFilter());
                    if (persistentSubscription.getSubId() > lastUsedSubscriptionId) {
                        lastUsedSubscriptionId = persistentSubscription.getSubId();
                    }
                    ((Vector)serializable).add(persistentSubscription);
                }
                catch (SystemException systemException) {
                    bl = true;
                    MessageLog.info(this.getClass(), (String)("Failed to recover alarm subscription due to: " + (java.lang.Object)((java.lang.Object)systemException)));
                }
                catch (Throwable throwable) {
                    bl = true;
                    MessageLog.info(this.getClass(), (String)("Failed to recover alarm subscription due to: " + throwable));
                }
            }
            if (bl) {
                this.myConsumers = serializable;
                this.storeConsumers();
            }
        }
    }

    private void checkOldFileLocation() throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException {
        File file = new File(this.ALARMSUBSCR_DAT_FILE_OLDPATH + this.ALARMSUBSCR_DAT_FILE);
        if (file.exists()) {
            this.subscriptionFile = this.ALARMSUBSCR_DAT_FILE_OLDPATH + this.ALARMSUBSCR_DAT_FILE;
            this.restoreConsumers();
            file.delete();
        }
        if (this.myConsumers.size() > 0) {
            File file2 = new File(this.ALARMSUBSCR_DAT_FILE_NEWPATH);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            this.subscriptionFile = this.ALARMSUBSCR_DAT_FILE_NEWPATH + this.ALARMSUBSCR_DAT_FILE;
            this.storeConsumers();
        }
    }

    private NotificationIRPImpl() {
    }

    private static class PersistentSubscription
    implements Serializable {
        private Filter filter;
        private String ior;
        private long subId;
        private int timetick;
        static final long serialVersionUID = 9154286636307060292L;

        PersistentSubscription(String string, long l, int n, Filter filter) {
            this.ior = string;
            this.subId = l;
            this.timetick = n;
            this.filter = filter;
        }

        public boolean equals(java.lang.Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            if (((PersistentSubscription)object).getSubId() == 0L) {
                return ((PersistentSubscription)object).getIor().equals(this.ior);
            }
            return ((PersistentSubscription)object).getIor().equals(this.ior) && ((PersistentSubscription)object).getSubId() == this.subId;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        void setFilter(Filter filter) {
            this.filter = filter;
        }

        Filter getFilter() {
            return this.filter;
        }

        String getIor() {
            return this.ior;
        }

        long getSubId() {
            return this.subId;
        }

        int getTimeTick() {
            return this.timetick;
        }
    }
}

