/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.MonitoringTask;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.ObjectRepository;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.pms.generic.SystemSuspendedException;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionRolledBackException;

class MonitoringTaskMgr {
    private static MonitoringTaskMgr theOneAndOnly = new MonitoringTaskMgr();
    private LinkedList tasks = new LinkedList();
    private boolean txRolledBack = false;
    private int retries = 0;
    private static final int MAX_NO_OF_RETRIES = 20;
    private static final int RETRY_INTERVAL = 2000;
    private PmsContext pmsContext;
    private static final int TRACE_GROUP = 8;

    static MonitoringTaskMgr instance() {
        return theOneAndOnly;
    }

    void setPmsContext(PmsContext pmsContext) {
        this.pmsContext = pmsContext;
    }

    MonitoringTask createMonitoringTask(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, int n, int n2, String string, PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws InvalidGranularityPeriodException, OverloadException, GranularityPeriodNotSupportedException, GranularityAndAttributeActivationException, NumberOfCountersExceededException, NumberOfMonitorsExceededException, ParameterNotAcceptedException, InactiveTransactionException, SystemSuspendedException {
        if (this.pmsContext.isSystemSuspended()) {
            throw new SystemSuspendedException();
        }
        if (performanceMonitoringState.value() == 0) {
            if (this.getActiveMonitorings().size() >= this.pmsContext.getMaxNoOfMonitors()) {
                throw new NumberOfMonitorsExceededException();
            }
            if (!this.pmsContext.acceptCounterActivation(observationClassArray, observationObjectArray)) {
                throw new NumberOfCountersExceededException();
            }
        }
        MonitoringTask monitoringTask = new MonitoringTask(observationClassArray, observationObjectArray, n, n2, string, performanceMonitoringState, coordinator, this.pmsContext);
        coordinator.registerResource((Resource)new CreateTx(monitoringTask));
        return monitoringTask;
    }

    MonitoringTask recoverMonitoringTask(MonitoringTaskInfo monitoringTaskInfo) throws RecoveryException {
        int n;
        Object[] objectArray;
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        MonitoringTask monitoringTask = null;
        Control control = null;
        boolean bl = false;
        if (!this.observationClassExists(monitoringTaskInfo.getObservationClassList(), linkedList)) {
            objectArray = new ObservationClass[linkedList.size()];
            for (n = 0; n < linkedList.size(); ++n) {
                objectArray[n] = (ObservationClass)linkedList.get(n);
            }
            monitoringTaskInfo = new MonitoringTaskInfo(monitoringTaskInfo.getId(), monitoringTaskInfo.getName(), monitoringTaskInfo.getState(), (ObservationClass[])objectArray, monitoringTaskInfo.getObservationObjectList(), monitoringTaskInfo.getGranularityPeriod(), monitoringTaskInfo.getReportingPeriod());
            linkedList = null;
            bl = true;
        }
        if (!this.observationObjectExists(monitoringTaskInfo.getObservationObjectList(), linkedList2)) {
            objectArray = new ObservationObject[linkedList2.size()];
            for (n = 0; n < linkedList2.size(); ++n) {
                objectArray[n] = (ObservationObject)linkedList2.get(n);
            }
            monitoringTaskInfo = new MonitoringTaskInfo(monitoringTaskInfo.getId(), monitoringTaskInfo.getName(), monitoringTaskInfo.getState(), monitoringTaskInfo.getObservationClassList(), (ObservationObject[])objectArray, monitoringTaskInfo.getGranularityPeriod(), monitoringTaskInfo.getReportingPeriod());
            linkedList2 = null;
            bl = true;
        }
        if (monitoringTaskInfo.getObservationClassList().length == 0 && monitoringTaskInfo.getObservationObjectList().length == 0) {
            MessageLog.info(this.getClass(), (String)(" No ObservationClass/Observationobject exists in Performance monitoring with ID :" + monitoringTaskInfo.getId()));
            throw new RecoveryException();
        }
        try {
            if (this.attributesRemoved(monitoringTaskInfo.getObservationClassList(), monitoringTaskInfo.getObservationObjectList())) {
                MessageLog.info(this.getClass(), (String)("Performance monitoring " + monitoringTaskInfo.getName() + " contains attributes which are no longer registered. The attributes will be removed from the Performance Monitoring."));
                monitoringTaskInfo = this.getUpdatedTaskInfo(monitoringTaskInfo.getId(), monitoringTaskInfo.getName(), monitoringTaskInfo.getState(), monitoringTaskInfo.getObservationClassList(), monitoringTaskInfo.getObservationObjectList(), monitoringTaskInfo.getGranularityPeriod(), monitoringTaskInfo.getReportingPeriod());
                bl = true;
            }
            control = TransactionHelper.create();
            control.getCoordinator().registerResource((Resource)new RecoveryTx());
            if (monitoringTaskInfo.getState().value() == 0) {
                if (this.getActiveMonitorings().size() >= this.pmsContext.getMaxNoOfMonitors()) {
                    monitoringTaskInfo.setState(PerformanceMonitoringState.SUSPENDED);
                    bl = true;
                    MessageLog.info(this.getClass(), (String)("Performance monitoring " + monitoringTaskInfo.getName() + " could not be loaded active (max number of monitors exceeded)."));
                }
                if (!this.pmsContext.acceptCounterActivation(monitoringTaskInfo.getObservationClassList(), monitoringTaskInfo.getObservationObjectList())) {
                    monitoringTaskInfo.setState(PerformanceMonitoringState.SUSPENDED);
                    bl = true;
                    MessageLog.info(this.getClass(), (String)("Performance monitoring " + monitoringTaskInfo.getName() + " could not be loaded active (max number of counters exceeded."));
                }
            }
            monitoringTask = new MonitoringTask(monitoringTaskInfo, bl, control.getCoordinator(), this.pmsContext);
            control.getCoordinator().registerResource((Resource)new CreateTx(monitoringTask));
            control.getTerminator().commit();
            if (monitoringTaskInfo.isSystemSuspended()) {
                this.pmsContext.setSystemSuspended(true);
            }
            this.retries = 0;
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            if (this.retries <= 20) {
                if (this.retries == 0 || this.retries % 5 == 0) {
                    MessageLog.info(this.getClass(), (String)("Failed to create Performance Monitoring with id " + monitoringTaskInfo.getId() + " during recovery due to inactive transaction, retrying."));
                }
                this.retryRecovery(monitoringTaskInfo);
            }
            MessageLog.info(this.getClass(), (String)"Processing failure due to inactive transaction.");
            throw new RecoveryException();
        }
        catch (GranularityPeriodNotSupportedException granularityPeriodNotSupportedException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)"Granularity period not supported");
            throw new RecoveryException();
        }
        catch (NumberOfCountersExceededException numberOfCountersExceededException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)"No of counters exceeded");
            throw new RecoveryException();
        }
        catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)"Granularity and attribute activation failed");
            throw new RecoveryException();
        }
        catch (OverloadException overloadException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)"Overload");
            throw new RecoveryException();
        }
        catch (ParameterNotAcceptedException parameterNotAcceptedException) {
            TransactionHelper.rollback(control);
            MessageLog.info(this.getClass(), (String)"Parameter not accepted");
            throw new RecoveryException();
        }
        catch (Exception exception) {
            if (!this.txRolledBack) {
                TransactionHelper.rollback(control);
            }
            if (this.retries <= 20) {
                if (this.retries == 0 || this.retries % 5 == 0) {
                    MessageLog.info(this.getClass(), (String)("Failed to create Performance Monitoring with id " + monitoringTaskInfo.getId() + " during recovery due to " + exception + ", retrying."));
                }
                this.retryRecovery(monitoringTaskInfo);
            }
            MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
            throw new RecoveryException();
        }
        return monitoringTask;
    }

    private void retryRecovery(MonitoringTaskInfo monitoringTaskInfo) throws RecoveryException {
        ++this.retries;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.recoverMonitoringTask(monitoringTaskInfo);
    }

    void deleteMonitoringTask(MonitoringTask monitoringTask, Coordinator coordinator) throws InactiveTransactionException {
        coordinator.registerResource((Resource)new DeleteTx(monitoringTask));
        monitoringTask.delete(coordinator);
    }

    void resumeMonitoringTask(MonitoringTask monitoringTask, Coordinator coordinator) throws NumberOfCountersExceededException, NumberOfMonitorsExceededException, OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException, SystemSuspendedException {
        if (this.pmsContext.isSystemSuspended()) {
            throw new SystemSuspendedException();
        }
        if (monitoringTask.getTaskInfo().getState().value() == 1) {
            if (this.getActiveMonitorings().size() >= this.pmsContext.getMaxNoOfMonitors()) {
                throw new NumberOfMonitorsExceededException();
            }
            if (this.pmsContext.acceptCounterActivation(monitoringTask.getTaskInfo().getObservationClassList(), monitoringTask.getTaskInfo().getObservationObjectList())) {
                monitoringTask.setMonitoringState(PerformanceMonitoringState.ACTIVE, coordinator);
            } else {
                throw new NumberOfCountersExceededException();
            }
        }
    }

    void setSystemSuspended(boolean bl) throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException, TransactionRolledBackException {
        if (bl == this.pmsContext.isSystemSuspended()) {
            MessageLog.info(this.getClass(), (String)("systemSuspended already in state " + this.pmsContext.isSystemSuspended()));
        } else {
            Control control = TransactionHelper.create();
            Coordinator coordinator = control.getCoordinator();
            if (bl) {
                this.systemSuspendMonitorings(coordinator);
            } else {
                this.resumeSystemSuspendedMonitorings(coordinator);
            }
            control.getTerminator().commit();
            this.pmsContext.setSystemSuspended(bl);
            MessageLog.info(this.getClass(), (String)("Changed systemSuspended to " + bl));
        }
    }

    private void systemSuspendMonitorings(Coordinator coordinator) throws InactiveTransactionException, OverloadException, GranularityAndAttributeActivationException {
        MonitoringTask monitoringTask = null;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            monitoringTask = (MonitoringTask)iterator.next();
            monitoringTask.systemSuspend(coordinator);
        }
    }

    private void resumeSystemSuspendedMonitorings(Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException, InactiveTransactionException {
        MonitoringTask monitoringTask = null;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            monitoringTask = (MonitoringTask)iterator.next();
            monitoringTask.systemResume(coordinator);
        }
    }

    boolean isSystemSuspended() {
        return this.pmsContext.isSystemSuspended();
    }

    void reloadTasks(String string) {
        Control control = null;
        MonitoringTask monitoringTask = null;
        for (int i = this.tasks.size() - 1; i >= 0; --i) {
            try {
                monitoringTask = (MonitoringTask)this.tasks.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            if (monitoringTask.getTaskInfo().getState().value() != 0) continue;
            if (this.pmsContext.isMaxNoOfCountersExceeded() || this.pmsContext.getMaxNoOfMonitors() < this.getActiveMonitorings().size()) {
                control = TransactionHelper.create();
                try {
                    monitoringTask.setMonitoringState(PerformanceMonitoringState.SUSPENDED, control.getCoordinator());
                    MessageLog.info(this.getClass(), (String)("Performance monitoring " + monitoringTask.getTaskInfo().getName() + string));
                }
                catch (OverloadException overloadException) {
                }
                catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    // empty catch block
                }
                TransactionHelper.commit(control);
                continue;
            }
            if (!this.pmsContext.isMaxNoOfCountersChanged() && !this.pmsContext.isAlarmThresholdChanged() && !this.pmsContext.isAlarmCeasingLevelChanged()) break;
            this.pmsContext.checkLoad();
            if (this.pmsContext.isMaxNoOfCountersChanged()) {
                this.pmsContext.setMaxNoOfCountersChanged(false);
            }
            if (this.pmsContext.isAlarmThresholdChanged()) {
                this.pmsContext.setAlarmThresholdChanged(false);
            }
            if (!this.pmsContext.isAlarmCeasingLevelChanged()) continue;
            this.pmsContext.setAlarmCeasingLevelChanged(false);
        }
    }

    private boolean observationClassExists(ObservationClass[] observationClassArray, LinkedList linkedList) {
        boolean bl = true;
        for (int i = 0; i < observationClassArray.length; ++i) {
            String string = observationClassArray[i].object_class_name;
            if (MoFactoryMgr.instance().lookup(string) == null) {
                MessageLog.info(this.getClass(), (String)(" MO Type " + string + " is not registered in the MO factory and will be excluded from the Performance Monitoring."));
                bl = false;
                continue;
            }
            linkedList.add(observationClassArray[i]);
        }
        return bl;
    }

    private boolean observationObjectExists(ObservationObject[] observationObjectArray, LinkedList linkedList) {
        boolean bl = true;
        for (int i = 0; i < observationObjectArray.length; ++i) {
            String[] stringArray = observationObjectArray[i].instance_attribute_list;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < observationObjectArray[i].instance_list.length; ++j) {
                String string = observationObjectArray[i].instance_list[j];
                ManagedObject managedObject = MoRepository.instance().lookup(string);
                if (managedObject == null) {
                    MessageLog.info(this.getClass(), (String)(" Mo instance " + string + " does not exists and will be excluded from the Performance Monitoring"));
                    bl = false;
                    continue;
                }
                arrayList.add(observationObjectArray[i].instance_list[j]);
            }
            if (arrayList.size() > 0) {
                ObservationObject observationObject = new ObservationObject(this.toStringArray(arrayList), stringArray);
                linkedList.add(observationObject);
                continue;
            }
            MessageLog.trace((int)8, this.getClass(), (String)(" No MO instances exist in the Observation object corresponding to index: " + i));
        }
        return bl;
    }

    private String[] toStringArray(ArrayList arrayList) {
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private boolean attributesRemoved(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        Object object;
        String string;
        String[] stringArray;
        int n;
        for (n = 0; n < observationClassArray.length; ++n) {
            stringArray = observationClassArray[n].class_attribute_list;
            string = observationClassArray[n].object_class_name;
            object = ObjectRepository.instance().getRegisteredAttributes(string, stringArray);
            if (stringArray.length == ((String[])object).length) continue;
            return true;
        }
        for (n = 0; n < observationObjectArray.length; ++n) {
            stringArray = observationObjectArray[n].instance_attribute_list;
            string = observationObjectArray[n].instance_list[0];
            object = MoRepository.instance().lookup(string).getType();
            String[] stringArray2 = ObjectRepository.instance().getRegisteredAttributes((String)object, stringArray);
            if (stringArray.length == stringArray2.length) continue;
            return true;
        }
        return false;
    }

    private MonitoringTaskInfo getUpdatedTaskInfo(ScannerId scannerId, String string, PerformanceMonitoringState performanceMonitoringState, ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, GranularityPeriod granularityPeriod2) {
        String[] stringArray;
        String string2;
        String[] stringArray2;
        int n;
        ObservationClass[] observationClassArray2 = new ObservationClass[observationClassArray.length];
        ObservationObject[] observationObjectArray2 = new ObservationObject[observationObjectArray.length];
        for (n = 0; n < observationClassArray.length; ++n) {
            stringArray2 = observationClassArray[n].class_attribute_list;
            string2 = observationClassArray[n].object_class_name;
            stringArray = ObjectRepository.instance().getRegisteredAttributes(string2, stringArray2);
            observationClassArray2[n] = new ObservationClass(observationClassArray[n].object_class_name, stringArray);
        }
        for (n = 0; n < observationObjectArray.length; ++n) {
            stringArray2 = observationObjectArray[n].instance_attribute_list;
            string2 = observationObjectArray[n].instance_list[0];
            stringArray = MoRepository.instance().lookup(string2).getType();
            String[] stringArray3 = ObjectRepository.instance().getRegisteredAttributes((String)stringArray, stringArray2);
            observationObjectArray2[n] = new ObservationObject(observationObjectArray[n].instance_list, stringArray3);
        }
        return new MonitoringTaskInfo(scannerId, string, performanceMonitoringState, observationClassArray2, observationObjectArray2, granularityPeriod, granularityPeriod2);
    }

    private boolean attributesExist(String string, String[] stringArray) {
        return ObjectRepository.instance().checkAttributes(string, stringArray).length == 0;
    }

    private Vector getActiveMonitorings() {
        Vector<MonitoringTask> vector = new Vector<MonitoringTask>();
        MonitoringTask monitoringTask = null;
        for (int i = 0; i < this.tasks.size(); ++i) {
            monitoringTask = (MonitoringTask)this.tasks.get(i);
            if (monitoringTask.getTaskInfo().getState().value() != 0) continue;
            vector.add(monitoringTask);
        }
        return vector;
    }

    private MonitoringTaskMgr() {
    }

    static /* synthetic */ PmsContext access$200(MonitoringTaskMgr monitoringTaskMgr) {
        return monitoringTaskMgr.pmsContext;
    }

    private class RecoveryTx
    implements Resource {
        RecoveryTx() {
        }

        public void commit() {
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            MonitoringTaskMgr.this.txRolledBack = true;
        }
    }

    private class DeleteTx
    implements Resource {
        private MonitoringTask txTask = null;

        DeleteTx(MonitoringTask monitoringTask) {
            this.txTask = monitoringTask;
        }

        public void commit() {
            if (MonitoringTaskMgr.this.tasks.contains(this.txTask)) {
                MonitoringTaskMgr.this.tasks.remove(this.txTask);
                new Thread(this){
                    private final /* synthetic */ DeleteTx this$1;
                    {
                        this.this$1 = deleteTx;
                    }

                    public void run() {
                        try {
                            Thread.sleep(300000L);
                            MonitoringTaskMgr.access$200(DeleteTx.access$100(this.this$1)).checkLoad();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
            this.txTask = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            this.txTask = null;
        }

        static /* synthetic */ MonitoringTaskMgr access$100(DeleteTx deleteTx) {
            return deleteTx.MonitoringTaskMgr.this;
        }
    }

    private class CreateTx
    implements Resource {
        private MonitoringTask txTask = null;

        CreateTx(MonitoringTask monitoringTask) {
            this.txTask = monitoringTask;
        }

        public void commit() {
            if (!MonitoringTaskMgr.this.tasks.contains(this.txTask)) {
                MonitoringTaskMgr.this.tasks.add(this.txTask);
            }
            this.txTask = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            this.txTask = null;
        }
    }

    class RecoveryException
    extends Exception {
        RecoveryException() {
        }
    }
}

