/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import PerformanceIRPSystem._PerformanceIRPOperationsHelper;
import PerformanceIRPSystem._PerformanceIRPOperationsPOATie;
import PmServiceExtended.PerformanceMonitoringExtendedHelper;
import PmServiceExtended.PerformanceMonitoringExtendedPOATie;
import org.omg.CosNaming.NameComponent;
import se.ericsson.cello.pms.generic.BasicPerformanceMonitoringOperationsImpl;
import se.ericsson.cello.pms.generic.DiskCleaner;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.PerformanceDataIRPOperationsImpl;
import se.ericsson.cello.pms.generic.PerformanceMonitoringFactory;
import se.ericsson.cello.pms.generic.PmRecoveryHandler;
import se.ericsson.cello.pms.generic.PmsContext;
import se.ericsson.cello.pms.generic.PmsContextImpl;
import se.ericsson.cello.pms.generic.ScannerPersistence;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;

public class PerformanceMgmntService {
    private static PmsContext pmsContext;
    private static int serviceProviderState;
    private static ServiceProvider serviceProvider;
    public static final long HIGH_CAPACITY_PM_ENABLED_SP_KEY = 65L;
    public static final int HIGH_CAPACITY_PM_ENABLED_FALSE = 0;
    public static final int HIGH_CAPACITY_PM_ENABLED_TRUE = 1;
    private static int highCapacityPMEnabled;

    public static void init() {
        pmsContext = new PmsContextImpl();
        MonitoringTaskMgr.instance().setPmsContext(pmsContext);
        PerformanceMonitoringFactory.instance().setPmsContext(pmsContext);
        new DiskCleaner(pmsContext);
        PerformanceMgmntService.initHighCapacityPMEnabled();
        serviceProvider = new ServiceProviderImpl();
        ServiceStateManager.getInstance().registerService(serviceProvider);
    }

    public static void reinit() {
        PerformanceMgmntService.publish();
    }

    public static void recover() {
        PmRecoveryHandler.instance().callInit();
        MessageLog.info((Class)PerformanceMgmntService.class, (String)"pm recovery initialized");
        PerformanceMgmntService.loadMonitorings();
        MessageLog.info((Class)PerformanceMgmntService.class, (String)"performance monitorings loaded");
        PmRecoveryHandler.instance().callStart();
        MessageLog.info((Class)PerformanceMgmntService.class, (String)"pm recovery finished");
        if (System.getProperty("javasim") == null) {
            DiskCleaner.instance().cleanTemporaryFiles();
        }
    }

    public static void publish() {
        try {
            _PerformanceIRPOperationsPOATie _PerformanceIRPOperationsPOATie2 = new _PerformanceIRPOperationsPOATie(PerformanceDataIRPOperationsImpl.instance());
            PerformanceMonitoringExtendedPOATie performanceMonitoringExtendedPOATie = new PerformanceMonitoringExtendedPOATie(BasicPerformanceMonitoringOperationsImpl.instance());
            CelloOrb.instance().connect("CelloPmNotifications", _PerformanceIRPOperationsPOATie2);
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("CelloPmNotifications", "")};
            CelloOrb.instance().rebind(nameComponentArray, _PerformanceIRPOperationsHelper.narrow(CelloOrb.instance().servant_to_reference(_PerformanceIRPOperationsPOATie2)));
            CelloOrb.instance().connect("CelloPerformanceMonitoring", performanceMonitoringExtendedPOATie);
            NameComponent[] nameComponentArray2 = new NameComponent[]{new NameComponent("CelloPerformanceMonitoring", "")};
            CelloOrb.instance().rebind(nameComponentArray2, PerformanceMonitoringExtendedHelper.narrow(CelloOrb.instance().servant_to_reference(performanceMonitoringExtendedPOATie)));
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)PerformanceMgmntService.class, (String)"Failed to startup the PM service", (Throwable)exception);
        }
    }

    static void loadMonitorings() {
        ScannerPersistence.instance().loadScanners();
        PerformanceMonitoringFactory.instance().ready();
    }

    public static void initHighCapacityPMEnabled() {
        int n = 0;
        try {
            PriJavaProxy priJavaProxy = PriJavaProxyFactory.createPriJavaProxy();
            if (priJavaProxy != null) {
                LongSystemParameter longSystemParameter = priJavaProxy.getLongSystemParameter(65L);
                if (longSystemParameter != null && longSystemParameter.isValid()) {
                    n = (int)longSystemParameter.getValue();
                    MessageLog.info((Class)PerformanceMgmntService.class, (String)("Using system parameter 65, HighCapacityPMEnabled = " + n));
                }
            } else {
                MessageLog.info((Class)PerformanceMgmntService.class, (String)"No PriJavaProxy available. Setting HighCapacityPMEnabled to false");
            }
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            MessageLog.info((Class)PerformanceMgmntService.class, (String)"Parameter 65 has wrong type, using default value");
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            MessageLog.info((Class)PerformanceMgmntService.class, (String)"Parameter 65 not found, using default value");
        }
        catch (PriProcessNotFoundException priProcessNotFoundException) {
            MessageLog.info((Class)PerformanceMgmntService.class, (String)"Parameter 65 not found, using default value");
        }
        highCapacityPMEnabled = n;
    }

    public static int getHighCapacityPMEnabled() {
        return highCapacityPMEnabled;
    }

    static {
        serviceProviderState = 2;
    }

    private static class ServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "CPP.OAM.PERFORMANCEMGMNTSERVICE";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

