/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.cello.pms.generic.MonitoringTaskAccess;
import se.ericsson.cello.pms.generic.ScannerAccess;
import se.ericsson.cello.pms.generic.ScannerId;

public class ScannerRepository {
    private static ScannerRepository uniqueInstance = new ScannerRepository();
    private Hashtable scannerTable = new Hashtable();

    private ScannerRepository() {
    }

    public static ScannerRepository instance() {
        return uniqueInstance;
    }

    public synchronized void register(ScannerId scannerId, ScannerAccess scannerAccess) throws NameAlreadyTakenException {
        if (this.scannerTable.containsKey(scannerId.getKey())) {
            throw new NameAlreadyTakenException("Scanner id " + scannerId + " already exists in the scanner repository.");
        }
        this.scannerTable.put(scannerId.getKey(), scannerAccess);
    }

    public synchronized boolean register(Object object, ScannerId scannerId) {
        if (!(object instanceof MonitoringTaskAccess) && !(object instanceof ScannerAccess)) {
            return false;
        }
        if (this.scannerTable.containsKey(scannerId.getKey())) {
            return false;
        }
        this.scannerTable.put(scannerId.getKey(), object);
        return true;
    }

    public synchronized void deregister(ScannerId scannerId) {
        this.scannerTable.remove(scannerId.getKey());
    }

    synchronized Object lookup(int n) {
        return this.scannerTable.get("" + n);
    }

    synchronized Enumeration lookupAll() {
        return ((Hashtable)this.scannerTable.clone()).elements();
    }

    public class NameAlreadyTakenException
    extends Exception {
        NameAlreadyTakenException(String string) {
            super(string);
        }
    }
}

