/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba.log;

import org.apache.avalon.framework.logger.Logger;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.ExceptionHelper;

public class OrbLogger
implements Logger {
    private static final int OMS_CORBA_TRACE = 2;

    public void debug(String string) {
        this.logToTraceAndError(string);
    }

    public void debug(String string, Throwable throwable) {
        this.logToMessageLog(string, throwable);
    }

    public void error(String string) {
        this.logToTraceAndError(string);
    }

    public void error(String string, Throwable throwable) {
        this.logToMessageLog(string, throwable);
    }

    public void fatalError(String string) {
        this.logToTraceAndError(string);
    }

    public void fatalError(String string, Throwable throwable) {
        this.logToMessageLog(string, throwable);
    }

    public Logger getChildLogger(String string) {
        return this;
    }

    public void info(String string) {
        this.logToTraceAndError(string);
    }

    public void info(String string, Throwable throwable) {
        this.logToMessageLog(string, throwable);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String string) {
        this.logToTraceAndError(string);
    }

    public void warn(String string, Throwable throwable) {
        this.logToMessageLog(string, throwable);
    }

    private void logToTraceAndError(String string) {
        this.logToMessageLog(string, null);
    }

    private void logToMessageLog(String string, Throwable throwable) {
        if (throwable == null) {
            MessageLog.trace((int)2, (Class)OrbLogger.class, (String)string);
        } else {
            MessageLog.trace((int)2, (Class)OrbLogger.class, (String)(string + " " + ExceptionHelper.stackToString(throwable.getStackTrace())));
        }
    }
}

