/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.util.Enumeration;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.Assertions;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.CoreConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.equipment.EquipmentAueConstants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class CreateSlotActiveSwAllocAction
implements MoDataAction,
EquipmentAueConstants {
    public static final String ACTIVE_SW_ALLOCATION = "activeSwAllocation";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        Assertions.assertMoType((MoDataWrapper)moDataWrapper, (String)"Slot");
        MoDataWrapper moDataWrapper2 = this.findMatchingSwAlloc(moDataWrapper, converterContext, coordinator);
        moDataWrapper.registerPersistentAttr((Attribute)new ReferenceAttribute(ACTIVE_SW_ALLOCATION, moDataWrapper2 != null ? moDataWrapper2.getLocalDistinguishedName() : null, true));
    }

    private MoDataWrapper findMatchingSwAlloc(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        SequenceAttribute sequenceAttribute = this.getPairs(converterContext, coordinator);
        String string = null;
        boolean bl = false;
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            StructAttribute structAttribute = (StructAttribute)enumeration.nextElement();
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)structAttribute.getElement("Slot", null);
            if (!moDataWrapper.getLocalDistinguishedName().equals(referenceAttribute.getReferenceAsLDN())) continue;
            ReferenceAttribute referenceAttribute2 = (ReferenceAttribute)structAttribute.getElement("SwAllocation", null);
            string = referenceAttribute2 != null ? referenceAttribute2.getReferenceAsLDN() : null;
            bl = true;
            break;
        }
        if (!bl) {
            throw new AueException("(" + moDataWrapper.getLocalDistinguishedName() + ") was not included in collected data!");
        }
        if (string != null) {
            return converterContext.getMoDataAccessor().findFirst((MoDataFilter)new FindMoDataByLDNFilter(string));
        }
        return null;
    }

    private SequenceAttribute getPairs(ConverterContext converterContext, Coordinator coordinator) throws AueException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)converterContext.getDataReader().getData("activeSwAllocMos", (CoreConverterContext)converterContext, coordinator);
        return sequenceAttribute;
    }
}

