/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopySingleAttrIntoArrayAttrAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CopySingleAttrIntoArrayAttrAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CopySingleAttrIntoArrayAttrAction = CopySingleAttrIntoArrayAttrAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CopySingleAttrIntoArrayAttrAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CopySingleAttrIntoArrayAttrAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CopySingleAttrIntoArrayAttrAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String toFroTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type, copy to, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String fromFroTypeName = this.getAndCheckParamMapString("fromMo", this.paramMap, "The FRO type, to copy from, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String fromAttr = this.getAndCheckParamMapString("fromAttr", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String toAttr = this.getAndCheckParamMapString("toAttr", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData toTableData = tableHandler.getTableData(toFroTypeName);
            TableData fromTableData = tableHandler.getTableData(fromFroTypeName);
            if (fromTableData.isNotEmpty() && toTableData.isNotEmpty()) {
                this.performAttributeCopy(fromAttr, toAttr, fromTableData, toTableData);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = AueUtil.appendReason("Could not copy attribute, " + AueUtil.doubleQuote(fromAttr) + ", in, " + AueUtil.doubleQuote(fromFroTypeName) + ", to, " + AueUtil.doubleQuote(toAttr) + ", in, " + AueUtil.doubleQuote(toFroTypeName), tde);
            logger.traceDebug(THIS_CLASS, errorMsg);
            throw new CrbsAueException(errorMsg, tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    protected void performAttributeCopy(String fromAttributeName, String toAttributeName, TableData fromTableData, TableData toTableData) throws TableDataException, CrbsAueException {
        this.checkNumberOfFromMos(fromTableData, toTableData);
        this.copyAttributeValues(fromAttributeName, toAttributeName, fromTableData, toTableData);
    }

    private void copyAttributeValues(String fromAttributeName, String toAttributeName, TableData fromTableData, TableData toTableData) throws CrbsAueException, TableDataException {
        Object[] fromLdnColumnData = fromTableData.getAttributeValues("ldn");
        Object[] toLdnColumnData = toTableData.getAttributeValues("ldn");
        Object[] fromMoData = fromTableData.getAttributeValues(fromAttributeName);
        for (int fromMoInstanceIndex = 0; fromMoInstanceIndex < fromLdnColumnData.length; ++fromMoInstanceIndex) {
            List toInstancesIndexes = this.getToInstancesIndexes((String)fromLdnColumnData[fromMoInstanceIndex], toLdnColumnData);
            for (int i = 0; i < toInstancesIndexes.size(); ++i) {
                Integer toMoInstanceIndex = (Integer)toInstancesIndexes.get(i);
                Object copiedData = fromMoData[fromMoInstanceIndex];
                String newSequenceData = this.createSequence(toAttributeName, copiedData);
                logger.traceDebug(THIS_CLASS, "copyAttributeValues - newSequenceData: " + AueUtil.doubleQuote(newSequenceData));
                toTableData.setAttributeValue(toMoInstanceIndex, toAttributeName, newSequenceData);
                logger.traceGeneral(THIS_CLASS, "Attribute value, " + AueUtil.doubleQuote(copiedData.toString()) + ", copied from attribute, " + AueUtil.doubleQuote(fromAttributeName) + ", in, " + AueUtil.doubleQuote(fromTableData.getTableName()) + ", to attribute ," + AueUtil.doubleQuote(toAttributeName) + ", in, " + AueUtil.doubleQuote(toTableData.getTableName()));
            }
        }
    }

    private List getToInstancesIndexes(String fromLdn, Object[] toLdnColumnData) throws CrbsAueException {
        ArrayList<Integer> toIndexes = new ArrayList<Integer>();
        if (toLdnColumnData.length > 0 && LdnUtil.getMoType(fromLdn).equals(LdnUtil.getMoType(toLdnColumnData[0].toString()))) {
            for (int toMoInstanceIndex = 0; toMoInstanceIndex < toLdnColumnData.length; ++toMoInstanceIndex) {
                String toLdn = toLdnColumnData[toMoInstanceIndex].toString();
                if (!fromLdn.equals(toLdn)) continue;
                toIndexes.add(new Integer(toMoInstanceIndex));
                break;
            }
        } else {
            String fromParentLdn = this.getParentLdn(fromLdn);
            for (int toMoInstanceIndex = 0; toMoInstanceIndex < toLdnColumnData.length; ++toMoInstanceIndex) {
                String toParentLdn = this.getParentLdn((String)toLdnColumnData[toMoInstanceIndex]);
                if (!fromParentLdn.equals(toParentLdn)) continue;
                toIndexes.add(new Integer(toMoInstanceIndex));
            }
        }
        return toIndexes;
    }

    protected String createSequence(String attr, Object init) {
        Object filteredInit = this.filterInit(init);
        StringBuffer seq = new StringBuffer(70);
        seq.append("<array name=\"");
        seq.append(attr);
        seq.append("\">");
        if (init != null) {
            seq.append(filteredInit);
        }
        seq.append("</array>");
        return seq.toString();
    }

    protected Object filterInit(Object init) {
        String stringInit;
        String STRUCT_WITH_NAME = "<struct name=";
        String STRUCT_NO_NAME = "<struct";
        Object filtered = init;
        if (init instanceof String && (stringInit = (String)init).startsWith("<struct name=")) {
            int gtIndex = stringInit.indexOf(62);
            filtered = "<struct" + stringInit.substring(gtIndex);
        }
        return filtered;
    }

    private void checkNumberOfFromMos(TableData fromTableData, TableData toTableData) throws CrbsAueException, TableDataException {
        if (fromTableData.hashCode() != toTableData.hashCode()) {
            Object[] fromLdnColumnData = fromTableData.getAttributeValues("ldn");
            Object[] toLdnColumnData = toTableData.getAttributeValues("ldn");
            for (int toMoInstanceIndex = 0; toMoInstanceIndex < toLdnColumnData.length; ++toMoInstanceIndex) {
                String toParentLdn = this.getParentLdn((String)toLdnColumnData[toMoInstanceIndex]);
                boolean parentAlreadyFound = false;
                for (int fromMoInstanceIndex = 0; fromMoInstanceIndex < fromLdnColumnData.length; ++fromMoInstanceIndex) {
                    String fromParentLdn = this.getParentLdn((String)fromLdnColumnData[fromMoInstanceIndex]);
                    if (parentAlreadyFound && fromParentLdn.equals(toParentLdn)) {
                        String errorMsg = "Copying from more than one MO, under the same parent, is not allowed! Found in table (from), " + fromTableData.getTableName() + ", and table (to), " + toTableData.getTableName();
                        logger.traceDebug(THIS_CLASS, errorMsg);
                        throw new CrbsAueException(errorMsg);
                    }
                    if (!fromParentLdn.equals(toParentLdn)) continue;
                    parentAlreadyFound = true;
                }
            }
        }
        logger.traceGeneral(THIS_CLASS, "checkNumberOfFromMos(" + fromTableData.getTableName() + ") - is OK");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

