/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;

public class ReParentMoAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$ReParentMoAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$ReParentMoAction = ReParentMoAction.class$("se.ericsson.crbs.omf.aue.step1.actions.ReParentMoAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$ReParentMoAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$ReParentMoAction;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String moToMove = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO name is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String oldParent = this.getAndCheckParamMapString("oldMo", this.paramMap, "The old MO name is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newParent = this.getAndCheckParamMapString("newMo", this.paramMap, "The new MO name is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String rdn = this.getAndCheckParamMapString("rdn", this.paramMap, "The RDN is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        this.checkAndUpdateMo(context, moToMove, oldParent, newParent, rdn);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void checkAndUpdateMo(AueContext context, String moToMove, String oldParent, String newParent, String rdn) throws CrbsAueException {
        boolean tableUpdatedFromStart = false;
        String newParentLdn = "";
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData moTableData = tableHandler.getTableData(moToMove);
            tableUpdatedFromStart = moTableData.isTableDataUpdated();
            TableData newParentTableData = tableHandler.getTableData(newParent);
            if (newParentTableData.isNotEmpty()) {
                newParentLdn = this.findNewParentLdn(newParent, newParentTableData, rdn);
                if (newParentLdn == null || "".equalsIgnoreCase(newParentLdn)) {
                    throw new CrbsAueException("Could not find new parent, with type " + AueUtil.doubleQuote(newParent) + ", for " + AueUtil.doubleQuote(moToMove));
                }
                this.updateLdnsAndParentRef(tableHandler, moToMove, oldParent, newParentLdn, moTableData);
                if (!newParentTableData.isTableDataUpdated()) {
                    logger.traceGeneral(THIS_CLASS, "No LDN contained, " + AueUtil.doubleQuote(oldParent) + ", in " + AueUtil.doubleQuote(moToMove));
                }
                tableHandler.checkAndDropIfNotUpdated(tableUpdatedFromStart, moTableData);
            }
        }
        catch (Exception e) {
            String errorMsg = "Could not replace ," + AueUtil.doubleQuote(oldParent) + ", in all LDNs with, " + AueUtil.doubleQuote(newParentLdn) + ", in, " + AueUtil.doubleQuote(moToMove);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new CrbsAueException(errorMsg, e);
        }
    }

    private String findNewParentLdn(String newParentType, TableData newParentTableData, String rdn) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "findNewParentLdn()");
        String newParentLdn = "";
        Object[] ldnColumnDatas = newParentTableData.getAttributeValues("ldn");
        for (int i = 0; i < ldnColumnDatas.length; ++i) {
            String ldn = ldnColumnDatas[i].toString();
            logger.info(THIS_CLASS, "Possible parent [" + rdn + "]: " + ldn);
            String last = AueUtil.getLastLdnElement(ldn);
            logger.info(THIS_CLASS, "Last Element :" + last);
            logger.info(THIS_CLASS, "Type check " + newParentType + " == " + last + " => " + (newParentType.equalsIgnoreCase(AueUtil.getLastLdnElement(ldn)) && ldn.endsWith(rdn)));
            if (!newParentType.equalsIgnoreCase(AueUtil.getLastLdnElement(ldn)) || !ldn.endsWith(rdn)) continue;
            newParentLdn = ldn;
            break;
        }
        logger.info(THIS_CLASS, "The new parent : " + newParentLdn);
        logger.traceReturn(THIS_CLASS, "findNewParentLdn()");
        return newParentLdn;
    }

    private void updateLdnsAndParentRef(TableHandler tableHandler, String moToMove, String oldParent, String newParentLdn, TableData tableData) throws TableDataException, ParseException, CrbsAueException {
        String newLdn = "";
        Object[] ldnColumnDatas = tableData.getAttributeValues("ldn");
        for (int row = 0; row < ldnColumnDatas.length; ++row) {
            int childIndex;
            String oldLdn = ldnColumnDatas[row].toString();
            int oldIndex = oldLdn.indexOf(oldParent);
            if (oldIndex <= -1 || (childIndex = oldLdn.substring(oldIndex).indexOf(",")) <= -1) continue;
            String child = oldLdn.substring(oldIndex + childIndex + 1);
            String froTypeName = AueUtil.getLastLdnElement(oldLdn);
            if (!child.startsWith(moToMove)) continue;
            newLdn = newParentLdn + "," + child;
            tableData.setAttributeValue(row, "ldn", newLdn);
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(oldLdn) + ", replaced with, " + AueUtil.doubleQuote(newLdn) + ", in " + AueUtil.doubleQuote(froTypeName));
            this.updateParentRef(tableHandler, oldParent, newParentLdn, tableData);
        }
    }

    private void updateParentRef(TableHandler tableHandler, String oldParent, String newParentLdn, TableData tableData) throws ParseException, TableDataException {
        logger.traceEnter(THIS_CLASS, "updateParentRef()");
        boolean updated = false;
        Object[][] attributeValues = tableData.getAttributeValues();
        String[] attributeNames = tableData.getAttributeNames();
        for (int column = 0; column < attributeValues.length; ++column) {
            String attributeName = attributeNames[column];
            String momType = tableData.getMomType(attributeName);
            logger.traceGeneral(THIS_CLASS, "\nHEAD: " + attributeName);
            if (!attributeName.equalsIgnoreCase("parentRef") || !momType.equalsIgnoreCase("moref")) continue;
            logger.traceGeneral(THIS_CLASS, "\nWe have a MO ref. Check it for existence of the old MO.");
            updated = this.updateParentMoRef(tableHandler, attributeName, oldParent, newParentLdn, tableData);
        }
        if (!updated) {
            logger.traceGeneral(THIS_CLASS, "No referencing attributes (MORef, struct or array) contained the MO, " + AueUtil.doubleQuote(oldParent));
        }
    }

    private boolean updateParentMoRef(TableHandler tableHandler, String attributeName, String oldMoName, String newMoName, TableData tableData) throws ParseException, TableDataException {
        boolean updated = false;
        Object[] moRefColumnDatas = tableData.getAttributeValues(attributeName);
        for (int i = 0; i < moRefColumnDatas.length; ++i) {
            String moRefXmlString = (String)moRefColumnDatas[i];
            FroMoRef froMoRef = new FroMoRef(tableHandler);
            froMoRef.parse(moRefXmlString);
            boolean thisIsUpdated = this.updateXmlTags(froMoRef.getXmlTags(), attributeName, oldMoName, newMoName);
            if (!thisIsUpdated) continue;
            updated = true;
            tableData.setAttributeValue(i, attributeName, froMoRef.toXmlString());
        }
        return updated;
    }

    private boolean updateXmlTags(XmlTag[] xmlTags, String attributeName, String oldMoName, String newMoName) {
        boolean updated = false;
        block5: for (int i = 0; i < xmlTags.length; ++i) {
            int tagType = xmlTags[i].getTagType();
            switch (tagType) {
                case 2: {
                    updated |= this.updateTypeValue(attributeName, oldMoName, newMoName, (TypeValue)xmlTags[i]);
                    continue block5;
                }
                case 1: {
                    updated |= this.updateNameTypeValue(attributeName, newMoName, (NameTypeValue)xmlTags[i]);
                    continue block5;
                }
                case 3: {
                    updated |= this.updateXmlTags(((FroMoRef)xmlTags[i]).getXmlTags(), attributeName, oldMoName, newMoName);
                    continue block5;
                }
            }
        }
        return updated;
    }

    private boolean updateNameTypeValue(String attributeName, String newMoName, NameTypeValue nameTypeValue) {
        String newValue;
        String value;
        boolean updated = false;
        String type = nameTypeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = nameTypeValue.getValue()) && !(newValue = newMoName).equals(value)) {
            nameTypeValue.setValue(newValue);
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(value) + ", replaced with, " + AueUtil.doubleQuote(newValue) + ", for " + AueUtil.doubleQuote(attributeName));
        }
        return updated;
    }

    private boolean updateTypeValue(String attributeName, String oldMoName, String newMoName, TypeValue typeValue) {
        String newValue;
        String value;
        boolean updated = false;
        String type = typeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = typeValue.getValue()) && !(newValue = AueUtil.replaceInLdn(value, oldMoName, newMoName)).equals(value)) {
            typeValue.setValue(newValue);
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(value) + ", replaced with, " + AueUtil.doubleQuote(newValue) + ", for " + AueUtil.doubleQuote(attributeName));
        }
        return updated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

