/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableColumnHeaderData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

class TableColumnData
implements Comparable {
    private static final Class THIS_CLASS = TableColumnData.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final TableColumnHeaderData tableColumnHeaderData;
    private final List columnDataList = new ArrayList();

    protected TableColumnData(TableColumnHeaderData tableColumnHeaderData) {
        this.tableColumnHeaderData = tableColumnHeaderData;
    }

    protected TableColumnHeaderData getTableColumnHeaderData() {
        return this.tableColumnHeaderData;
    }

    protected void addColumnData(Object newColumnData) {
        this.columnDataList.add(newColumnData);
    }

    protected Object[] getColumnData() {
        Object[] dataArray = new Object[this.columnDataList.size()];
        this.columnDataList.toArray(dataArray);
        return dataArray;
    }

    protected int getIndex(Object objectToLookFor) {
        Object[] dataArray = new Object[this.columnDataList.size()];
        this.columnDataList.toArray(dataArray);
        int index = -1;
        for (int i = 0; i < dataArray.length; ++i) {
            if (dataArray[i] instanceof String && objectToLookFor instanceof String) {
                if (!((String)dataArray[i]).equalsIgnoreCase((String)objectToLookFor)) continue;
                index = i;
                break;
            }
            if (!dataArray[i].equals(objectToLookFor)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void clearColumnData() {
        this.columnDataList.clear();
    }

    protected void deleteRow(int rowIndex) {
        this.columnDataList.remove(rowIndex);
        String debugMsg = "Specified row, " + rowIndex + ", is deleted in this column: " + AueUtil.doubleQuote(this.tableColumnHeaderData.getColumnName());
        logger.traceDebug(THIS_CLASS, debugMsg);
    }

    protected int getSize() {
        return this.columnDataList.size();
    }

    protected boolean setRowData(int rowIndex, Object rowValue) throws TableDataException {
        if (rowIndex < 0 || rowIndex >= this.columnDataList.size()) {
            String errorMsg = "Specified row, " + rowIndex + ", is not present in this column: " + AueUtil.doubleQuote(this.tableColumnHeaderData.getColumnName());
            logger.traceError(THIS_CLASS, errorMsg);
            throw new TableDataException(errorMsg);
        }
        Object prevValue = this.columnDataList.get(rowIndex);
        boolean rowValueUpdated = false;
        rowValueUpdated = prevValue == null ? rowValue != null : !prevValue.equals(rowValue);
        this.columnDataList.set(rowIndex, rowValue);
        logger.traceDebug(THIS_CLASS, "setRowData(" + rowIndex + ", " + rowValue + ") = " + rowValueUpdated);
        return rowValueUpdated;
    }

    public boolean equals(Object otherObj) {
        boolean result = false;
        if (otherObj instanceof TableColumnData) {
            TableColumnData otherColumnData = (TableColumnData)otherObj;
            result = this.tableColumnHeaderData.getColumnName().equalsIgnoreCase(otherColumnData.tableColumnHeaderData.getColumnName());
        } else {
            result = super.equals(otherObj);
        }
        return result;
    }

    public int hashCode() {
        return this.tableColumnHeaderData.getColumnName().hashCode();
    }

    public int compareTo(Object otherObj) {
        int result = 0;
        if (otherObj != null && otherObj instanceof TableColumnData) {
            TableColumnData otherColumnData = (TableColumnData)otherObj;
            result = this.tableColumnHeaderData.getColumnName().equalsIgnoreCase(otherColumnData.tableColumnHeaderData.getColumnName()) ? 0 : ("froid".equalsIgnoreCase(this.tableColumnHeaderData.getColumnName()) ? -1 : ("froid".equalsIgnoreCase(otherColumnData.tableColumnHeaderData.getColumnName()) ? 1 : ("ldn".equalsIgnoreCase(this.tableColumnHeaderData.getColumnName()) ? -1 : ("ldn".equalsIgnoreCase(otherColumnData.tableColumnHeaderData.getColumnName()) ? 1 : ("parentRef".equalsIgnoreCase(this.tableColumnHeaderData.getColumnName()) ? -1 : ("parentRef".equalsIgnoreCase(otherColumnData.tableColumnHeaderData.getColumnName()) ? 1 : this.tableColumnHeaderData.getColumnName().toLowerCase(Locale.getDefault()).compareTo(otherColumnData.tableColumnHeaderData.getColumnName().toLowerCase(Locale.getDefault()))))))));
        }
        return result;
    }
}

