/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.AbstractFroXmlHelperImpl;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArrayHelper;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TypeValue;

public class FroArrayHelperImpl
extends AbstractFroXmlHelperImpl
implements FroArrayHelper {
    private FroMoRef subMoRef = FroMoRef.EMPTY;
    private FroStruct subStruct = FroStruct.EMPTY;
    private FroArray subArray = FroArray.EMPTY;
    private boolean initiated = false;
    private final TableHandler tableHandler;

    public FroArrayHelperImpl(TableHandler tableHandler) {
        super(FroArrayHelperImpl.class);
        this.tableHandler = tableHandler;
    }

    public String getXmlTagName() {
        return "array";
    }

    public int getTagType() {
        return 5;
    }

    public String convertObjectArrayToXml(String attributeName, Object[] objectArrayToBeConverted) throws CrbsAueException {
        this.name = attributeName;
        for (int i = 0; i < objectArrayToBeConverted.length; ++i) {
            if (objectArrayToBeConverted[i] instanceof Struct) {
                FroStruct localSubStruct = new FroStruct(this.tableHandler);
                localSubStruct.convertStructToXml("", (Struct)objectArrayToBeConverted[i]);
                this.xmlTagsList.add(localSubStruct);
                continue;
            }
            if (objectArrayToBeConverted[i] instanceof Integer) {
                TypeValue typeValue = new TypeValue("S32", objectArrayToBeConverted[i].toString());
                this.xmlTagsList.add(typeValue);
                continue;
            }
            if (objectArrayToBeConverted[i] instanceof Boolean) {
                boolean isTrue = (Boolean)objectArrayToBeConverted[i];
                TypeValue typeValue = new TypeValue("S32", isTrue ? BOOLEAN_TRUE.toString() : BOOLEAN_FALSE.toString());
                this.xmlTagsList.add(typeValue);
                continue;
            }
            if (objectArrayToBeConverted[i] instanceof String) {
                TypeValue typeValue = new TypeValue("STRING", objectArrayToBeConverted[i].toString());
                this.xmlTagsList.add(typeValue);
                continue;
            }
            if (objectArrayToBeConverted[i] instanceof ManagedObject) {
                FroMoRef localMoRef = new FroMoRef(this.tableHandler);
                localMoRef.convertManagedObjectToXml("", (ManagedObject)objectArrayToBeConverted[i]);
                this.xmlTagsList.add(localMoRef);
                continue;
            }
            if (!(objectArrayToBeConverted[i] instanceof Object[])) continue;
            FroArray localFroArray = new FroArray(this.tableHandler);
            localFroArray.convertObjectArrayToXml("", (Object[])objectArrayToBeConverted[i]);
            this.xmlTagsList.add(localFroArray);
        }
        return this.toXmlString();
    }

    public void parse(String xmlTagToBeParsed) throws ParseException {
        InputStream inputStream = null;
        try {
            this.initiated = false;
            this.subMoRef = FroMoRef.EMPTY;
            this.subStruct = FroStruct.EMPTY;
            this.subArray = FroArray.EMPTY;
            this.name = "";
            this.xmlTagsList.clear();
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.logger.traceDebug(this.thisClass, "XMLReader created");
            parser.setContentHandler(this);
            inputStream = new ByteArrayInputStream(xmlTagToBeParsed.getBytes());
            this.logger.traceDebug(this.thisClass, "XMLReader try parse: " + xmlTagToBeParsed);
            parser.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            String errorMsg = AueUtil.appendReason("Could not parse the array information.", e);
            this.logger.traceError(this.thisClass, errorMsg, e);
            throw new ParseException(errorMsg, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception ignore) {}
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean insideSubArrayTag;
        boolean insideSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            this.subStruct.startElement(uri, localName, qName, attributes);
        } else if (insideSubArrayTag) {
            this.subArray.startElement(uri, localName, qName, attributes);
        } else if (insideSubMoRefTag) {
            this.subMoRef.startElement(uri, localName, qName, attributes);
        } else if ("array".equals(localName)) {
            if (this.initiated) {
                this.subArray = new FroArray(this.tableHandler);
                this.subArray.startElement(uri, localName, qName, attributes);
            } else {
                this.name = attributes.getValue("name");
                this.initiated = true;
            }
        } else if ("struct".equals(localName)) {
            this.subStruct = new FroStruct(this.tableHandler);
            this.subStruct.startElement(uri, localName, qName, attributes);
        } else if ("moref".equals(localName)) {
            this.subMoRef = new FroMoRef(this.tableHandler);
            this.subMoRef.startElement(uri, localName, qName, attributes);
        } else if ("attr".equals(localName)) {
            String type = attributes.getValue("type");
            String value = attributes.getValue("value");
            TypeValue typeValue = new TypeValue(type, value);
            this.xmlTagsList.add(typeValue);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean insideSubArrayTag;
        boolean insidSubMoRefTag = !FroMoRef.EMPTY.equals(this.subMoRef);
        boolean insideSubStructTag = !FroStruct.EMPTY.equals(this.subStruct);
        boolean bl = insideSubArrayTag = !FroArray.EMPTY.equals(this.subArray);
        if (insideSubStructTag) {
            if ("struct".equals(localName)) {
                this.xmlTagsList.add(this.subStruct);
                this.subStruct = FroStruct.EMPTY;
            } else {
                this.subStruct.endElement(uri, localName, qName);
            }
        } else if (insideSubArrayTag) {
            if ("array".equals(localName)) {
                this.xmlTagsList.add(this.subArray);
                this.subArray = FroArray.EMPTY;
            } else {
                this.subArray.endElement(uri, localName, qName);
            }
        } else if (insidSubMoRefTag) {
            if ("moref".equals(localName)) {
                this.xmlTagsList.add(this.subMoRef);
                this.subMoRef = FroMoRef.EMPTY;
            } else {
                this.subMoRef.endElement(uri, localName, qName);
            }
        } else if ("array".equals(localName)) {
            this.initiated = false;
        }
    }
}

