/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DerivedDataTypeRef;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomParameter;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;

public class MomParameterImpl
extends MomBase
implements MomParameter,
MomEntityResolvable {
    private static final String DATA_TYPE = "dataType: ";
    private String kind;
    private static final String APPLICATION_TAG = "ApplicationTag: ";
    private static final String DESCRIPTION = "Description: ";
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private MomEntity type;
    private DomainExtension domainExtension;

    public MomParameterImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public MomEntity getType() {
        return this.type;
    }

    public void setType(MomEntity type) {
        this.type = type;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String direction) {
        this.kind = direction;
    }

    public void setResolvedEntity(MomEntity resolved) {
        this.setType(resolved);
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public String getExtendedDescription() {
        MomEntity momEntity;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDescription() != null) {
            stringBuffer.append("Description: \n" + this.getDescription() + NEW_LINE + NEW_LINE);
        }
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG);
            stringBuffer.append(this.getApplicationTag());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        if (!this.getTypeInfo().equals("")) {
            stringBuffer.append(DATA_TYPE);
            stringBuffer.append(this.getTypeInfo());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        if ((momEntity = this.getType()) instanceof MomEnumRef) {
            MomEnumRef momEnumRef = (MomEnumRef)momEntity;
            stringBuffer.append(momEnumRef.getExtendedDescription());
        }
        return stringBuffer.toString();
    }

    public String getTypeInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        MomEntity entity = this.getType();
        if (entity instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute momCorbaTypeAttribute = (MomCorbaTypeAttribute)entity;
            stringBuffer.append(momCorbaTypeAttribute.getXmlType() + SPACE);
        } else if (entity instanceof MomSequence) {
            MomSequence momSequence = (MomSequence)entity;
            stringBuffer.append(momSequence.getTypeInfo() + SPACE);
        } else if (entity instanceof MomEnumRef) {
            MomEnumRef enumRef = (MomEnumRef)entity;
            stringBuffer.append(enumRef.getEnum().getName() + SPACE);
        } else if (entity instanceof MomStructRef) {
            MomStructRef structRef = (MomStructRef)entity;
            stringBuffer.append(structRef.getStruct().getTypeInfo() + SPACE);
        } else if (entity instanceof MoRef) {
            MoRef moRef = (MoRef)entity;
            stringBuffer.append(moRef.getName() + SPACE);
        } else if (entity instanceof DerivedDataTypeRef) {
            DerivedDataTypeRef derivedDataTypeRef = (DerivedDataTypeRef)entity;
            stringBuffer.append(derivedDataTypeRef.getName() + SPACE);
        }
        return stringBuffer.toString();
    }
}

