/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomCorbaTypeAttributeImpl;
import se.ericsson.cello.mimparser.state.DefaultValueState;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.MultiplicationFactorState;
import se.ericsson.cello.mimparser.state.ResolutionState;
import se.ericsson.cello.mimparser.state.UnitState;
import se.ericsson.cello.mimparser.state.ValidValuesState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class CorbaTypeAttributeState
extends MomBaseState {
    private MomCorbaTypeAttributeImpl momCorbaType;
    private static final String[] allPossibleCorbaTypes = new String[]{"boolean", "octet", "char", "double", "float", "long", "longlong", "short", "string", "wstring"};

    public CorbaTypeAttributeState(MomCorbaTypeAttributeImpl momCorbaType, String returnTag) {
        super(returnTag);
        this.momCorbaType = momCorbaType;
    }

    public static boolean isCorbaType(String type) {
        boolean isType = false;
        for (int i = 0; i < allPossibleCorbaTypes.length; ++i) {
            if (!type.equals(allPossibleCorbaTypes[i])) continue;
            isType = true;
            break;
        }
        return isType;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        if (name.equals("defaultValue")) {
            stateMachine.pushState(new DefaultValueState(this.momCorbaType));
        } else if (name.equals("min")) {
            stateMachine.pushState(new MinState(this.momCorbaType));
        } else if (name.equals("max")) {
            stateMachine.pushState(new MaxState(this.momCorbaType));
        } else if (name.equals("validValues")) {
            stateMachine.pushState(new ValidValuesState(this.momCorbaType));
        } else if (name.equals("unit")) {
            stateMachine.pushState(new UnitState(this.momCorbaType));
        } else if (name.equals("multiplicationFactor")) {
            stateMachine.pushState(new MultiplicationFactorState(this.momCorbaType));
        } else if (name.equals("resolution")) {
            stateMachine.pushState(new ResolutionState(this.momCorbaType));
        }
    }
}

