/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DerivedDataTypeRefImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MoRefImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomCorbaTypeAttributeImpl;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomEnumRefImpl;
import se.ericsson.cello.mimparser.model.MomSequenceImpl;
import se.ericsson.cello.mimparser.model.MomStructMemberImpl;
import se.ericsson.cello.mimparser.model.MomStructRefImpl;
import se.ericsson.cello.mimparser.state.CorbaTypeAttributeState;
import se.ericsson.cello.mimparser.state.DerivedDataTypeRefState;
import se.ericsson.cello.mimparser.state.EnumRefState;
import se.ericsson.cello.mimparser.state.MoRefState;
import se.ericsson.cello.mimparser.state.SequenceState;
import se.ericsson.cello.mimparser.state.StructRefState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class DataTypeManager {
    private MimModelImpl mimModel;
    private StateMachine stateMachine;

    public DataTypeManager(MimModelImpl mimModel, StateMachine stateMachine) {
        this.mimModel = mimModel;
        this.stateMachine = stateMachine;
    }

    public void handleDataTypes(MomEntityResolvable mr, String name, Attributes attributes) {
        String parentName = "";
        if (!(mr instanceof MomBase) || (parentName = ((MomBase)((Object)mr)).getName()) != null || !(mr instanceof MomSequenceImpl) || (parentName = ((MomSequenceImpl)mr).getSeqName()) == null) {
            // empty if block
        }
        if (CorbaTypeAttributeState.isCorbaType(name)) {
            MomCorbaTypeAttributeImpl corbaTypeAttribute = new MomCorbaTypeAttributeImpl(name, parentName, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            mr.setResolvedEntity(corbaTypeAttribute);
            this.stateMachine.pushState(new CorbaTypeAttributeState(corbaTypeAttribute, name));
        } else if (name.equals("enumRef")) {
            String enumName = attributes.getValue("name");
            MomEnumRefImpl enumRefImpl = new MomEnumRefImpl(name, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            this.mimModel.addMomEntityEnumToBeResolved(enumName, enumRefImpl);
            mr.setResolvedEntity(enumRefImpl);
            this.stateMachine.pushState(new EnumRefState(enumRefImpl));
        } else if (name.equals("structRef")) {
            String structName = attributes.getValue("name");
            MomStructRefImpl structRefImpl = new MomStructRefImpl(name, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            this.mimModel.addMomEntityStructToBeResolved(structName, structRefImpl);
            mr.setResolvedEntity(structRefImpl);
            this.stateMachine.pushState(new StructRefState(structRefImpl));
        } else if (name.equals("derivedDataTypeRef")) {
            String dataTypeRefName = attributes.getValue("name");
            DerivedDataTypeRefImpl dataTypeRefImpl = new DerivedDataTypeRefImpl(name, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            this.mimModel.addMomEntityDerivedDataTypeToBeResolved(dataTypeRefName, dataTypeRefImpl);
            mr.setResolvedEntity(dataTypeRefImpl);
            this.stateMachine.pushState(new DerivedDataTypeRefState(dataTypeRefImpl));
        } else if (name.equals("moRef")) {
            String moRefName = attributes.getValue("name");
            MoRefImpl moRefImpl = new MoRefImpl(name, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            this.mimModel.addMomEntityMoToBeResolved(moRefName, moRefImpl);
            mr.setResolvedEntity(moRefImpl);
            this.stateMachine.pushState(new MoRefState(moRefImpl));
        } else if (name.equals("sequence")) {
            MomSequenceImpl momSequenceImpl = new MomSequenceImpl(name, attributes, this.mimModel, this.stateMachine.getParseInfo().getNextId());
            if (mr instanceof MomStructMemberImpl) {
                MomStructMemberImpl tempStruct = (MomStructMemberImpl)mr;
                String tempSeqName = tempStruct.getName();
                momSequenceImpl.setSeqName(tempSeqName);
            }
            mr.setResolvedEntity(momSequenceImpl);
            this.stateMachine.pushState(new SequenceState(momSequenceImpl));
        }
    }
}

