/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSupportedImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class SupportedState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable {
    public static final String SUPPORTED_TAG = "supported";
    private MomRelationshipImpl momRelationship;
    private MomSupportedImpl momSupported;
    private MimModelImpl model;

    public SupportedState(MomRelationshipImpl momRelationship, MomSupportedImpl momSupported) {
        super(SUPPORTED_TAG);
        this.momRelationship = momRelationship;
        this.momSupported = momSupported;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        this.model = stateMachine.getParseInfo().getMimModel();
        if (name.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (name.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (name.equals("hasClass")) {
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl hasClass = new MomHasClassImpl(attributes, momClass);
            this.momSupported.setHasClass(hasClass);
            this.momRelationship.setToElementName(attributes.getValue("name"));
        } else if (name.equals("cardinality")) {
            this.momSupported.setCardinality(this.getCardinality());
        } else if (name.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (name.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        }
    }

    public void setDescription(String description) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setDescription(description);
    }

    public void setApplicationTag(String applicationTag) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setApplicationTag(applicationTag);
    }

    public void addMinValue(String minValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMin(minValue);
    }

    public void addMaxValue(String maxValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMax(maxValue);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl endInfo = (MomRelationshipEndInfoImpl)this.momRelationship.getToInfo();
        if (endInfo == null) {
            endInfo = new MomRelationshipEndInfoImpl();
            this.momRelationship.setToInfo(endInfo);
        }
        return endInfo;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl cardinality = (MomCardinalityImpl)this.momRelationship.getToCardinality();
        if (cardinality == null) {
            cardinality = new MomCardinalityImpl(this.model);
            this.momRelationship.setToCardinality(cardinality);
        }
        return cardinality;
    }
}

