/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class TransactionWrapper {
    private static final int TRANSACTION_TIMEOUT_DEFAULT = 100;
    private static final long RETRY_INTERVAL = 10L;
    private final Control control;
    private final Coordinator coordinator;

    public TransactionWrapper() throws TransactionRolledBackException {
        this(100);
    }

    public TransactionWrapper(int timeOut) throws TransactionRolledBackException {
        this.control = this.getControl(timeOut);
        this.coordinator = this.control.getCoordinator();
    }

    public TransactionWrapper(int timeOut, String failureMessagePreamble) {
        try {
            this.control = this.getControl(timeOut);
            this.coordinator = this.control.getCoordinator();
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), failureMessagePreamble, e);
            throw new IllegalStateException(failureMessagePreamble + ": " + (Object)((Object)e));
        }
    }

    private Control getControl(int timeOut) throws TransactionRolledBackException {
        try {
            return TransactionServiceImpl.instance().getTransactionFactory().create(timeOut);
        }
        catch (TransactionRolledBackException e) {
            MessageLog.traceError(this.getClass(), " Instantiation failed on first attempt, retrying in 10s", e);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return TransactionServiceImpl.instance().getTransactionFactory().create(timeOut);
        }
    }

    public void commit() throws InactiveTransactionException, TransactionRolledBackException {
        this.control.getTerminator().commit();
    }

    public void rollback() throws InactiveTransactionException {
        this.control.getTerminator().rollback();
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public int getID() {
        return this.coordinator.getTransactionID();
    }

    public boolean isActive() {
        return this.getCoordinator().getStatus() == Status.ACTIVE;
    }

    public boolean isMarkedAsRollback() {
        return this.getCoordinator().getStatus() == Status.MARKED_ROLLBACK;
    }
}

