/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.StackDumper;

public class AiMessageLog
extends MessageLog
implements NalLog {
    public static final String DEFAULT_LOG_FILE_NAME = "autoconfig.log";
    public static final String DEFAULT_TARGET_LOG_FILE_PATH = "/c/public_html/em/";
    public static final long MAX_LOG_FILE_SIZE = 4096000L;
    public static final int FLUSH_LIMIT = 100;
    protected static final long FLUSH_TIMEOUT = 10000L;
    private static AiMessageLog instance;
    private static SimpleDateFormat formatter;
    private static boolean log2FileOn;
    private static Object log2FileLock;
    private static String myFilePath;
    private static PrintStream out;
    private static int flushCount;
    private static long loggTime;
    private static Thread flushThread;

    public static synchronized AiMessageLog getInstance() {
        if (instance == null) {
            instance = new AiMessageLog();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void println(String s) {
        Object object = log2FileLock;
        synchronized (object) {
            if (!log2FileOn) {
                AiMessageLog.enableLogToFile("RbsConfiguration");
            }
            if (log2FileOn) {
                if (flushCount > 100) {
                    flushCount = 0;
                    AiMessageLog.close();
                    AiMessageLog.openTraceFile();
                }
                ++flushCount;
                try {
                    out.println(s);
                }
                catch (Exception e) {
                    se.ericsson.cello.support.debug.MessageLog.traceError((Class)MessageLog.class, (String)"println(), Failed to write to the Trace log file!!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryToOpenTraceFile() {
        Object object = log2FileLock;
        synchronized (object) {
            String myLogName = myFilePath + DEFAULT_LOG_FILE_NAME;
            try {
                File outFile = new File(myLogName);
                if (outFile.exists() && outFile.isFile()) {
                    if (out != null) {
                        out.flush();
                    }
                    if (outFile.length() < 4096000L) {
                        out = new PrintStream(new FileOutputStream(myLogName, true));
                    } else {
                        se.ericsson.cello.support.debug.MessageLog.info((Class)MessageLog.class, (String)("tryToOpenTraceFile ( )\n\tThe file '" + myLogName + "' has exceeded the maximum size " + 4096000L + "\n\t The contents is moved to file '" + myLogName + "_old" + "'.\n\tThe trace logging continues to the existing trace log file '" + myLogName + "'."));
                        try {
                            String theOldOutFileName = myLogName + "_old";
                            File theOldOutFile = new File(theOldOutFileName);
                            if (!outFile.renameTo(theOldOutFile)) {
                                MessageLog.traceError(MessageLog.class, "The file (" + outFile.getAbsolutePath() + ") could not be renamed");
                            }
                        }
                        catch (Exception e) {
                            se.ericsson.cello.support.debug.MessageLog.traceError((Class)MessageLog.class, (String)("tryToOpenTraceFile ( )\n\tFailed to move the contents to old file. The contents in existing file is deleted due to the maximum file size is reached.\n\tThe contents is moved to file '" + myLogName + "_old" + "'.\n\tThe trace logging continues to the existing trace log file '" + myLogName + "'." + "\n\tException message: " + e.toString()), null);
                        }
                        out = new PrintStream(new FileOutputStream(myLogName));
                    }
                } else {
                    File tmpDir = new File(myFilePath);
                    if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                        MessageLog.traceError(MessageLog.class, "Directory (" + tmpDir.getAbsolutePath() + ") could not be created");
                    }
                    out = new PrintStream(new FileOutputStream(myLogName));
                }
                return out != null;
            }
            catch (FileNotFoundException e) {
                AiMessageLog.close();
                return false;
            }
        }
    }

    private static synchronized void debug(String msg) {
        if (flushThread == null || !flushThread.isAlive()) {
            Runnable r = new Runnable(){

                public void run() {
                    boolean done = false;
                    while (!done) {
                        long latestLoggTime;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - (latestLoggTime = loggTime) > 10000L) {
                            AiMessageLog.flush();
                            done = true;
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            flushThread = new Thread(r);
            flushThread.start();
        }
        AiMessageLog.println(AiMessageLog.getTimeStamp() + msg + "\n");
        loggTime = System.currentTimeMillis();
    }

    private static String getTimeStamp() {
        return formatter.format(new Date()) + "\t";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLog(String userMoType) {
        Object object = log2FileLock;
        synchronized (object) {
            if (!AiMessageLog.hasAccess(userMoType)) {
                AiMessageLog.trace(1, MessageLog.class, "Ilegal user access deleteLog(). User: " + userMoType);
                return;
            }
            log2FileOn = false;
            String myLogName = myFilePath + DEFAULT_LOG_FILE_NAME;
            AiMessageLog.close();
            File outFile = new File(myLogName);
            if (outFile.exists()) {
                if (outFile.delete()) {
                    se.ericsson.cello.support.debug.MessageLog.info((Class)MessageLog.class, (String)("The log is deleted. " + myLogName));
                } else {
                    MessageLog.traceError(MessageLog.class, "The file (" + outFile.getAbsolutePath() + ") could not be deleted");
                }
            } else {
                se.ericsson.cello.support.debug.MessageLog.info((Class)MessageLog.class, (String)("The log is deleted. " + myLogName));
            }
            if (!AiMessageLog.openTraceFile()) {
                se.ericsson.cello.support.debug.MessageLog.traceError((Class)MessageLog.class, (String)("clearTraceFile(), Failed to open the Trace log file after delete log!! " + myLogName));
            }
        }
    }

    private static boolean openTraceFile() {
        boolean keepTrying = true;
        int counter = 1;
        Exception theException = null;
        while (keepTrying) {
            try {
                return AiMessageLog.tryToOpenTraceFile();
            }
            catch (Exception e) {
                theException = e;
                AiMessageLog.close();
                if (counter < 5) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++counter;
                    continue;
                }
                keepTrying = false;
            }
        }
        if (theException != null) {
            se.ericsson.cello.support.debug.MessageLog.traceError((Class)MessageLog.class, (String)("openTraceFile(), Exception caught 5 times when trying to open the trace file.\n\tLast caught Exception: " + theException));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            se.ericsson.cello.support.debug.MessageLog.traceError((Class)MessageLog.class, (String)("Could not close the log file " + myFilePath + DEFAULT_LOG_FILE_NAME + "due to exception:"), (Throwable)e);
        }
        finally {
            out = null;
        }
    }

    public static void flush() {
        AiMessageLog.disableLogToFile("RbsConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableLogToFile(String userMoType) {
        Object object = log2FileLock;
        synchronized (object) {
            if (!AiMessageLog.hasAccess(userMoType)) {
                AiMessageLog.trace(1, MessageLog.class, "Ilegal user access disableLogToFile(). User: " + userMoType);
                return;
            }
            log2FileOn = false;
            AiMessageLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableLogToFile(String userMoType) {
        Object object = log2FileLock;
        synchronized (object) {
            if (!AiMessageLog.hasAccess(userMoType)) {
                AiMessageLog.trace(1, MessageLog.class, "Ilegal user access enableLogToFile(). User: " + userMoType);
                return;
            }
            log2FileOn = AiMessageLog.openTraceFile();
        }
    }

    public static void _onlyForTest() {
        log2FileOn = false;
        myFilePath = AiMessageLog.getTempDirPath() + "/";
    }

    public static String getTempDirPath() {
        Object result2;
        Method method;
        Class<?> messageLog;
        try {
            messageLog = Class.forName("se.ericsson.cello.support.debug.MessageLog");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Temporary directory path must not be requested when BDE not present", e);
        }
        try {
            method = messageLog.getMethod("getTempDirPath", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Unexpected security exception when accessing BDE method MessageLog.getTempDirPath()", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing BDE method MessageLog.getTempDirPath()", e);
        }
        try {
            result2 = method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception when invoking BDE method MessageLog.getTempDirPath()", e);
        }
        if (result2 == null || !(result2 instanceof String)) {
            throw new RuntimeException("Temporary directory path could not be obtained from BDE");
        }
        return (String)result2;
    }

    private static boolean hasAccess(String userMoType) {
        return userMoType.equalsIgnoreCase("RbsConfiguration");
    }

    public static void trace(int group, Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", TRACE " + group + ", " + msg);
        MessageLog.trace(group, c, msg);
    }

    public static void traceError(Class c, String msg, Throwable exc) {
        AiMessageLog.debug(c.getName() + ", ERROR: " + msg + "\n" + StackDumper.stackDump(exc));
        MessageLog.traceError(c, msg, exc);
    }

    public static void traceError(Class c, String msg) {
        AiMessageLog.traceError(c, msg, null);
    }

    public static void info(Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", INFO: " + msg);
        MessageLog.info(c, msg);
    }

    public static void traceEnter(Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", ENTER: " + msg);
        MessageLog.traceEnter(c, msg);
    }

    public static void traceReturn(Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", RETURN: " + msg);
        MessageLog.traceReturn(c, msg);
    }

    public static void traceState(Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", STATE: " + msg);
        MessageLog.traceState(c, msg);
    }

    public static void traceParam(Class c, String msg) {
        AiMessageLog.debug(c.getName() + ", PARAM:" + msg);
        MessageLog.traceParam(c, msg);
    }

    public String getName() {
        return "se.ericsson.wcdma.rbs.bem";
    }

    public String getNalType() {
        return "external";
    }

    public int getTraceLevel() {
        return 1;
    }

    public boolean isTraced(int logLevel) {
        return true;
    }

    public void nalTrace(int traceLevel, Class c, String msg, Throwable exc) {
        this.nalTrace(1, c, msg + ", Exception: " + "\n" + StackDumper.stackDump(exc));
    }

    public void setTraceLevel(int logLevel) {
    }

    public void nalTrace(int group, Class c, String msg) {
        AiMessageLog.trace(group, c, msg);
    }

    public void nalTraceEnter(Class c, String msg) {
        AiMessageLog.traceEnter(c, msg);
    }

    public void nalTraceError(Class c, String msg, Throwable exc) {
        AiMessageLog.traceError(c, msg, exc);
    }

    public void nalTraceError(Class c, String msg) {
        AiMessageLog.traceError(c, msg);
    }

    public void nalTraceReturn(Class c, String msg) {
        AiMessageLog.traceReturn(c, msg);
    }

    protected void finalize() throws Throwable {
        AiMessageLog.close();
        super.finalize();
    }

    static {
        formatter = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss:SSS  z");
        log2FileOn = false;
        log2FileLock = new Object();
        myFilePath = "";
        flushCount = 0;
        myFilePath = DEFAULT_TARGET_LOG_FILE_PATH;
    }
}

