/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMasterExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;

public class MessageLog {
    private static ErrorList errorList = new ErrorList();
    private static MessageLog instance = new MessageLog();
    private static boolean probeOn = false;
    private static ProbeList probeList = new ProbeList();

    protected MessageLog() {
    }

    public static MessageLog instance() {
        return instance;
    }

    public static void trace(int group, Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.trace((int)group, (Class)c, (String)msg);
        if (probeOn) {
            MessageLog.probeList.add(msg);
        }
    }

    public static void traceError(Class c, String msg, Throwable exc) {
        se.ericsson.cello.support.debug.MessageLog.traceError((Class)c, (String)msg, (Throwable)exc);
        MessageLog.errorList.add(msg);
    }

    public static void traceError(Class c, String msg) {
        MessageLog.traceError(c, msg, null);
    }

    public static void info(Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.info((Class)c, (String)msg);
    }

    public static void traceEnter(Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.traceEnter((Class)c, (String)msg);
    }

    public static void traceReturn(Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.traceReturn((Class)c, (String)msg);
    }

    public static void traceState(Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.traceState((Class)c, (String)msg);
    }

    public static void traceParam(Class c, String msg) {
        se.ericsson.cello.support.debug.MessageLog.traceParam((Class)c, (String)msg);
    }

    public static void writeTraceToSystemLog(UpgradeMaster master, UpgradeParticipator participator, String triggerName, boolean isSuccess, Throwable e) {
        if (e != null && master instanceof UpgradeMasterExtended) {
            int confirmStatus = isSuccess ? 1 : 0;
            String stackTrace = "";
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                stackTrace = sw.toString();
                pw.close();
                sw.close();
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            ((UpgradeMasterExtended)master).triggerConfirmed(participator, triggerName, confirmStatus, new String[]{stackTrace});
        } else {
            master.triggerConfirmed(participator, triggerName, isSuccess);
        }
    }

    public static void resetErrorFlag() {
        errorList.clear();
    }

    public static boolean isAnyError() {
        return MessageLog.getErrorCount() > 0;
    }

    public static int getErrorCount() {
        return MessageLog.errorList.getCount();
    }

    public static void enableDisableTe(boolean value) {
    }

    public static void enableProbe(boolean value) {
        probeOn = value;
        MessageLog.clearProbe();
    }

    public static void clearProbe() {
        probeList.clear();
    }

    public static boolean probeEquals(String target) {
        return probeList.contains(target);
    }

    public static boolean probeContains(String target) {
        int probeListsize = probeList.size();
        for (int i = 0; i < probeListsize; ++i) {
            if (probeList.get(i).toString().indexOf(target) == -1) continue;
            return true;
        }
        return false;
    }

    public static int getProbeListMaxLength() {
        return 2000;
    }

    public static String getErrors() {
        StringBuffer errors = new StringBuffer();
        Iterator it = errorList.iterator();
        while (it.hasNext()) {
            errors.append("\n" + it.next());
        }
        return errors.toString();
    }

    private static class ProbeList
    extends ArrayList {
        private static final long serialVersionUID = 1L;
        private static final int LEN = 2000;
        private static boolean printOnlyOnce = true;

        public ProbeList() {
            super(200);
        }

        private void add(String s) {
            if (this.size() == 2000) {
                if (printOnlyOnce) {
                    se.ericsson.cello.support.debug.MessageLog.info(this.getClass(), (String)"The probeList is full now.");
                    printOnlyOnce = false;
                }
                return;
            }
            super.add(s);
        }
    }

    private static class ErrorList
    extends LinkedList {
        private static final long serialVersionUID = 1L;
        private static final int LEN = 3;
        private int resetCount = 1;
        private int count = 0;

        private ErrorList() {
        }

        private int add(String s) {
            if (this.size() == 3) {
                this.remove(2);
            }
            super.addLast(this.resetCount + "." + ++this.count + ": " + s);
            return this.count;
        }

        public void clear() {
            if (this.count > 0) {
                ++this.resetCount;
            }
            super.clear();
            this.count = 0;
        }

        private int getCount() {
            return this.count;
        }
    }
}

