/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import java.util.Iterator;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsDchEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetHiParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetHiParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetOngoingRlsActReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetOngoingRlsActRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetToaeDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetToaeDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHiMonitoringStartReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHiMonitoringStopReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGetCcMacl1ReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGetCcMacl1RspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGetPqMacl1ReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGetPqMacl1RspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGpehStartReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGpehStartRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGpehStopReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsGpehStopRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsReleaseCcMacl1ReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsSetCcMacl1ReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsSetPqMacl1ReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsRlsStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetRlsSirTargetReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetRlsSirTargetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetToaeDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetToaeDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDpcchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDpcchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDpdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBerDpdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBlerDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBlerDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartOosDurDpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartOosDurDpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenDpdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenDpdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartUlSirDpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartUlSirDpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDpcchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDpcchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDpdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBerDpdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBlerDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBlerDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopOosDurDpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopOosDurDpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenDpdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenDpdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopUlSirDpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopUlSirDpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscFmDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscFmDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.links.RadioLinksCellMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;

public class ChcRlsProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static ChcRlsProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsDchRadioLinkResMgr";
    public static final String PMS_GRP_RLS_PM_MEAS_CODEPOWER = "RlsPmMeasCodepower";
    public static final String PMS_GRP_RLS_PM_MEAS_SIR = "RlsPmMeasSir";
    public static final String PMS_GRP_RLS_PM_STATE_TRANSITION = "RlsPmStateTransition";
    public static final String PMS_GRP_LRS_RLS_PM_UL_SYNCH_TIME = "LrsRlsPmUlSynchTime";
    public static final int CLIENT_ID = 0;
    public static final int RADIO_LINKS_ADDITIONAL_IDENTITY = 11111;
    public static final int RADIO_LINKS_CELL_ADDITIONAL_IDENTITY = 99999;

    private ChcRlsProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsDchEventIndS.class);
    }

    public static synchronized ChcRlsProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcRlsProxy();
        }
        return theOneAndOnly;
    }

    private boolean isCellCounter(String name) {
        Iterator it = RadioLinksCellMoFactory.instance().getCounters().iterator();
        while (it.hasNext()) {
            Counter counter = (Counter)it.next();
            if (!counter.getGroup().getGroupName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void releaseMacHsL1ParamCCPQHidden(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsReleaseCcMacl1ReqS reqSig = new LrsRlsReleaseCcMacl1ReqS(clientId, ccId);
        this.sendAndRec(reqSig);
    }

    public LrsRlsGetCcMacl1RspS readMacHsL1ParamCCHidden(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsGetCcMacl1ReqS reqSig = new LrsRlsGetCcMacl1ReqS(clientId, ccId);
        return (LrsRlsGetCcMacl1RspS)this.sendAndRec(reqSig);
    }

    public void setMacHsL1ParamPQHidden(int clientId, int ccId, int prioQueueId, int pqLengthMode, int pqLength) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsSetPqMacl1ReqS reqSig = new LrsRlsSetPqMacl1ReqS(clientId, ccId, prioQueueId, pqLengthMode, pqLength);
        this.sendAndRec(reqSig);
    }

    public LrsRlsGetPqMacl1RspS readMacHsL1ParamPQHidden(int clientId, int ccId, int prioQueueId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsGetPqMacl1ReqS reqSig = new LrsRlsGetPqMacl1ReqS(clientId, ccId, prioQueueId);
        return (LrsRlsGetPqMacl1RspS)this.sendAndRec(reqSig);
    }

    public void setMacHsL1ParamCCHidden(int clientId, int ccId, int aDpchSyncStateMode, int aDpchSyncState, int rxQualAchievableMode, int rxQualAchievable) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsSetCcMacl1ReqS reqSig = new LrsRlsSetCcMacl1ReqS(clientId, ccId, aDpchSyncStateMode, aDpchSyncState, rxQualAchievableMode, rxQualAchievable);
        this.sendAndRec(reqSig);
    }

    public LrsStartUlSirDpchRspS startUlSirDpch(int clientId, int ccFroId, String fileName) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartUlSirDpchReqS reqSig = new LrsStartUlSirDpchReqS(clientId, ccFroId, fileName);
        return (LrsStartUlSirDpchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopUlSirDpchRspS stopUlSirDpch(int clientId, int ccFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopUlSirDpchReqS reqSig = new LrsStopUlSirDpchReqS(clientId, ccFroId);
        return (LrsStopUlSirDpchRspS)this.sendAndRec(reqSig);
    }

    public LrsStartOosDurDpchRspS startOosDurDpch(int clientId, int ccFroId, int measPeriod, int measTime, int reportPeriod, String fileName) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartOosDurDpchReqS reqSig = new LrsStartOosDurDpchReqS(clientId, ccFroId, measPeriod, measTime, reportPeriod, fileName);
        return (LrsStartOosDurDpchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopOosDurDpchRspS stopOosDurDpch(int clientId, int ccFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopOosDurDpchReqS reqSig = new LrsStopOosDurDpchReqS(clientId, ccFroId);
        return (LrsStopOosDurDpchRspS)this.sendAndRec(reqSig);
    }

    public LrsSetRlsSirTargetRspS setRlsSirTarget(int clientId, int ccFroId, int sirTarget) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSetRlsSirTargetReqS reqSig = new LrsSetRlsSirTargetReqS(clientId, ccFroId, sirTarget);
        return (LrsSetRlsSirTargetRspS)this.sendAndRec(reqSig);
    }

    public LrsStartPnGenDchRspS startPnGenDch(int clientId, int ccFroId, int dchId, int pnTfi) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartPnGenDchReqS reqSig = new LrsStartPnGenDchReqS(clientId, ccFroId, dchId, pnTfi);
        return (LrsStartPnGenDchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopPnGenDchRspS stopPnGenDch(int clientId, int ccId, int dchId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopPnGenDchReqS reqSig = new LrsStopPnGenDchReqS(clientId, ccId, dchId);
        return (LrsStopPnGenDchRspS)this.sendAndRec(reqSig);
    }

    public LrsStartBlerDchRspS startBlerDch(int clientId, int ccId, int dchId, int measTime, String filename) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartBlerDchReqS reqSig = new LrsStartBlerDchReqS(clientId, ccId, dchId, measTime, filename);
        return (LrsStartBlerDchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopBlerDchRspS stopBlerDch(int clientId, int ccId, int dchId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopBlerDchReqS reqSig = new LrsStopBlerDchReqS(clientId, ccId, dchId);
        return (LrsStopBlerDchRspS)this.sendAndRec(reqSig);
    }

    public void startHiMonitoring(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsHiMonitoringStartReqS reqSig = new LrsHiMonitoringStartReqS(clientId, ccId);
        this.sendAndRec(reqSig);
    }

    public void stopHiMonitoring(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsHiMonitoringStopReqS reqSig = new LrsHiMonitoringStopReqS(clientId, ccId);
        this.sendAndRec(reqSig);
    }

    public LrsGetHiParamRspS getHiMonitoring(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetHiParamReqS reqSig = new LrsGetHiParamReqS(clientId);
        return (LrsGetHiParamRspS)this.sendAndRec(reqSig);
    }

    public LrsStartBerDchRspS startBerDch(int clientId, int ccId, int dchId, int berMode, int measTime, String filename) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartBerDchReqS reqSig = new LrsStartBerDchReqS(clientId, ccId, dchId, berMode, measTime, filename);
        return (LrsStartBerDchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopBerDchRspS stopBerDch(int clientId, int ccId, int dchId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopBerDchReqS reqSig = new LrsStopBerDchReqS(clientId, ccId, dchId);
        return (LrsStopBerDchRspS)this.sendAndRec(reqSig);
    }

    public LrsGetOngoingRlsActRspS getOngoingRlsAct(int clientId, int channelType, int actType) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetOngoingRlsActReqS reqSig = new LrsGetOngoingRlsActReqS(clientId, channelType, actType);
        return (LrsGetOngoingRlsActRspS)this.sendAndRec(reqSig);
    }

    public LrsStartPnGenDpdchRspS startPnGenDpdch(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartPnGenDpdchReqS reqSig = new LrsStartPnGenDpdchReqS(clientId, ccId);
        return (LrsStartPnGenDpdchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopPnGenDpdchRspS stopPnGenDpdch(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopPnGenDpdchReqS reqSig = new LrsStopPnGenDpdchReqS(clientId, ccId);
        return (LrsStopPnGenDpdchRspS)this.sendAndRec(reqSig);
    }

    public LrsStartBerDpcchRspS startBerDpcch(int clientId, int ccId, int measTime, String filename) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartBerDpcchReqS reqSig = new LrsStartBerDpcchReqS(clientId, ccId, measTime, filename);
        return (LrsStartBerDpcchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopBerDpcchRspS stopBerDpcch(int clientId, int ccId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopBerDpcchReqS reqSig = new LrsStopBerDpcchReqS(clientId, ccId);
        return (LrsStopBerDpcchRspS)this.sendAndRec(reqSig);
    }

    public LrsStartBerDpdchRspS startBerDpdch(int clientId, int ccId, int dchId, int measPeriod, String filename) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartBerDpdchReqS reqSig = new LrsStartBerDpdchReqS(clientId, ccId, dchId, measPeriod, filename);
        return (LrsStartBerDpdchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopBerDpdchRspS stopBerDpdch(int clientId, int ccId, int dchId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopBerDpdchReqS reqSig = new LrsStopBerDpdchReqS(clientId, ccId, dchId);
        return (LrsStopBerDpdchRspS)this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        int[] results;
        MessageLog.traceEnter(this.getClass(), " pmsStart()");
        int additionalIdentity = -1;
        if (additionalInfo != null && additionalInfo.length > 0) {
            additionalIdentity = additionalInfo[0];
        }
        if ((results = this.swapFroIdIfNeeded(froId, name, additionalIdentity))[1] == 0) {
            return;
        }
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStart(name, granularityPeriod, results[0], bbPoolId, additionalInfo);
        } else {
            this.rlsStartPm(0, this.getMeasureType(name), results[0], granularityPeriod);
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        int[] results;
        MessageLog.traceEnter(this.getClass(), " pmsStop()");
        int additionalIdentity = -1;
        if (additionalInfo != null && additionalInfo.length > 0) {
            additionalIdentity = additionalInfo[0];
        }
        if ((results = this.swapFroIdIfNeeded(froId, name, additionalIdentity))[1] == 0) {
            return;
        }
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStop(name, results[0], bbPoolId, additionalInfo);
        } else {
            this.rlsStopPm(0, this.getMeasureType(name), results[0]);
        }
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        int[] results;
        MessageLog.traceEnter(this.getClass(), " getPmsAttribute()");
        int additionalIdentity = -1;
        if (additionalInfo != null && additionalInfo.length > 0) {
            additionalIdentity = additionalInfo[0];
        }
        if ((results = this.swapFroIdIfNeeded(froId, name, additionalIdentity))[1] == 0) {
            return new ScannedValue[0];
        }
        return ChcMeasurementProxy.instance().getPmsAttribute(name, results[0], bbPoolId, additionalInfo);
    }

    private LrsRlsStartPmRspS rlsStartPm(int clientId, int measType, int froId, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsStartPmReqS reqSig = new LrsRlsStartPmReqS(clientId, measType, froId, granularityPeriod);
        return (LrsRlsStartPmRspS)this.sendAndRec(reqSig);
    }

    private LrsRlsStopPmRspS rlsStopPm(int clientId, int measType, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsStopPmReqS reqSig = new LrsRlsStopPmReqS(clientId, measType, froId);
        return (LrsRlsStopPmRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscFmDchRspS subscFmDch(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscFmDchReqS reqSig = new LrsSubscFmDchReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscFmDchRspS)this.sendAndRec(reqSig);
    }

    public LrsGetToaeDchRspS getToAeDch(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetToaeDchReqS reqSig = new LrsGetToaeDchReqS(transactionId, clientId);
        return (LrsGetToaeDchRspS)this.sendAndRec(reqSig);
    }

    public LrsSetToaeDchRspS setToAeDch(int transactionId, int clientId, int toAE) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSetToaeDchReqS reqSig = new LrsSetToaeDchReqS(transactionId, clientId, toAE);
        return (LrsSetToaeDchRspS)this.sendAndRec(reqSig);
    }

    public LrsRlsGpehStartRspS gpehStart(int clientId, int eventId, int pmsId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsGpehStartReqS reqSig = new LrsRlsGpehStartReqS(clientId, eventId, pmsId);
        return (LrsRlsGpehStartRspS)this.sendAndRec(reqSig);
    }

    public LrsRlsGpehStopRspS gpehStop(int clientId, int eventId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsRlsGpehStopReqS reqSig = new LrsRlsGpehStopReqS(clientId, eventId);
        return (LrsRlsGpehStopRspS)this.sendAndRec(reqSig);
    }

    /*
     * WARNING - void declaration
     */
    private int getMeasureType(String groupOrAttr) throws RbsErrorException {
        void var2_2;
        int measType;
        if (groupOrAttr.equals(PMS_GRP_RLS_PM_MEAS_CODEPOWER)) {
            measType = 0;
        } else if (groupOrAttr.equals(PMS_GRP_RLS_PM_MEAS_SIR)) {
            measType = 3;
        } else if (groupOrAttr.equals("pmOutOfSynch")) {
            measType = 4;
        } else if (groupOrAttr.equals("pmDpcchBer")) {
            measType = 1;
        } else if (groupOrAttr.equals("pmDpdchBer")) {
            measType = 2;
        } else if (groupOrAttr.equals(PMS_GRP_LRS_RLS_PM_UL_SYNCH_TIME)) {
            measType = 5;
        } else if (groupOrAttr.equals("pmUlSynchTimeSHO")) {
            measType = 6;
        } else if (groupOrAttr.equals(PMS_GRP_RLS_PM_STATE_TRANSITION)) {
            measType = 7;
        } else {
            String diagnosis = " Unknown PMS counter [group] name `" + groupOrAttr + "'";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
        return (int)var2_2;
    }

    private boolean useChcMeasurementProxy(String counterName) {
        return PmCounterTableManager.isInPmCounterTable(counterName);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscFmDch(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private int[] swapFroIdIfNeeded(int froId, String name, int additionalIdentity) {
        int[] result2 = new int[2];
        int newFroId = froId;
        int isApplicable = 1;
        if (additionalIdentity == 11111) {
            try {
                CarrierMo carrier = (CarrierMo)BoamHelper.getMoForFroId("Carrier", froId);
                ManagedObject[] resBy = carrier.getReservedBy(null);
                RbsLocalCellMo rbsLocalCell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(resBy, "RbsLocalCell");
                if (rbsLocalCell != null && this.isCellCounter(name)) {
                    if (rbsLocalCell.isCombinedCell(null)) {
                        isApplicable = 0;
                    }
                    newFroId = rbsLocalCell.getFroId(null);
                }
            }
            catch (MoAccessException e) {
                MessageLog.traceError(this.getClass(), "swapFroIdIfNeeded error ocurred:" + (Object)((Object)e));
            }
        }
        result2[0] = newFroId;
        result2[1] = isApplicable;
        return result2;
    }
}

