/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcResetUnitInstallationReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcResetUnitInstallationRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetUniqueHwIdReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetUniqueHwIdRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSpecialIndT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcUniqueHwIdT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAuxPiuReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAuxPiuRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteAuxPiuReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteAuxPiuRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuBHwPidReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcLedInfoT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcRestartAuxPiuReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcRestartAuxPiuRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAuxPiuAdmStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAuxPiuAdmStateRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAuxPiuParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAuxPiuParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSwUpgradeReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSwUpgradeRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EqcAuxPiuProxy
extends EcGenericProxy {
    protected static final SignalPort portManager = PortManager.instance();
    private static EqcAuxPiuProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EqcAuxPiuProxy.class.getName();

    private EqcAuxPiuProxy() {
        super(SERVICE_NAME);
    }

    public static synchronized EqcAuxPiuProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcAuxPiuProxy();
        }
        return theOneAndOnly;
    }

    public EqcCreateAuxPiuRspS createAuxPiu(long transactionId, long clientId, int auxPiuType, int piuFroId1, int piuFroId2, String hubPosition, int additionalInfo, long sectorAntennaFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcCreateAuxPiuReqS reqSig = new EqcCreateAuxPiuReqS(transactionId, clientId, auxPiuType, piuFroId1, piuFroId2, additionalInfo, hubPosition, sectorAntennaFroId);
        return (EqcCreateAuxPiuRspS)this.sendAndRec(reqSig);
    }

    public EqcLedInfoT getLedInfo(long clientId, long transactionId, long froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getLedInfo()<---");
        EqcGetAuxPiuParamRspS rspSig = this.getAuxPiuParameters(transactionId, clientId, froId);
        return rspSig.ledInfo;
    }

    public EqcDeleteAuxPiuRspS deleteAuxPiu(long transactionId, long clientId, long auxPiuFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDeleteAuxPiuReqS reqSig = new EqcDeleteAuxPiuReqS(transactionId, clientId, auxPiuFroId);
        return (EqcDeleteAuxPiuRspS)this.sendAndRec(reqSig);
    }

    public EqcGetAuxPiuParamRspS getAuxPiuParameters(long transactionId, long clientId, long auxPiuFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetAuxPiuParamReqS reqSig = new EqcGetAuxPiuParamReqS(transactionId, clientId, auxPiuFroId);
        return (EqcGetAuxPiuParamRspS)this.sendAndRec(reqSig);
    }

    public EqcSetAuxPiuAdmStateRspS setAuxPiuAdmState(long transactionId, long clientId, long auxPiuFroId, int newAdmState) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetAuxPiuAdmStateReqS reqSig = new EqcSetAuxPiuAdmStateReqS(transactionId, clientId, auxPiuFroId, newAdmState);
        return (EqcSetAuxPiuAdmStateRspS)this.sendAndRec(reqSig);
    }

    public EqcRestartAuxPiuRspS restartAuxPiu(long transactionId, long clientId, long auxPiuFroId) throws FroRequestFailedException, FroNotAccessibleException {
        boolean roIsNotReady = true;
        int counter = 0;
        while (roIsNotReady && counter < 10) {
            try {
                this.verifyProxyAvaliable();
                roIsNotReady = false;
            }
            catch (FroNotAccessibleException e1) {
                try {
                    MessageLog.info(this.getClass(), "EqcBdhBoardDeviceHandler not published, waiting 10 Seconds for next try");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                ++counter;
            }
        }
        EqcRestartAuxPiuReqS reqSig = new EqcRestartAuxPiuReqS(clientId, auxPiuFroId);
        return (EqcRestartAuxPiuRspS)this.sendAndRec(reqSig);
    }

    public EqcSwUpgradeRspS upgradeSwPhase(long clientId, int upgradePhase) throws RbsErrorException, FroNotAccessibleException, FroRequestFailedException {
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        EqcSwUpgradeReqS reqSig = new EqcSwUpgradeReqS(clientId, upgradePhase, rbsServiceName);
        return (EqcSwUpgradeRspS)this.sendAndRec(reqSig);
    }

    public EqcGetAuxPiuBHwPidRspS getRbsBasicHwPidT(long transactionId, long clientId, long auxPiuFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetAuxPiuBHwPidReqS reqSig = new EqcGetAuxPiuBHwPidReqS(clientId, auxPiuFroId);
        return (EqcGetAuxPiuBHwPidRspS)this.sendAndRec(reqSig);
    }

    public EqcSetAuxPiuParamRspS setAuxPiuParam(int transactionId, int clientId, int auxPlugInUnitFroId, int plugInUnitFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetAuxPiuParamReqS reqSig = new EqcSetAuxPiuParamReqS(transactionId, clientId, auxPlugInUnitFroId, plugInUnitFroId);
        return (EqcSetAuxPiuParamRspS)this.sendAndRec(reqSig);
    }

    public EcSetUniqueHwIdRspS setUniqueHwId(int transactionId, int clientId, int auxPlugInUnitFroId, int externalAntenna, String uniqueHwId) throws FroRequestFailedException, FroNotAccessibleException {
        EcUniqueHwIdT ecUniqueHwIdT = new EcUniqueHwIdT(uniqueHwId.length(), uniqueHwId);
        EcSetUniqueHwIdReqS reqSig = new EcSetUniqueHwIdReqS(transactionId, clientId, auxPlugInUnitFroId, externalAntenna, ecUniqueHwIdT);
        return (EcSetUniqueHwIdRspS)this.sendAndRec(reqSig);
    }

    public EcSpecialIndT[] getSpecialIndicator(long clientId, long transactionId, long froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getSpecialIndicator()<---");
        EqcGetAuxPiuParamRspS rspSig = this.getAuxPiuParameters(transactionId, clientId, froId);
        return rspSig.specialInd;
    }

    public EcResetUnitInstallationRspS resetUnitInstallation(long clientId, long auxPiuFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "resetUnitInstallation()<---");
        EcResetUnitInstallationReqS rspSig = new EcResetUnitInstallationReqS(clientId, auxPiuFroId);
        return (EcResetUnitInstallationRspS)this.sendAndRec(rspSig);
    }
}

