/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.EventIndImpl;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcReportingUnitsListT;

public class EqcGroupEventIndS
extends EventIndImpl {
    public static final int SIG_NO = 16815006;
    public long clientId;
    public long groupFroId;
    public int groupEventType;
    public String additionalTextEvent;
    public EcReportingUnitsListT reportingUnits = new EcReportingUnitsListT();

    public EqcGroupEventIndS() {
        super(16815006);
        this.additionalTextEvent = "";
    }

    public EqcGroupEventIndS(long clientId, long groupFroId, int groupEventType, String additionalTextEvent, EcReportingUnitsListT reportingUnits) {
        super(16815006);
        this.clientId = clientId;
        this.groupFroId = groupFroId;
        this.groupEventType = groupEventType;
        this.additionalTextEvent = additionalTextEvent;
        this.reportingUnits = reportingUnits;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.froId = this.groupFroId = in.readU32();
            this.groupEventType = in.readS32();
            this.additionalTextEvent = Strings.toString(in.readS8Array(256));
            in.align(4);
            this.reportingUnits.nrOfResources = in.readS32();
            this.reportingUnits.resourceType = in.readS32Array(6);
            this.reportingUnits.resourceFroId = in.readU32Array(6);
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), "initReceive failed in EqcGroupEventIndS: " + e);
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeU32(this.groupFroId);
            out.writeS32(this.groupEventType);
            out.writeS8Array(Strings.getBytes(this.additionalTextEvent, 256));
            out.align(4);
            out.writeS32(this.reportingUnits.nrOfResources);
            out.writeS32Array(this.reportingUnits.resourceType);
            out.writeU32Array(this.reportingUnits.resourceFroId);
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), "initSend failed in EqcGroupEventIndS: " + e);
        }
    }
}

