/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.proxies;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.wcdma.rbs.boam.common.AlarmObserver;
import se.ericsson.wcdma.rbs.boam.common.DelayedFroObserver;
import se.ericsson.wcdma.rbs.boam.common.EventObserver;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.FroSignalInfo;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.Observer;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Logger;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.BoamPortManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.BoamProxyUtils;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.BoamSignalPort;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroServiceInd;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.NSAgent;

public abstract class FroProxy
implements SubscriptionObserver,
SignalObserver {
    public static final int DEREGISTER_FOR_ALARM_NOTY = 0;
    public static final int REGISTER_FOR_ALARM_NOTY = 1;
    public static final int DEREGISTER_FOR_EVENT_NOTY = 2;
    public static final int REGISTER_FOR_EVENT_NOTY = 3;
    public static final int DEREGISTER_FOR_PP_NOTY = 4;
    public static final int REGISTER_FOR_PP_NOTY = 5;
    public static final int DEREGISTER_FOR_FSP_NOTY = 6;
    public static final int REGISTER_FOR_FSP_NOTY = 7;
    public static final int CLIENT_ID_FOR_REG = 1;
    public static final int SERVICE_RESTARTED_TIMEOUT = 60000;
    private static final int VERIFY_PROXY_AVAILABLE_TIMEOUT = 100000;
    private static final int VERIFY_PROXY_AVAILABLE_POLLING_SLEEP = 1000;
    private static final int MAX_UNSUBSCRIBED_SIGNAL_QUEUE_LENGTH = 20;
    protected static final String SUBSCRIBE_NOTFICATION_ERROR_MSG = "Received result NOK from resource when subscribing to the notifications";
    private final Hashtable alarmObservers = new Hashtable();
    private final Hashtable eventObservers = new Hashtable();
    private final Hashtable ppObservers = new Hashtable();
    private final Vector txHandlerList = new Vector(10);
    private final Vector froStateObservers = new Vector(10);
    protected final String serviceName;
    protected final SignalPort signalPort;
    protected final BoamSignalPort boamSignalPort;
    private volatile AlarmTimer alarmTimerThread = null;
    private volatile boolean serviceHasBeenDown = false;
    private volatile boolean isServicePublished = false;
    protected OseProcess processId = null;
    private ArrayList unSubscribedSignalQueue = new ArrayList();
    private boolean isSubscriptionDone = false;

    protected FroProxy(String serviceName) {
        MessageLog.traceEnter(this.getClass(), "FroProxy(),service name:" + serviceName);
        this.serviceName = serviceName;
        this.signalPort = PortManager.instance();
        this.boamSignalPort = BoamPortManager.instance();
    }

    private static Class getSignalClass(String name) throws FroRequestFailedException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new FroRequestFailedException(name, 1, "OperationFailure", -1, "no class found for: " + name);
        }
    }

    public void _reset_onlyForTest(boolean all) {
        this.alarmObservers.clear();
        this.eventObservers.clear();
        if (all) {
            this.ppObservers.clear();
            this.txHandlerList.clear();
            this.froStateObservers.clear();
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalReceived(InSignal inSig) {
        MessageLog.traceEnter(this.getClass(), "signalReceived() <---");
        try {
            FroSignalInfo recSig = (FroSignalInfo)inSig;
            AlarmObserver moAlarm = null;
            EventObserver moEvent = null;
            PlugAndPlayObserver ppObserver = null;
            ArrayList arrayList = this.unSubscribedSignalQueue;
            synchronized (arrayList) {
                if (recSig.getIndType().equals("FaultInd")) {
                    moAlarm = (AlarmObserver)this.lookupAlrmObserver(recSig.getFroId());
                    if (moAlarm != null) {
                        moAlarm.alarmRaised((UnlinkedSignal)inSig, this.getClass().getName());
                    } else if (!this.isSubscriptionDone) {
                        this.enqueueUnsubscribedSignal(inSig);
                    } else {
                        MessageLog.traceError(this.getClass(), " Fault ind signal: froId [" + recSig.getFroId() + "] is not included in the fault indication subscription list");
                    }
                } else if (recSig.getIndType().equals("FaultCeased")) {
                    moAlarm = (AlarmObserver)this.lookupAlrmObserver(recSig.getFroId());
                    if (moAlarm != null) {
                        moAlarm.alarmCeased((UnlinkedSignal)inSig, this.getClass().getName());
                    } else if (!this.isSubscriptionDone) {
                        this.enqueueUnsubscribedSignal(inSig);
                    } else {
                        MessageLog.traceError(this.getClass(), " Fault ceased signal: froId [" + recSig.getFroId() + "] is not included in the fault indication subscription list");
                    }
                } else if (recSig.getIndType().equals("Event")) {
                    moEvent = (EventObserver)this.lookupEventObserver(recSig.getFroId());
                    if (moEvent != null) {
                        moEvent.eventRaised(inSig, this.getClass().getName());
                    } else if (!this.isSubscriptionDone) {
                        this.enqueueUnsubscribedSignal(inSig);
                    } else {
                        MessageLog.traceError(this.getClass(), " Event ind signal: froId [" + recSig.getFroId() + "] is not included in the event subscription list");
                    }
                } else if (recSig.getIndType().equals("PlugAndPlay")) {
                    ppObserver = (PlugAndPlayObserver)this.lookupPPObserver(recSig.getFroId());
                    if (ppObserver != null) {
                        ppObserver.plugAndPlayInd(inSig);
                    } else if (!this.isSubscriptionDone) {
                        this.enqueueUnsubscribedSignal(inSig);
                    } else {
                        MessageLog.traceError(this.getClass(), " PlugAndPlay ind signal: froId [" + recSig.getFroId() + "] is not included in the PlugAndPlay subscription list");
                    }
                } else {
                    BoamProxyUtils.unexpectedSignalReceived(inSig, this.getClass());
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "SW error, exception caught in FroProxy.java->signalReceived()", e);
        }
    }

    public abstract void subscribeToFroNotification();

    public void verifyProxyAvaliable() throws FroNotAccessibleException {
        this.verifyProxyAvaliable(100000);
    }

    public void verifyProxyAvaliable(int timeout) throws FroNotAccessibleException {
        int noOfTry = timeout / 1000;
        for (int counter = 0; !this.isServicePublished && counter < noOfTry; ++counter) {
            try {
                MessageLog.info(this.getClass(), this.serviceName + " not published, waiting " + 1000 + " ms before next try: " + counter + "(" + noOfTry + ")");
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        if (!this.isServicePublished) {
            MessageLog.traceError(this.getClass(), "ServiceNotPublished: " + this.serviceName);
            throw new FroNotAccessibleException(this.getClass().getName(), this.serviceName, "ServiceNotPublished");
        }
    }

    public boolean isFroAvailable() {
        if (!this.isServicePublished) {
            MessageLog.trace(7, this.getClass(), "ServiceNotPublished: " + this.serviceName);
            return false;
        }
        return true;
    }

    public Object lookupAlrmObserver(long froId) {
        return this.alarmObservers.get(new Long(froId));
    }

    public Object lookupEventObserver(long froId) {
        return this.eventObservers.get(new Long(froId));
    }

    public Object lookupPPObserver(long froId) {
        return this.ppObservers.get(new Long(froId));
    }

    public void registerForNotifications(Coordinator c, Observer aMaoRef, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "registerForNotifications(),   froId:" + aFroId);
        this.registerForNotifications(aMaoRef, aFroId);
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(aFroId, aMaoRef, 1);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        }
    }

    public void deregisterForNotifications(Coordinator c, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "deregisterForNotifications(), froId:" + aFroId);
        Observer maoRef = (Observer)this.alarmObservers.get(new Long(aFroId));
        OrderedAction orderedAction = new OrderedAction(aFroId, maoRef, 0);
        if (c != null) {
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        } else {
            this.deregisterForNotifications(maoRef, aFroId);
        }
    }

    public void registerForPlugAndPLayInd(Coordinator c, Observer aMaoRef, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "registerForPlugAndPLayInd(), froId:" + aFroId);
        this.registerForPlugAndPlay(aMaoRef, aFroId);
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(aFroId, aMaoRef, 5);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        }
    }

    public void deRegisterForPlugAndPLayInd(Coordinator c, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "deRegisterForPlugAndPLayInd(), froId:" + aFroId);
        Observer maoRef = (Observer)this.ppObservers.get(new Long(aFroId));
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(aFroId, maoRef, 4);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        } else {
            this.deregisterForPlugAndPlay(aFroId);
        }
    }

    public void registerForEventInd(Coordinator c, EventObserver aMaoRef, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "registerForEventInd(), froId:" + aFroId);
        this.registerForEventInd(aMaoRef, aFroId);
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(aFroId, aMaoRef, 3);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        }
    }

    public void deRegisterForEventInd(Coordinator c, long aFroId) {
        MessageLog.traceEnter(this.getClass(), "deRegisterForEventInd(), froId:" + aFroId);
        Observer maoRef = (Observer)this.eventObservers.get(new Long(aFroId));
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(aFroId, maoRef, 2);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        } else {
            this.deRegisterForEventInd(aFroId);
        }
    }

    public void registerForStatePropagation(Coordinator c, Observer observer) {
        MessageLog.traceEnter(this.getClass(), "registerForStatePropagation(), observer:" + observer);
        int dummyFroId = 330033;
        this.registerForState(observer, 330033L);
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(330033L, observer, 7);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        }
    }

    public void deregisterForStatePropagation(Coordinator c, Observer observer) {
        MessageLog.traceEnter(this.getClass(), "deregisterForStatePropagation(), observer:" + observer);
        int dummyFroId = 330033;
        if (c != null) {
            OrderedAction orderedAction = new OrderedAction(dummyFroId, observer, 6);
            if (!this.isRegisteredInTransaction(c)) {
                this.txHandlerList.addElement(new TxHandlerCommonFroNotifyHandler(this, orderedAction, c));
            } else {
                this.storeAction(orderedAction, c);
            }
        } else {
            this.deRegisterForState(observer);
        }
    }

    public void addServiceObserver() {
        this.isServicePublished = false;
        MessageLog.traceEnter(this.getClass(), "addServiceObserver()");
        OseNameServer.addSubscriptionObserver((String)this.serviceName, (SubscriptionObserver)this);
    }

    public void serviceAdded(String aService) {
        MessageLog.traceEnter(this.getClass(), "serviceAdded(): service: " + aService);
        if (this.isServicePublished) {
            MessageLog.info(this.getClass(), "The service '" + aService + "' is already published, IGNORING this publication!!. This defect has been reported in WRNae21141 and WRNae24110.");
        } else {
            this.processId = OseNameServer.lookup((String)this.serviceName);
            this.isServicePublished = true;
            NSAgent.instance().addServiceInd(new FroServiceInd(this, aService, true));
        }
    }

    public void serviceRemoved(String aService) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()");
        MessageLog.trace(7, this.getClass(), "Service " + aService + " removed");
        this.isServicePublished = false;
        this.processId = null;
        this.serviceHasBeenDown = true;
        NSAgent.instance().addServiceInd(new FroServiceInd(this, aService, false));
    }

    public void distributeServiceRemove(String aService) {
        MessageLog.traceEnter(this.getClass(), "distributeServiceRemoved()");
        this.notifyProxyObserversOnRemove();
    }

    public void distributeServiceAdd(String aService) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "distributeServiceAdd(): Service " + aService + " added");
        this.notifyProxyObserversOnAdd(aService);
        this.subscribeToFroNotification();
        this.processUnsubscribedSignalQueue();
    }

    private void enqueueUnsubscribedSignal(InSignal inSignal) {
        if (this.unSubscribedSignalQueue.size() < 20) {
            this.unSubscribedSignalQueue.add(inSignal);
            MessageLog.trace(7, this.getClass(), "Subscription not yet done, adding signal " + inSignal.getSigNo() + " to queue.");
        } else {
            MessageLog.traceError(this.getClass(), "Too many signals in unsubscribed signal queue: " + this.unSubscribedSignalQueue.size() + ", Signal with no " + inSignal.getSigNo() + " will be droped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnsubscribedSignalQueue() {
        ArrayList arrayList = this.unSubscribedSignalQueue;
        synchronized (arrayList) {
            this.isSubscriptionDone = true;
            BoamPortManager portManager = (BoamPortManager)this.boamSignalPort;
            portManager.highPrioSignalsReceived(this.unSubscribedSignalQueue.toArray(new InSignal[this.unSubscribedSignalQueue.size()]));
            this.unSubscribedSignalQueue.clear();
        }
    }

    private void registerForPlugAndPlay(Observer aMaoRef, long froId) {
        if (!this.ppObservers.containsKey(new Long(froId))) {
            this.ppObservers.put(new Long(froId), aMaoRef);
        } else {
            MessageLog.traceError(this.getClass(), "registerForPlugAndPlay(), There is an object:" + this.ppObservers.get(new Long(froId)) + " already registered with froId:" + froId);
        }
    }

    private void deregisterForPlugAndPlay(long froId) {
        if (this.ppObservers.containsKey(new Long(froId))) {
            this.ppObservers.remove(new Long(froId));
        } else {
            MessageLog.traceError(this.getClass(), "deregisterForPlugAndPlay(), There is no shuch a froId:" + froId);
        }
    }

    private void registerForNotifications(Observer aMaoRef, long aFroId) {
        if (!this.alarmObservers.containsKey(new Long(aFroId))) {
            this.alarmObservers.put(new Long(aFroId), aMaoRef);
        } else {
            MessageLog.traceError(this.getClass(), "registerForNotifications(), There is an object already registered with froId:" + aFroId);
        }
    }

    private void deregisterForNotifications(Observer aMaoRef, long aFroId) {
        if (this.alarmObservers.containsKey(new Long(aFroId))) {
            this.alarmObservers.remove(new Long(aFroId));
        } else {
            MessageLog.traceError(this.getClass(), "deregisterForNotifications(), There is no shuch a froId:" + aFroId);
        }
    }

    private void registerForEventInd(Observer aMaoRef, long aFroId) {
        if (!this.eventObservers.containsKey(new Long(aFroId))) {
            this.eventObservers.put(new Long(aFroId), aMaoRef);
        } else {
            MessageLog.traceError(this.getClass(), "registerForEventInd(), There is an object already registered with froId:" + aFroId);
        }
    }

    private void deRegisterForEventInd(long aFroId) {
        if (this.eventObservers.containsKey(new Long(aFroId))) {
            this.eventObservers.remove(new Long(aFroId));
        } else {
            MessageLog.traceError(this.getClass(), "deRegisterForEventInd(), There is no such a froId:" + aFroId);
        }
    }

    private void registerForState(Observer aMaoRef, long aFroId) {
        if (!this.froStateObservers.contains(aMaoRef)) {
            this.froStateObservers.add(aMaoRef);
        } else {
            MessageLog.traceError(this.getClass(), "registerForState(), Object is already registered:" + aMaoRef);
        }
    }

    private void deRegisterForState(Observer aMaoRef) {
        if (this.froStateObservers.contains(aMaoRef)) {
            this.froStateObservers.remove(aMaoRef);
        } else {
            MessageLog.traceError(this.getClass(), "deRegisterForState(), There is no such a object:" + aMaoRef);
        }
    }

    private void removeTxHandler(TxHandlerCommonFroNotifyHandler txHandler) {
        boolean matchFound = false;
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if ((TxHandlerCommonFroNotifyHandler)this.txHandlerList.elementAt(i) != txHandler) continue;
            this.txHandlerList.removeElementAt(i);
            matchFound = true;
        }
        if (!matchFound) {
            MessageLog.traceError(FroProxy.class, "Private method removeTxHandler error", null);
        }
    }

    private void storeAction(OrderedAction aOrderedAction, Coordinator c) {
        int tranId = c.getTransactionID();
        boolean matchFound = false;
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if (((TxHandlerCommonFroNotifyHandler)this.txHandlerList.elementAt(i)).getTranId() != tranId) continue;
            ((TxHandlerCommonFroNotifyHandler)this.txHandlerList.elementAt(i)).addAction(aOrderedAction, c.getTransactionID());
            matchFound = true;
        }
        if (!matchFound) {
            MessageLog.traceError(FroProxy.class, "Private method storeAction error", null);
        }
    }

    private boolean isRegisteredInTransaction(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "isRegisteredInTransaction()");
        boolean isInTransaction = false;
        int tranId = c.getTransactionID();
        if (this.txHandlerList == null) {
            MessageLog.traceError(this.getClass(), "txHandlerList  is null");
        }
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if (((TxHandlerCommonFroNotifyHandler)this.txHandlerList.elementAt(i)).getTranId() != tranId) continue;
            isInTransaction = true;
        }
        return isInTransaction;
    }

    private void notifyProxyObserversOnAdd(String aService) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "notifyProxyObserversOnAdd()");
        Enumeration i = ((Vector)this.froStateObservers.clone()).elements();
        while (i.hasMoreElements()) {
            Object maoRef = i.nextElement();
            if (maoRef == null || !(maoRef instanceof FroStateObserver)) continue;
            FroStateObserver observer = (FroStateObserver)maoRef;
            observer.serviceAvailable(this.serviceName);
        }
        if (this.serviceHasBeenDown) {
            this.alarmTimerThread = new AlarmTimer(this, 60000);
            this.alarmTimerThread.start();
        }
    }

    private void notifyAlarmSubscribersOnTimeout() {
        MessageLog.traceEnter(this.getClass(), "notifyAlarmSubscribersOnTimeout()");
        Enumeration i = ((Hashtable)this.alarmObservers.clone()).elements();
        while (i.hasMoreElements()) {
            Object maoRef = i.nextElement();
            if (maoRef == null || !(maoRef instanceof DelayedFroObserver)) continue;
            DelayedFroObserver observer = (DelayedFroObserver)maoRef;
            observer.timeoutAfterServiceAvailable(this.getClass().getName());
        }
    }

    private void notifyProxyObserversOnRemove() {
        Object observer;
        Object maoRef;
        MessageLog.traceEnter(this.getClass(), "notifyProxyObserverOnRemove()");
        if (this.alarmTimerThread != null) {
            this.alarmTimerThread.interrupt();
            this.alarmTimerThread = null;
            MessageLog.trace(7, this.getClass(), "AlarmTimer stopped");
        }
        Enumeration<Object> element = ((Hashtable)this.alarmObservers.clone()).elements();
        while (element.hasMoreElements()) {
            maoRef = element.nextElement();
            if (maoRef == null || !(maoRef instanceof DelayedFroObserver)) continue;
            observer = (DelayedFroObserver)maoRef;
            observer.serviceRemoved(this.getClass().getName());
        }
        element = ((Vector)this.froStateObservers.clone()).elements();
        while (element.hasMoreElements()) {
            maoRef = element.nextElement();
            if (maoRef == null || !(maoRef instanceof FroStateObserver)) continue;
            observer = (FroStateObserver)maoRef;
            observer.serviceRemoved(this.serviceName);
        }
    }

    private static int getIntValue(UnlinkedSignal rspSig, String key) {
        Object obj = BoamProxyUtils.getFieldValue(key, rspSig);
        return Integer.parseInt(obj.toString());
    }

    public UnlinkedSignal sendAndRec(UnlinkedSignal reqSig) throws FroRequestFailedException, FroNotAccessibleException {
        String reqSigName = reqSig.getClass().getName();
        String RSP_SUFIX = "RspS";
        String REQ_SUFIX = "ReqS";
        this.verifyProxyAvaliable();
        MessageLog.traceParam(this.getClass(), Logger.asTrace(reqSig));
        int i = reqSigName.indexOf("ReqS");
        String rspSigName = reqSigName.substring(0, i) + "RspS";
        Class rspSigClass = FroProxy.getSignalClass(rspSigName);
        UnlinkedSignal rspSig = (UnlinkedSignal)SignalHelper.sendAndReceive((OseProcess)this.processId, (Signal)reqSig, (Class)rspSigClass);
        BoamProxyUtils.verifyRoLayerResponse((InSignal)rspSig, this.getClass(), this.getServiceName());
        MessageLog.traceParam(this.getClass(), Logger.asTrace(rspSig));
        this.ensureResponse(rspSigName, FroProxy.getIntValue(rspSig, "result"), FroProxy.getIntValue(rspSig, "errorCode"));
        return rspSig;
    }

    public abstract void ensureResponse(String var1, int var2, int var3) throws FroRequestFailedException, FroNotAccessibleException;

    private final class AlarmTimer
    extends Thread {
        private final FroProxy proxyRef;
        private final int millisec;

        private AlarmTimer(FroProxy r, int m) {
            MessageLog.traceEnter(this.getClass(), "AlarmTimer initiated");
            this.proxyRef = r;
            this.millisec = m;
        }

        public void run() {
            try {
                MessageLog.trace(7, this.getClass(), "AlarmTimer started");
                AlarmTimer.sleep(this.millisec);
                if (!this.isInterrupted()) {
                    this.proxyRef.notifyAlarmSubscribersOnTimeout();
                }
                if (FroProxy.this.alarmTimerThread == this) {
                    FroProxy.this.alarmTimerThread = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class TxHandlerCommonFroNotifyHandler
    implements Resource {
        private int tranId;
        private Vector actionList = new Vector();
        FroProxy commonFroNotifyHandlerRef;

        private TxHandlerCommonFroNotifyHandler(FroProxy aCommonFroNotifyHandlerRef, OrderedAction aOrderedAction, Coordinator c) {
            this.commonFroNotifyHandlerRef = aCommonFroNotifyHandlerRef;
            this.tranId = c.getTransactionID();
            this.actionList.addElement(aOrderedAction);
            try {
                c.registerResource((Resource)this);
            }
            catch (InactiveTransactionException e) {
                this.rollback();
            }
        }

        public void addAction(OrderedAction aOrderedAction, int aTranId) {
            if (this.tranId != aTranId) {
                MessageLog.traceError(class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy == null ? (class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy = FroProxy.class$("se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy")) : class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy, "Method addAction error.", null);
            }
            OrderedAction newListModification = aOrderedAction;
            this.actionList.addElement(newListModification);
        }

        public int getTranId() {
            return this.tranId;
        }

        public void commit() {
            for (int i = 0; i < this.actionList.size(); ++i) {
                OrderedAction registerAction = (OrderedAction)this.actionList.elementAt(i);
                if (registerAction.action == 1 || registerAction.action == 3 || registerAction.action == 5 || registerAction.action == 7) continue;
                if (registerAction.action == 0) {
                    this.commonFroNotifyHandlerRef.deregisterForNotifications((AlarmObserver)registerAction.maoRef, registerAction.froId);
                    continue;
                }
                if (registerAction.action == 2) {
                    this.commonFroNotifyHandlerRef.deRegisterForEventInd(registerAction.froId);
                    continue;
                }
                if (registerAction.action == 4) {
                    this.commonFroNotifyHandlerRef.deregisterForPlugAndPlay(registerAction.froId);
                    continue;
                }
                if (registerAction.action == 6) {
                    this.commonFroNotifyHandlerRef.deRegisterForState(registerAction.maoRef);
                    continue;
                }
                MessageLog.traceError(class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy == null ? FroProxy.class$("se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy") : class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy, "rollback - trouble report this", null);
            }
            this.commonFroNotifyHandlerRef.removeTxHandler(this);
        }

        public void rollback() {
            for (int i = 0; i < this.actionList.size(); ++i) {
                OrderedAction registerAction = (OrderedAction)this.actionList.elementAt(i);
                if (registerAction.action == 1) {
                    this.commonFroNotifyHandlerRef.deregisterForNotifications((AlarmObserver)registerAction.maoRef, registerAction.froId);
                    continue;
                }
                if (registerAction.action == 3) {
                    this.commonFroNotifyHandlerRef.deRegisterForEventInd(registerAction.froId);
                    continue;
                }
                if (registerAction.action == 5) {
                    this.commonFroNotifyHandlerRef.deregisterForPlugAndPlay(registerAction.froId);
                    continue;
                }
                if (registerAction.action == 7) {
                    this.commonFroNotifyHandlerRef.deRegisterForState(registerAction.maoRef);
                    continue;
                }
                if (registerAction.action == 0 || registerAction.action == 2 || registerAction.action == 4 || registerAction.action == 6) continue;
                MessageLog.traceError(class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy == null ? FroProxy.class$("se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy") : class$se$ericsson$wcdma$rbs$boam$fpx$proxies$FroProxy, "rollback - trouble report this", null);
            }
            this.commonFroNotifyHandlerRef.removeTxHandler(this);
        }

        public boolean prepare() {
            return true;
        }
    }

    public static class OrderedAction {
        public final long froId;
        public final Observer maoRef;
        public final int action;

        private OrderedAction(long froId, Observer maoRef, int action) {
            this.froId = froId;
            this.maoRef = maoRef;
            this.action = action;
        }
    }
}

