/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.alarm;

import enea.ose.system.UnlinkedSignal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.wcdma.rbs.boam.common.AlarmObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.FaultCeasedIndImpl;
import se.ericsson.wcdma.rbs.boam.fpx.common.FaultIndImpl;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDevicePrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDevicePrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarmsException;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AcDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AccuMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfuMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ClDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CluMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsuMo;

public abstract class FaultIndExcep {
    private static final Class SELF = FaultIndExcep.class;
    private static final String PREFIX = "getDispatcher_";

    public static AlarmObserver getDispatcher(ManagedObject mo, UnlinkedSignal alarmInd) throws MoAlarmsException {
        String methodName = PREFIX + mo.getType();
        try {
            Method m = FaultIndExcep.class.getMethod(methodName, ManagedObject.class, UnlinkedSignal.class);
            return (AlarmObserver)m.invoke((Object)FaultIndExcep.class, mo, alarmInd);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof MoAlarmsException) {
                throw (MoAlarmsException)e.getTargetException();
            }
            MessageLog.trace(5, FaultIndExcep.class, "No dispatcher  for mo:" + mo.getFullDistinguishedName() + ", target exception was: " + e.getTargetException());
            return null;
        }
        catch (Exception e) {
            MessageLog.trace(5, FaultIndExcep.class, "No dispatcher  for mo:" + mo.getFullDistinguishedName() + ", exception was: " + e);
            return null;
        }
    }

    public static AlarmObserver getDispatcher_PsDevice(ManagedObject mo, UnlinkedSignal alarmInd) throws Exception {
        if (mo == null) {
            throw new Exception();
        }
        int specificProblem = alarmInd instanceof EqcDevicePrimFaultIndS ? ((EqcDevicePrimFaultIndS)alarmInd).getSpecificProblem() : (alarmInd instanceof EqcDevicePrimFaultCeaseIndS ? ((EqcDevicePrimFaultCeaseIndS)alarmInd).getSpecificProblem() : Integer.MIN_VALUE);
        if (specificProblem == 49992 || specificProblem == 49993) {
            MoIterator iter;
            if (specificProblem == 49992) {
                if (alarmInd instanceof EqcDevicePrimFaultIndS) {
                    ((FaultIndImpl)alarmInd).setSpecificProblem(49175);
                } else {
                    ((FaultCeasedIndImpl)alarmInd).setSpecificProblem(49175);
                }
            }
            if ((iter = BoamHelper.findMOs("PowerSupplySystem")).hasMoreElements()) {
                return ((PowerSupplySystemMo)iter.nextMo()).getMoAlarms();
            }
            return ((PsDeviceMo)mo).getMoAlarms();
        }
        String grandGrandParentType = mo.getParent().getParent().getType();
        if (grandGrandParentType != "PcuDeviceGroup" && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo.getParent().getParent(), "PCU")) {
            MessageLog.trace(5, SELF, mo + "'s grandparent is not PCUdeviceGroup so it is RBS4 config; no need for dispatcher");
            return null;
        }
        ManagedObject[] reservers = ((PsDeviceMo)mo).getReservedBy(null);
        for (int i = 0; i < reservers.length; ++i) {
            ManagedObject tmpMo = reservers[i];
            if (!tmpMo.getType().equals("Psu")) continue;
            return ((PsuMo)tmpMo).getMoAlarms();
        }
        MessageLog.traceError(FaultIndExcep.class, "Couldn't find dispatcher for mo:" + mo);
        throw new MoAlarmsException("Couldn't find dispatcher for mo:" + mo);
    }

    public static AlarmObserver getDispatcher_BfDevice(ManagedObject mo, UnlinkedSignal alarmInd) throws Exception {
        String grandGrandParentType = mo.getParent().getParent().getType();
        if (grandGrandParentType != "PcuDeviceGroup" && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo.getParent().getParent(), "PCU")) {
            MessageLog.trace(5, FaultIndExcep.class, mo.getFullDistinguishedName() + "'s grandparent is not PCUdeviceGroup so it is RBS4 config. no need dispatcher");
            return null;
        }
        ManagedObject[] reservers = ((BfDeviceMo)mo).getReservedBy(null);
        for (int i = 0; i < reservers.length; ++i) {
            ManagedObject tmpMo = reservers[i];
            if (!tmpMo.getType().equals("Bfu")) continue;
            return ((BfuMo)tmpMo).getMoAlarms();
        }
        MessageLog.traceError(FaultIndExcep.class, "Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
        throw new MoAlarmsException("Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
    }

    public static AlarmObserver getDispatcher_ClDevice(ManagedObject mo, UnlinkedSignal alarmInd) throws Exception {
        String grandGrandParentType = mo.getParent().getParent().getType();
        if (grandGrandParentType != "PcuDeviceGroup" && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo.getParent().getParent(), "PCU")) {
            MessageLog.trace(5, FaultIndExcep.class, mo.getFullDistinguishedName() + "'s grandparent is not PCUdeviceGroup so it is RBS4 config. no need dispatcher");
            return null;
        }
        ManagedObject[] reservers = ((ClDeviceMo)mo).getReservedBy(null);
        for (int i = 0; i < reservers.length; ++i) {
            ManagedObject tmpMo = reservers[i];
            if (!tmpMo.getType().equals("Clu")) continue;
            return ((CluMo)tmpMo).getMoAlarms();
        }
        MessageLog.traceError(FaultIndExcep.class, "Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
        throw new MoAlarmsException("Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
    }

    public static AlarmObserver getDispatcher_AcDevice(ManagedObject mo, UnlinkedSignal alarmInd) throws Exception {
        String grandGrandParentType = mo.getParent().getParent().getType();
        if (grandGrandParentType != "PcuDeviceGroup" && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo.getParent().getParent(), "PCU")) {
            MessageLog.trace(5, FaultIndExcep.class, mo.getFullDistinguishedName() + "'s grandparent is not PCUdeviceGroup so it is RBS4 config. no need dispatcher");
            return null;
        }
        ManagedObject[] reservers = ((AcDeviceMo)mo).getReservedBy(null);
        for (int i = 0; i < reservers.length; ++i) {
            ManagedObject tmpMo = reservers[i];
            if (!tmpMo.getType().equals("Accu")) continue;
            return ((AccuMo)tmpMo).getMoAlarms();
        }
        MessageLog.traceError(FaultIndExcep.class, "Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
        throw new MoAlarmsException("Couldn't find dispatcher  for mo:" + mo.getFullDistinguishedName());
    }
}

