/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OrbCreatorFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeDiscovery;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeDiscoveryHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeSecurityIntegration;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.NodeSecurityIntegrationHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.OssNodeDiscoveryException;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.nodediscover.OssNodeDiscoveryResolver;

public class OssNodeDiscoveryResolverImpl
implements OssNodeDiscoveryResolver {
    private static final Class THIS_CLASS = OssNodeDiscoveryResolverImpl.class;
    protected final transient String currentNodeDiscoveryServiceName;
    protected final transient String currentNameServerAddress;
    protected final transient int currentNameServicePort;

    public OssNodeDiscoveryResolverImpl(String nameServerAddress, int nameServicePort, String nodeDiscoveryServiceName) {
        this.currentNameServerAddress = nameServerAddress;
        this.currentNameServicePort = nameServicePort;
        this.currentNodeDiscoveryServiceName = nodeDiscoveryServiceName;
    }

    public NodeDiscovery resolveNodeDiscovery() throws OssNodeDiscoveryException {
        MessageLog.traceEnter(THIS_CLASS, "resolveNodeDiscovery()");
        String nameServiceLocation = this.getNameServiceLocation();
        NodeDiscovery nodeDiscovery = null;
        try {
            Object nsObj = this.getNodeServiceObject(nameServiceLocation);
            nodeDiscovery = NodeDiscoveryHelper.narrow(nsObj);
        }
        catch (OssNodeDiscoveryException onde) {
            throw onde;
        }
        catch (Exception e) {
            String errorMsg = "Could not resolve interface " + this.currentNodeDiscoveryServiceName + ", from name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort + ": " + nameServiceLocation;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        MessageLog.traceReturn(THIS_CLASS, "resolveNodeDiscovery()");
        return nodeDiscovery;
    }

    public void verifyOssConnectivity() throws NotFound, CannotProceed, InvalidName, OssNodeDiscoveryException {
        this.getNodeServiceObject(this.getNameServiceLocation());
    }

    public NodeSecurityIntegration resolveNodeSecurityIntegration() throws OssNodeDiscoveryException {
        MessageLog.traceEnter(THIS_CLASS, "resolveNodeSecurityIntegration()");
        String nameServiceLocation = this.getNameServiceLocation();
        NodeSecurityIntegration nodeSecurityIntegration = null;
        try {
            Object nsObj = this.getNodeServiceObject(nameServiceLocation);
            nodeSecurityIntegration = NodeSecurityIntegrationHelper.narrow(nsObj);
        }
        catch (OssNodeDiscoveryException onde) {
            throw onde;
        }
        catch (Exception e) {
            String errorMsg = "Could not resolve interface " + this.currentNodeDiscoveryServiceName + ", from name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort + ": " + nameServiceLocation;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        MessageLog.traceReturn(THIS_CLASS, "resolveNodeSecurityIntegration()");
        return nodeSecurityIntegration;
    }

    private String getNameServiceLocation() throws OssNodeDiscoveryException {
        MessageLog.traceEnter(THIS_CLASS, "getNameServiceLocation()");
        String currentNameServiceLocation = "";
        try {
            InetAddress inet = InetAddress.getByName(this.currentNameServerAddress);
            currentNameServiceLocation = inet instanceof Inet6Address ? "corbaloc:iiop:1.2@[" + this.currentNameServerAddress + "]:" + this.currentNameServicePort + "/NameService" : "corbaloc::" + this.currentNameServerAddress + ":" + this.currentNameServicePort + "/NameService";
        }
        catch (UnknownHostException e) {
            String errorMsg = "Failure! Could not resolve Name Server Address:" + this.currentNameServerAddress;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        MessageLog.traceReturn(THIS_CLASS, "getNameServiceLocation()");
        return currentNameServiceLocation;
    }

    public String getNSLocation() throws OssNodeDiscoveryException {
        return this.getNameServiceLocation();
    }

    private ORB getOrb() throws OssNodeDiscoveryException {
        boolean orbUp = false;
        ORB cppOrb = null;
        while (!orbUp) {
            cppOrb = OrbCreatorFactory.getInstance().getOrbCreator().getOrb();
            if (cppOrb == null) {
                String errorMsg = "Could not get reference to CppOrb";
                MessageLog.traceError(THIS_CLASS, "getOrb(): Could not get reference to CppOrb");
                throw new OssNodeDiscoveryException("Could not get reference to CppOrb");
            }
            try {
                cppOrb.work_pending();
                orbUp = true;
            }
            catch (BAD_INV_ORDER orbDownException) {
                MessageLog.trace(1, THIS_CLASS, "The CPP Orb is currently down, waiting for restart.");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interrupted) {
                    MessageLog.trace(1, THIS_CLASS, "Interrupted while waiting for CPP Orb to come alive.");
                }
            }
        }
        return cppOrb;
    }

    private Object getNodeServiceObject(String nameServiceLocation) throws OssNodeDiscoveryException, NotFound, CannotProceed, InvalidName {
        NamingContextExt rootNcExt;
        MessageLog.traceEnter(THIS_CLASS, "getNodeServiceObject()");
        ORB cppOrb = this.getOrb();
        Object nsRootContext = cppOrb.string_to_object(nameServiceLocation);
        NamingContextExt rootNc = rootNcExt = NamingContextExtHelper.narrow((Object)nsRootContext);
        MessageLog.traceReturn(THIS_CLASS, "getNodeServiceObject()");
        return rootNc.resolve(rootNcExt.to_name(this.currentNodeDiscoveryServiceName));
    }

    public String getCurrentNameServerAddress() {
        return this.currentNameServerAddress;
    }

    public int getCurrentNameServicePort() {
        return this.currentNameServicePort;
    }
}

