/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RbsConfigurationFailedException;

public class ConfigurationVersionHelper {
    public static final String CELLO_CV_OK = "CELLO_CV_OK";
    private ConfigurationVersionMo cvMo = (ConfigurationVersionMo)BoamHelper.getFirstMatchingMo("ConfigurationVersion");

    public ConfigurationVersionHelper() throws RbsConfigurationFailedException {
        if (this.cvMo == null) {
            throw new RbsConfigurationFailedException("Can't find ConfigurationVersionMo.");
        }
    }

    public boolean isCvFirstInRollbackList(String cvName) throws MoAccessException {
        String firstCv;
        AiMessageLog.traceEnter(this.getClass(), "isCvFirstInRollbackList() ");
        String[] rollbackList = this.cvMo.getRollbackList(null);
        return rollbackList != null && rollbackList.length > 0 && (firstCv = rollbackList[0]) != null && firstCv.equals(cvName);
    }

    public boolean isCvInRollbackList(String cvName) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "isCvInRollbackList() ");
        String[] rollbackList = this.cvMo.getRollbackList(null);
        if (rollbackList != null) {
            for (int i = 0; i < rollbackList.length; ++i) {
                String cv = rollbackList[i];
                if (cv == null || !cv.equals(cvName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setCvFirstInRollbackList(String cvName) throws MoAccessException {
        block4: {
            AiMessageLog.traceEnter(this.getClass(), "setCvFirstInRollbackList(): " + cvName);
            if (this.isCvFirstInRollbackList(cvName)) break block4;
            if (this.isCvInRollbackList(cvName)) {
                this.removeCvFromRollbackList(cvName);
            }
            if (cvName != null && !cvName.equals("")) {
                this.cvMo.actionSetFirstRollbackList(cvName, null);
                break block4;
            }
            throw new RbsConfigurationFailedException("Could not set CV first in rollback list, since the provided CV is null or empty string");
        }
    }

    public void removeCvFromRollbackList(String cvName) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "removeCvFromRollbackList(): " + cvName);
        if (cvName != null && !cvName.equals("")) {
            this.cvMo.actionRemoveFromRollbackList(cvName, null);
        } else {
            AiMessageLog.traceError(this.getClass(), "Can't remove Cv from rollback list if the CV is null or empty string");
        }
    }

    public boolean isCvInStoredConfigurationVersionsAndHasStatusOk(String cvName) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "isCvInStoredConfigurationVersionsAndHasStatusOk(): " + cvName);
        Struct[] storedConfigurationVersions = this.cvMo.getStoredConfigurationVersions(null);
        boolean cvNameIsInList = false;
        if (storedConfigurationVersions != null) {
            for (int i = 0; i < storedConfigurationVersions.length; ++i) {
                Struct storedConfigurationVersion = storedConfigurationVersions[i];
                String name = (String)storedConfigurationVersion.getValue("name");
                String status = (String)storedConfigurationVersion.getValue("status");
                if (!name.equals(cvName)) continue;
                cvNameIsInList = true;
                AiMessageLog.trace(2, this.getClass(), "CV :" + cvName + " is in the stored configuration");
                boolean statusOk = this.isCvStatusOk(status);
                if (!statusOk) continue;
                return true;
            }
        }
        if (!cvNameIsInList) {
            AiMessageLog.trace(2, this.getClass(), "CV :" + cvName + " is NOT in the stored configuration");
        }
        return false;
    }

    private boolean isCvStatusOk(String status) {
        AiMessageLog.traceEnter(this.getClass(), "isCvStatusOk");
        boolean statusOk = status.equals(CELLO_CV_OK);
        if (statusOk) {
            AiMessageLog.trace(2, this.getClass(), "CV status is OK");
        } else {
            AiMessageLog.trace(2, this.getClass(), "CV status is NOT OK, status is: " + status);
        }
        return statusOk;
    }

    public void actionSetStartable(String cvName, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "actionSetStartable()");
        this.cvMo.actionSetStartable(cvName, c);
    }
}

