/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.bcm;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;

public abstract class BoamManagedObjectWithAlarms
extends BoamManagedObject {
    private static final String ALARM_STATUS = "alarmStatus";
    protected MoData myData;
    protected MoAlarms myMoAlarms;
    protected IntegerAttribute alarmStatusAttr;

    protected BoamManagedObjectWithAlarms(ManagedObject parent, String moTypeName, String identity, Coordinator context, int maxNoOfChildren) throws MoAccessException {
        super(parent, moTypeName, identity, context, maxNoOfChildren);
    }

    protected BoamManagedObjectWithAlarms(ManagedObject parent, String moTypeName, String identity, Coordinator context) throws MoAccessException {
        super(parent, moTypeName, identity, context);
    }

    protected BoamManagedObjectWithAlarms(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "BoamManagedObjectWithAlarms():recovery constructor");
        MessageLog.trace(1, ((Object)((Object)this)).getClass(), "recovering alarmStatus");
        this.alarmStatusAttr = (IntegerAttribute)recoveredData.getAttribute(ALARM_STATUS);
    }

    public MoAlarms getMoAlarms() {
        return this.myMoAlarms;
    }

    public void setAlarmStatus(int alarmStatusType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "setAlarmStatus(), new value " + alarmStatusType);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if ((alarmStatusType & 0xFFFFFFFE) != 0) {
            MessageLog.trace(2, ((Object)((Object)this)).getClass(), this.getType() + ":setAlarmStatus: alarmStatus must be 1 or 0");
            throw new ValueOutOfRangeException(ALARM_STATUS, this.getType());
        }
        this.alarmStatusAttr.setValue(alarmStatusType);
    }

    public int getAlarmStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "getAlarmStatus()");
        int ast = 0;
        if (this.myMoAlarms != null) {
            ast = this.myMoAlarms.getAlarmStatus() & 0xFFFFFFFE;
        }
        ast = this.alarmStatusAttr.getValue(context) | ast;
        return ast;
    }

    protected static synchronized int checkAndGetAlarmStatus(AttrList attributes, int defaultValue, String thisTypeName, Coordinator context) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, WrongAttributeTypeException {
        int index = attributes.indexOf(ALARM_STATUS);
        int alSt = defaultValue;
        if (index != -1) {
            Object attr = attributes.getValue(index);
            if (attr instanceof Integer) {
                alSt = (Integer)attr;
                attributes.removeElementAt(index);
                if ((alSt & 0xFFFFFFFE) != 0) {
                    throw new ValueOutOfRangeException(ALARM_STATUS, thisTypeName);
                }
            } else {
                throw new WrongAttributeTypeException(ALARM_STATUS, thisTypeName);
            }
        }
        return alSt;
    }

    protected void initAlarmStatus(int newAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "initAlarmStatus()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.alarmStatusAttr = (IntegerAttribute)this.myData.getAttribute(ALARM_STATUS);
        if (this.alarmStatusAttr == null) {
            this.alarmStatusAttr = new IntegerAttribute(ALARM_STATUS, false, newAlarmStatus);
            this.myData.registerPersistentAttr((Attribute)this.alarmStatusAttr);
        }
        this.alarmStatusAttr.setValue(newAlarmStatus);
    }
}

