/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSetFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.dmo.alarm.AlmDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.OutDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.climate.ClDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.AcDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.BfDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PdDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PsDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AiDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RetDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TmaDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TpaDeviceSetMoImpl;

public class AuxDeviceSetMoFactory
implements MoFactory {
    private static final Class SELF = AuxDeviceSetMoFactory.class;
    private static AuxDeviceSetMoFactory tpaInstance;
    private static AuxDeviceSetMoFactory psInstance;
    private static AuxDeviceSetMoFactory bfInstance;
    private static AuxDeviceSetMoFactory acInstance;
    private static AuxDeviceSetMoFactory clInstance;
    private static AuxDeviceSetMoFactory tmaInstance;
    private static AuxDeviceSetMoFactory pdInstance;
    private static AuxDeviceSetMoFactory almInstance;
    private static AuxDeviceSetMoFactory outInstance;
    private static AuxDeviceSetMoFactory retInstance;
    private static AuxDeviceSetMoFactory aiInstance;
    private static final int MAX_DEPTH = 8;
    private int eqcSetType = 0;

    private AuxDeviceSetMoFactory(int setType) {
        MessageLog.traceEnter(SELF, setType + "AuxDeviceSetMoFactory normal constructor");
        this.eqcSetType = setType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized AuxDeviceSetMoFactory instance(int setType) {
        AuxDeviceSetMoFactory instance;
        switch (setType) {
            case 49760: {
                if (tpaInstance == null) {
                    tpaInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = tpaInstance;
                break;
            }
            case 49761: {
                if (psInstance == null) {
                    psInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = psInstance;
                break;
            }
            case 49762: {
                if (bfInstance == null) {
                    bfInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = bfInstance;
                break;
            }
            case 49763: {
                if (acInstance == null) {
                    acInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = acInstance;
                break;
            }
            case 49764: {
                if (clInstance == null) {
                    clInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = clInstance;
                break;
            }
            case 49765: {
                if (pdInstance == null) {
                    pdInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = pdInstance;
                break;
            }
            case 49766: {
                if (tmaInstance == null) {
                    tmaInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = tmaInstance;
                break;
            }
            case 49767: {
                if (almInstance == null) {
                    almInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = almInstance;
                break;
            }
            case 49768: {
                if (outInstance == null) {
                    outInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = outInstance;
                break;
            }
            case 49769: {
                if (retInstance == null) {
                    retInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = retInstance;
                break;
            }
            case 49759: {
                if (aiInstance == null) {
                    aiInstance = new AuxDeviceSetMoFactory(setType);
                }
                instance = aiInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public void createDeviceSetMoTree(ManagedObject parentGroupMo, RbsSetFroInfoT devSetFroInfo, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, SELF, "Creating DeviceSetMo with identity = " + identity);
        MessageLog.trace(1, SELF, "Creating DeviceSetMo with setFroId = " + devSetFroInfo.devSetFroId);
        ManagedObject createdMo = this.createTheMo(parentGroupMo, (int)devSetFroInfo.devSetFroId, identity, userLabel, context);
        MessageLog.trace(1, SELF, "Device Set MO Created");
        for (int i = 0; i < devSetFroInfo.numberOfDevices; ++i) {
            String deviceIdentity = "" + (i + 1);
            AuxDeviceMoFactory auxDeviceFactory = AuxDeviceMoFactory.instance(this.getDeviceType());
            auxDeviceFactory.createDeviceMo(createdMo, devSetFroInfo.deviceFroInfo[i], deviceIdentity, userLabel, context);
        }
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createMo()");
        String msg = "Device Set MOs cannot be created over Mub";
        throw new MoCanNotBeCreatedException(msg);
    }

    public ManagedObject createTheMo(ManagedObject parent, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createTheMo()");
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcSetType) {
            case 49760: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_TPA_SET = " + 49760);
                mo = new TpaDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "TpaDeviceSet MO Created");
                break;
            }
            case 49761: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_PS_SET = " + 49761);
                mo = new PsDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "PsDeviceSet MO Created");
                break;
            }
            case 49762: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_BF_SET = " + 49762);
                mo = new BfDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "BfDeviceSet MO Created");
                break;
            }
            case 49763: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_AC_SET = " + 49763);
                mo = new AcDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "AcDeviceSet MO Created");
                break;
            }
            case 49764: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_CL_SET = " + 49764);
                mo = new ClDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "ClDeviceSet MO Created");
                break;
            }
            case 49765: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_PD_SET = " + 49765);
                mo = new PdDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "PdDeviceSet MO Created");
                break;
            }
            case 49766: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_TMA_SET = " + 49766);
                mo = new TmaDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "TmaDeviceSet MO Created");
                break;
            }
            case 49767: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_ALM_SET = " + 49767);
                mo = new AlmDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "AlmDeviceSet MO Created");
                break;
            }
            case 49768: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_OUT_SET = " + 49768);
                MessageLog.trace(1, SELF, "OutDevice Set MO  To be Created");
                mo = new OutDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "OutDeviceSet MO Created");
                break;
            }
            case 49769: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_RET_SET = " + 49769);
                mo = new RetDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "RetDeviceSet MO Created");
                break;
            }
            case 49759: {
                MessageLog.trace(1, SELF, "Device Set MO  To be Created eqcSetType = " + this.eqcSetType + ", RbsTypes.RBS_AI_SET = " + 49759);
                mo = new AiDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                MessageLog.trace(1, SELF, "AiDeviceSet MO Created");
                break;
            }
            default: {
                MessageLog.traceError(SELF, "createTheMo().  Software Error in BOAM, illegal set type eqcSetType: " + this.eqcSetType);
            }
        }
        MessageLog.trace(1, SELF, "createTheMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(SELF, "recoverMo");
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcSetType) {
            case 49760: {
                mo = new TpaDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49761: {
                mo = new PsDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49762: {
                mo = new BfDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49763: {
                mo = new AcDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49764: {
                mo = new ClDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49765: {
                mo = new PdDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49766: {
                mo = new TmaDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49767: {
                mo = new AlmDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49768: {
                mo = new OutDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49769: {
                mo = new RetDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49759: {
                mo = new AiDeviceSetMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(SELF, "recoverMo().  Software Error in BOAM, illegal set type: eqcSetType = " + this.eqcSetType);
            }
        }
        return mo;
    }

    private int getDeviceType() {
        int deviceType = 0;
        switch (this.eqcSetType) {
            case 49760: {
                deviceType = 8;
                break;
            }
            case 49761: {
                deviceType = 9;
                break;
            }
            case 49762: {
                deviceType = 10;
                break;
            }
            case 49763: {
                deviceType = 11;
                break;
            }
            case 49764: {
                deviceType = 12;
                break;
            }
            case 49765: {
                deviceType = 13;
                break;
            }
            case 49766: {
                deviceType = 14;
                break;
            }
            case 49767: {
                deviceType = 15;
                break;
            }
            case 49768: {
                deviceType = 16;
                break;
            }
            case 49769: {
                deviceType = 17;
                break;
            }
            case 49759: {
                deviceType = 7;
                break;
            }
            default: {
                MessageLog.traceError(SELF, "getDeviceType(). Software Error in BOAM, illegal device type: deviceType=" + deviceType);
            }
        }
        return deviceType;
    }

    public String getMoTypeName() {
        String name = "";
        switch (this.eqcSetType) {
            case 49760: {
                name = "TpaDeviceSet";
                break;
            }
            case 49761: {
                name = "PsDeviceSet";
                break;
            }
            case 49762: {
                name = "BfDeviceSet";
                break;
            }
            case 49763: {
                name = "AcDeviceSet";
                break;
            }
            case 49764: {
                name = "ClDeviceSet";
                break;
            }
            case 49765: {
                name = "PdDeviceSet";
                break;
            }
            case 49766: {
                name = "TmaDeviceSet";
                break;
            }
            case 49767: {
                name = "AlmDeviceSet";
                break;
            }
            case 49768: {
                name = "OutDeviceSet";
                break;
            }
            case 49769: {
                name = "RetDeviceSet";
                break;
            }
            case 49759: {
                name = "AiDeviceSet";
                break;
            }
            default: {
                MessageLog.traceError(SELF, "getMoTypeName(). Software Error in BOAM, illegal set type. eqcSetType=" + this.eqcSetType);
            }
        }
        return name;
    }

    public AuxDeviceGroupMoImpl findAuxDeviceGroupMo(AuxDeviceGroupMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 8, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (AuxDeviceGroupMoImpl)moIter.nextMo();
        }
        return null;
    }

    public AuxDeviceSetMoImpl findDeviceSetMo(AuxDeviceSetMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 8, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (AuxDeviceSetMoImpl)moIter.nextMo();
        }
        return null;
    }
}

