/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu;

import java.util.ArrayList;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportAccess;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertyListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypePropertySupportAccess;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.HwUpgradeFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XpProgramMo;
import se.ericsson.wcdma.rbs.boam.mao.pnp.Job;
import se.ericsson.wcdma.rbs.boam.mao.pnp.JobScheduler;
import se.ericsson.wcdma.rbs.boam.mao.pnp.JobSchedulerListener;

public class AuxPiuHwUpgradeHandler
implements PiuTypePropertyListener {
    public static final int FIVE_SEC = 5000;
    private static int pnpPollingRate = 20000;
    static final int NO_ALARM = 0;
    private final AuxPlugInUnitMo auxPiu;
    private String hwProductNumber = null;
    private String hwProductRevision = null;
    private String hwProductName = null;
    private String preInstalledSwProdNum = null;
    private String preInstalledSwProdRev = null;
    private LoadModuleMo newLM;
    private PiuTypeMo piuType;
    private PiuTypeMo genericPiuType;
    private XpProgramMo currentPgm;
    private ManagedObject oldPgm;

    public AuxPiuHwUpgradeHandler(ManagedObject mo) {
        this.auxPiu = (AuxPlugInUnitMo)mo;
        this.reset();
    }

    private void reset() {
        this.newLM = null;
        this.piuType = null;
        this.genericPiuType = null;
        this.currentPgm = null;
        this.oldPgm = null;
        PiuTypePropertySupportAccess.getInterface().removeAsListener((PiuTypePropertyListener)this);
    }

    public void hwMismatchCeaseReceived() {
        PiuTypePropertySupportAccess.getInterface().removeAsListener((PiuTypePropertyListener)this);
    }

    public void loadModuleFilesInstallState(PiuTypeMo aPiuTypeMo, boolean anIsInstalled) {
        MessageLog.traceEnter(this.getClass(), "loadModuleFilesInstallState()<---");
        if (anIsInstalled && this.piuType != null && this.piuType.getLocalDistinguishedName().equalsIgnoreCase(aPiuTypeMo.getLocalDistinguishedName())) {
            JobScheduler.instance().addJob(new Job(new PiuTypeManuallyLoadedJob()));
        }
    }

    private void plugAndPlayPreparation() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayPreparation()<---");
        String msg = "Plug&Play: Auto Configuration Not Allowed Yet";
        ManagedObject swa = this.auxPiu.getSwAllocation(null);
        if (swa == null) {
            MessageLog.info(this.getClass(), "No SwAllocation found. An event will be sent to the operator");
            this.auxPiu.generateEvent2(null);
            throw new HwUpgradeFailedException("No SwAllocation found!! auxPiu:" + this.auxPiu.getLocalDistinguishedName());
        }
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)AuxPlugInUnitUpgradeHelper.findManagedElementDataMO();
        boolean autoConfigAllowed = managedElementData.getAutoConfigurationAllowed(null);
        if (!autoConfigAllowed) {
            MessageLog.trace(4, this.getClass(), "Plug&Play: Auto Configuration not allowed, generating Alarm!!");
            this.auxPiu.generateInternalAlarm(this.piuType);
            while (!managedElementData.getAutoConfigurationAllowed(null)) {
                MessageLog.trace(4, this.getClass(), "Plug&Play: Auto Configuration Not Allowed Yet");
                AuxPlugInUnitUpgradeHelper.wait(pnpPollingRate);
            }
            MessageLog.info(this.getClass(), "Plug&Play: Auto Configuration is Allowed Now, clearing the alarm and continuing the configuration.");
            this.auxPiu.ceaseInternalAlarm(null);
        }
    }

    private void swPreparation() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "swPreparation()<---");
        boolean isPiuTypesIdentical = false;
        PiuTypeMo existingPiuType = (PiuTypeMo)this.auxPiu.getPiuType(null);
        this.piuType = (PiuTypeMo)AuxPlugInUnitUpgradeHelper.fetchNewPiuType(this.auxPiu, this.hwProductNumber, this.hwProductRevision, null);
        if (existingPiuType == null) {
            MessageLog.trace(4, this.getClass(), "existing piuType not found");
        } else {
            MessageLog.trace(4, this.getClass(), "existing piuType: " + existingPiuType.getFullDistinguishedName());
        }
        if (this.piuType == null) {
            MessageLog.trace(4, this.getClass(), "piuType from UCF not found");
        } else {
            MessageLog.trace(4, this.getClass(), "selected piuType: " + this.piuType.getFullDistinguishedName());
        }
        if (existingPiuType != null && this.piuType != null && existingPiuType.getFullDistinguishedName().equals(this.piuType.getFullDistinguishedName())) {
            MessageLog.trace(4, this.getClass(), "selected PiuType is same as existing piuType: " + existingPiuType.getFullDistinguishedName());
            isPiuTypesIdentical = true;
        }
        if ((this.piuType == null || isPiuTypesIdentical) && this.preInstalledSwProdNum.length() > 0 && this.preInstalledSwProdRev.length() > 0) {
            this.genericPiuType = (PiuTypeMo)AuxPlugInUnitUpgradeHelper.fetchNewGenericPiuType(this.auxPiu, this.hwProductName, null);
            if (this.genericPiuType != null && !AuxPlugInUnitUpgradeHelper.isGenericPiuTypeInRepertoire(this.genericPiuType, this.auxPiu, null)) {
                this.auxPiu.generateInternalAlarm(this.genericPiuType);
                throw new HwUpgradeFailedException("No generic piutype in repertoire for\npreInstalledSwProdNum: " + this.preInstalledSwProdNum + "\n" + "preInstalledSwProdRev: " + this.preInstalledSwProdRev + ".");
            }
        }
        if (isPiuTypesIdentical && this.preInstalledSwProdNum.length() > 0 && this.preInstalledSwProdRev.length() > 0 && this.genericPiuType == null) {
            this.auxPiu.generateInternalAlarm(this.piuType);
            throw new HwUpgradeFailedException("Existing and selected PiuType identical and information about preInstalled SW exists in HwMismatchInd, but no generic PiuType found!! HW upgrade closed without creating new Xp Program!!" + this.hwProductNumber + ", " + this.hwProductRevision + ", " + this.preInstalledSwProdNum + ", " + this.preInstalledSwProdRev + ", " + this.hwProductName);
        }
        if (this.piuType == null && this.genericPiuType == null) {
            this.auxPiu.generateInternalAlarm(this.piuType);
            throw new HwUpgradeFailedException("No piuType found!! HW upgrade closed without creating new Xp Program!!" + this.hwProductNumber + ", " + this.hwProductRevision);
        }
        if (this.genericPiuType != null) {
            this.newLM = null;
        } else {
            ManagedObject repertoire = AuxPlugInUnitUpgradeHelper.getNewRepertoire(this.auxPiu, (ManagedObject)this.piuType, null);
            if (repertoire == null) {
                this.auxPiu.generateInternalAlarm(this.piuType);
                throw new HwUpgradeFailedException("No repertoire found!! HW upgrade closed without creating new Xp Program!!PiuType:" + this.piuType.getFullDistinguishedName());
            }
            this.newLM = (LoadModuleMo)AuxPlugInUnitUpgradeHelper.getNewLoadModule((ManagedObject)this.piuType, repertoire, null);
            if (this.newLM == null) {
                this.auxPiu.generateInternalAlarm(this.piuType);
                throw new HwUpgradeFailedException("No new LM found!! HW upgrade closed without creating new Xp Program!!PiuType:" + this.piuType.getFullDistinguishedName());
            }
            SwInstallationListener waiter = new SwInstallationListener();
            if (this.piuTypeInstallNeeded()) {
                PiuTypeInstallSupportAccess.getInterface().installPiuType(this.piuType, (PiuTypeInstallListener)waiter);
                waiter.wait4PiuTypeInstallDone();
            }
            if (this.piuTypeInstallNeeded()) {
                PiuTypePropertySupportAccess.getInterface().addAsListener((PiuTypePropertyListener)this);
                this.auxPiu.generateInternalAlarm(this.piuType);
                throw new HwUpgradeFailedException(this.auxPiu.getFullDistinguishedName() + " couldn't be upgraded. installPiuType failed ActionResult.information :" + waiter.getFaultInformation());
            }
            if (this.auxPiu.getInternalAlarmStatus() != 0) {
                this.auxPiu.ceaseInternalAlarm(null);
            }
        }
    }

    private void reconfigure(int noOfRetry) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reconfigure()<---");
        if (this.hwProductNumber.length() == 0 || this.hwProductRevision.length() == 0) {
            PiuTypeMo piuType = (PiuTypeMo)this.auxPiu.getPiuType(null);
            this.auxPiu.generateInternalAlarm(piuType);
            throw new HwUpgradeFailedException("Invalid signal parameters from EC, hwProductNumber and/or hwProductRevision empty");
        }
        this.reset();
        this.plugAndPlayPreparation();
        this.swPreparation();
        this.findXpProgramConfiguration();
        Control txControl = null;
        while (true) {
            try {
                txControl = TransactionServiceImpl.instance().getTransactionFactory().create(10000);
                this.deleteOldXpProgram(txControl.getCoordinator());
                this.reconfigNewPgm(txControl.getCoordinator());
                txControl.getTerminator().commit();
                MessageLog.trace(4, this.getClass(), "reconfigure() finished successfully.");
                break;
            }
            catch (TransactionRolledBackException e) {
                if (--noOfRetry <= 0) {
                    throw new HwUpgradeFailedException("Delete old XP program or delete of new failed :" + e.toString());
                }
                MessageLog.trace(4, this.getClass(), "Failed to create/delete XP program, retrying :" + (Object)((Object)e));
            }
            catch (InactiveTransactionException e) {
                if (--noOfRetry <= 0) {
                    throw new HwUpgradeFailedException("Delete old XP program or delete of new failed :" + e.toString());
                }
                MessageLog.trace(4, this.getClass(), "Failed to create/delete XP program, retrying :" + (Object)((Object)e));
            }
            catch (TransactionRequiredException e) {
                if (--noOfRetry <= 0) {
                    throw new HwUpgradeFailedException("Delete old XP program or delete of new failed :" + e.toString());
                }
                MessageLog.trace(4, this.getClass(), "Failed to create/delete XP program, retrying :" + (Object)((Object)e));
            }
            catch (MoAccessException e) {
                AuxPlugInUnitUpgradeHelper.destroyTX(txControl);
                throw e;
            }
            AuxPlugInUnitUpgradeHelper.wait(pnpPollingRate);
        }
    }

    public void reconfigureProgAfterHwUpgradeRetry(String hwProductNumber, String hwProductRevision, String hwProductName, String preInstalledSwProdNum, String preInstalledSwProdRev, int noOfRetry) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reconfigureProgAfterHwUpgradeRetry() Pid:" + hwProductNumber + " , " + hwProductRevision + " , " + hwProductName + " , " + preInstalledSwProdNum + " , " + preInstalledSwProdRev + " , " + " <---");
        this.hwProductRevision = hwProductRevision;
        this.hwProductNumber = hwProductNumber;
        this.hwProductName = hwProductName;
        this.preInstalledSwProdNum = preInstalledSwProdNum;
        this.preInstalledSwProdRev = preInstalledSwProdRev;
        this.reconfigure(noOfRetry);
    }

    private boolean piuTypeInstallNeeded() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "piuTypeInstallNeeded()<---");
        boolean result2 = true;
        if (this.piuType.getLmFilesInstallState(null) == 2) {
            MessageLog.trace(4, this.getClass(), "All LMs are installed. PiuType:" + this.piuType.getFullDistinguishedName());
            result2 = false;
        } else if (this.piuType.getLmFilesInstallState(null) == 1 && this.newLM.getFileState(null) == 1) {
            MessageLog.trace(4, this.getClass(), "The new LM is installed. LM:" + this.newLM.getFullDistinguishedName());
            result2 = false;
        } else {
            MessageLog.trace(4, this.getClass(), "The new LM is NOT installed. LM:" + this.newLM.getFullDistinguishedName() + ", BOAM going to order installation!!");
        }
        return result2;
    }

    private void findXpProgramConfiguration() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findXpProgramConfiguration() for auxPiu:" + this.auxPiu.getLocalDistinguishedName());
        ArrayList xpPgmList = AuxPlugInUnitUpgradeHelper.getAllXpProgram(this.auxPiu);
        for (int i = 0; i < xpPgmList.size(); ++i) {
            XpProgramMo xpPr = (XpProgramMo)xpPgmList.get(i);
            int state = xpPr.getStartState(null);
            if (state == 1) {
                this.currentPgm = xpPr;
                continue;
            }
            this.oldPgm = xpPr;
        }
    }

    private void deleteOldXpProgram(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteOldXpProgram()<---");
        if (this.oldPgm == null) {
            MessageLog.trace(4, this.getClass(), "There is no old XpProgram, nothing to do!");
            return;
        }
        MessageLog.trace(4, this.getClass(), "deleteOldXpProgram()" + this.oldPgm);
        this.oldPgm.delete(context);
    }

    private void reconfigNewPgm(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reconfigNewPgm()<---");
        MessageLog.trace(4, this.getClass(), "reconfigNewPgm()" + this.currentPgm);
        if (this.currentPgm != null) {
            this.currentPgm.setStartState(0, context);
        }
        this.auxPiu.setPiuTypeForSwUpgrade((ManagedObject)(this.piuType != null ? this.piuType : this.genericPiuType), context);
        this.updateHwProductInformation(context);
        if (this.genericPiuType != null) {
            AuxPlugInUnitUpgradeHelper.createHwNewXpProgram(this.hwProductNumber, this.hwProductRevision, this.preInstalledSwProdNum, this.preInstalledSwProdRev, this.auxPiu, context);
        } else {
            AuxPlugInUnitUpgradeHelper.createHwNewXpProgram(this.hwProductNumber, this.hwProductRevision, this.auxPiu, (ManagedObject)this.newLM, context);
        }
        if (this.currentPgm != null) {
            this.currentPgm.delete(context);
        }
        try {
            AuxPlugInUnitUpgradeHelper.restartCurrentAuxDeviceGroup(this.auxPiu, context);
        }
        catch (Exception e0) {
            MessageLog.trace(4, this.getClass(), "EC throws an exception : But BOAM must continue as normal situation");
        }
    }

    private void updateHwProductInformation(Coordinator context) throws MoAccessException {
        if (this.piuType != null) {
            Struct newPidData = this.piuType.getProductData(context);
            String newPiuPNum = (String)newPidData.getValue("productNumber");
            String newPiuPRev = (String)newPidData.getValue("productRevision");
            MessageLog.trace(4, this.getClass(), "TR HN24281: Product data from PiuType used for XpProgram creation: " + newPiuPNum + " " + newPiuPRev + " instead of " + this.hwProductNumber + " " + this.hwProductRevision);
            this.hwProductNumber = newPiuPNum;
            this.hwProductRevision = newPiuPRev;
        } else {
            MessageLog.trace(4, this.getClass(), "The piuType is null, preInstalled will be used");
        }
    }

    public static void _setPnPPollingTime_onlyForTest(int poolingRate) {
        pnpPollingRate = poolingRate;
    }

    public static class FileState {
        public static final int NOT_INSTALLED = 0;
        public static final int INSTALLED = 1;
    }

    public static class LmFilesInstallState {
        public static final int NOT_INSTALLED = 0;
        public static final int PARTLY_INSTALLED = 1;
        public static final int INSTALLED = 2;
    }

    private static class SwInstallationListener
    implements PiuTypeInstallListener {
        public static final int ONE_SEC = 1000;
        private Object lock = new Object();
        private boolean _isFinnished = false;
        private InstallRejectReason _faultReason = null;
        private String _faultInfo = null;

        private SwInstallationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installPiuTypeConfirmed(int arg0) {
            MessageLog.traceEnter(this.getClass(), "installPiuTypeConfirmed()<---");
            Object object = this.lock;
            synchronized (object) {
                this._faultReason = null;
                this._faultInfo = null;
                this._isFinnished = true;
            }
            MessageLog.trace(4, this.getClass(), "SW Installation completed successfully ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installPiuTypeRejected(int arg0, InstallRejectReason arg1) {
            MessageLog.traceEnter(this.getClass(), "installPiuTypeRejected()<---");
            Object object = this.lock;
            synchronized (object) {
                this._faultReason = arg1;
                this._faultInfo = null;
                this._isFinnished = true;
            }
            MessageLog.trace(4, this.getClass(), "SW Installation rejected, reason :" + this._faultReason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installPiuTypeRejected(int arg0, InstallRejectReason arg1, String arg2) {
            MessageLog.traceEnter(this.getClass(), "installPiuTypeRejected()<---");
            Object object = this.lock;
            synchronized (object) {
                this._faultReason = arg1;
                this._faultInfo = arg2;
                this._isFinnished = true;
            }
            MessageLog.trace(4, this.getClass(), "SW Installation rejected, reason :" + this._faultReason + " info :" + this._faultInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFaultInformation() {
            Object object = this.lock;
            synchronized (object) {
                return (this._faultInfo != null ? this._faultInfo : "") + " " + this._faultReason;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isFinnished() {
            Object object = this.lock;
            synchronized (object) {
                return this._isFinnished;
            }
        }

        public void wait4PiuTypeInstallDone() {
            MessageLog.traceEnter(this.getClass(), "wait4PiuTypeInstallDone()<---");
            int timePassed = 0;
            while (!this.isFinnished()) {
                AuxPlugInUnitUpgradeHelper.wait(1000);
                MessageLog.trace(4, this.getClass(), "Still waiting for PiuType's file be installed!! Seconds passed:" + ++timePassed);
            }
            MessageLog.traceReturn(this.getClass(), "wait4PiuTypeInstallDone()--->");
        }
    }

    private class PiuTypeManuallyLoadedJob
    implements JobSchedulerListener {
        private PiuTypeManuallyLoadedJob() {
        }

        public void execute(Job aJob) {
            MessageLog.info(this.getClass(), "Start to execute Upgrade Task Hw Mismatch indication after manual PiuType inatll for: AuxPiu : " + AuxPiuHwUpgradeHandler.this.auxPiu.getLocalDistinguishedName() + "\n new HW PID: hwProductNumber=" + AuxPiuHwUpgradeHandler.this.hwProductNumber + ", hwProductRevision=" + AuxPiuHwUpgradeHandler.this.hwProductRevision);
            try {
                AuxPiuHwUpgradeHandler.this.reconfigure(50);
                MessageLog.info(this.getClass(), "Upgrade Task Hw Mismatch indication executed succesfully for: AuxPiu : " + AuxPiuHwUpgradeHandler.this.auxPiu.getLocalDistinguishedName() + "\n new HW PID: hwProductNumber=" + AuxPiuHwUpgradeHandler.this.hwProductNumber + ", hwProductRevision=" + AuxPiuHwUpgradeHandler.this.hwProductRevision);
            }
            catch (MoAccessException e) {
                MessageLog.traceError(this.getClass(), "Execution of Upgrade Task Hw Mismatch indication is failed due to exception:" + (Object)((Object)e));
            }
        }
    }
}

