/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.common;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;

public class MoHelper {
    public static boolean checkMosOpState(String typeName, Coordinator context) throws MoAccessException {
        MoIterator moIter = BoamHelper.findMOs(typeName);
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            if (mo == null || MoHelper.isOperStateEnabled(mo, context)) continue;
            return false;
        }
        return true;
    }

    public static void updateHwLogConfig(long froId, int clientId, ManagedObject deviceGroupMo) throws MoAccessException {
        String delta;
        ConfigurationVersionMo convMo;
        UpgradePackageMo tmpMo;
        MessageLog.traceEnter(MoHelper.class, "updateHwLogConfig()");
        String freeText = "";
        MoIterator iter = BoamHelper.findMOs("ConfigurationVersion");
        if (iter.hasMoreElements() && (tmpMo = (UpgradePackageMo)(convMo = (ConfigurationVersionMo)iter.nextMo()).getCurrentUpgradePackage(null)) != null) {
            freeText = "UP " + tmpMo.getUpgradePackageId(null);
        }
        long logId = 0L;
        MoIterator iterCarrier = BoamHelper.findMOs("Carrier");
        while (iterCarrier.hasMoreElements()) {
            List devices;
            CarrierMo carrier = (CarrierMo)iterCarrier.nextMo();
            boolean objResrvd = BoamHelper.checkObjResrvd(carrier, devices = BoamHelper.getDevices(deviceGroupMo));
            if (!objResrvd) continue;
            String sectorId = carrier.getParent().getNamingAttributeValue();
            String carrierId = carrier.getNamingAttributeValue();
            delta = ";sector " + sectorId + ";carrier " + carrierId;
            freeText = freeText.concat(delta);
        }
        MoIterator iterSector = BoamHelper.findMOs("Sector");
        while (iterSector.hasMoreElements()) {
            List devices;
            SectorMo sector = (SectorMo)iterSector.nextMo();
            boolean objResrvd = BoamHelper.checkObjResrvd(sector, devices = BoamHelper.getDevices(deviceGroupMo));
            if (!objResrvd) continue;
            String sectorId = sector.getNamingAttributeValue();
            delta = ";sector " + sectorId;
            freeText = freeText.concat(delta);
        }
        EqcDeviceGroupProxy.instance().updateGroupHwLog(clientId, froId, 0L, freeText);
    }

    public static boolean isHwLogActionsAllowed(AuxPlugInUnitMo auxPIU, Coordinator c) throws MoAccessException {
        int auType = auxPIU.getAuType(c);
        return auType != 15 && auType != 16 && auType != 13 && auType != 12 && auType != 8 && auType != 14 && auType != 7 && auType != 9 && auType != 18 && auType != 17 && auType != 25;
    }

    private static boolean isOperStateEnabled(ManagedObject mo, Coordinator context) throws MoAccessException {
        try {
            Integer operState = (Integer)mo.getAttribute("operationalState", context);
            if (operState == 1) {
                return true;
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            // empty catch block
        }
        return false;
    }
}

