/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsDeviceFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.DeviceMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.timing.TimDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AiDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.DbccDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.DpclDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TrDeviceMoImpl;

public class DeviceMoFactory
implements MoFactory {
    private static final Class SELF = DeviceMoFactory.class;
    private static DeviceMoFactory tuInstance;
    private static DeviceMoFactory dbchInstance;
    private static DeviceMoFactory dbccInstance;
    private static DeviceMoFactory trxInstance;
    private static DeviceMoFactory dpclInstance;
    private static DeviceMoFactory aiInstance;
    private static int devCounter;
    private static final int MAX_DEPTH = 15;
    private int eqcDeviceType = 0;

    private DeviceMoFactory(int deviceType) {
        MessageLog.traceEnter(this.getClass(), "DeviceMoFactory normal constructor, deviceType = " + deviceType);
        this.eqcDeviceType = deviceType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized DeviceMoFactory instance(int deviceType) {
        DeviceMoFactory instance;
        switch (deviceType) {
            case 1: {
                if (tuInstance == null) {
                    tuInstance = new DeviceMoFactory(deviceType);
                }
                instance = tuInstance;
                break;
            }
            case 2: {
                if (dbchInstance == null) {
                    dbchInstance = new DeviceMoFactory(deviceType);
                }
                instance = dbchInstance;
                break;
            }
            case 3: {
                if (dbccInstance == null) {
                    dbccInstance = new DeviceMoFactory(deviceType);
                }
                instance = dbccInstance;
                break;
            }
            case 4: {
                if (trxInstance == null) {
                    trxInstance = new DeviceMoFactory(deviceType);
                }
                instance = trxInstance;
                break;
            }
            case 5: {
                if (dpclInstance == null) {
                    dpclInstance = new DeviceMoFactory(deviceType);
                }
                instance = dpclInstance;
                break;
            }
            case 7: {
                if (aiInstance == null) {
                    aiInstance = new DeviceMoFactory(deviceType);
                }
                instance = aiInstance;
                break;
            }
            default: {
                String msg = "unsupported DeviceType code: " + deviceType;
                MessageLog.traceError(SELF, msg);
                instance = null;
            }
        }
        return instance;
    }

    public void createDeviceMo(ManagedObject parentDevSetMo, RbsDeviceFroInfoT deviceFroInfo, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "Creating DeviceMo with identity = " + identity);
        MessageLog.trace(1, SELF, "Creating DeviceMo with deviceFroId = " + deviceFroInfo.deviceFroId);
        this.createTheMo(parentDevSetMo, (int)deviceFroInfo.deviceFroId, identity, userLabel, context);
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        String msg = "Device MOs cannot be created over Mub";
        MessageLog.traceError(this.getClass(), msg);
        throw new MoCanNotBeCreatedException(msg);
    }

    public ManagedObject createTheMo(ManagedObject parent, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        DeviceMoImpl mo = null;
        switch (this.eqcDeviceType) {
            case 1: {
                mo = new TimDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                break;
            }
            case 3: {
                mo = new DbccDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                break;
            }
            case 4: {
                mo = new TrDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                break;
            }
            case 5: {
                mo = new DpclDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                break;
            }
            case 7: {
                mo = new AiDeviceMoImpl(parent, this.getMoTypeName(), deviceFroId, identity, userLabel, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal device type");
            }
        }
        MessageLog.trace(1, SELF, "createTheMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        DeviceMoImpl mo = null;
        switch (this.eqcDeviceType) {
            case 1: {
                mo = new TimDeviceMoImpl(recoveredData);
                break;
            }
            case 3: {
                mo = new DbccDeviceMoImpl(recoveredData);
                break;
            }
            case 4: {
                mo = new TrDeviceMoImpl(recoveredData);
                break;
            }
            case 5: {
                mo = new DpclDeviceMoImpl(recoveredData);
                break;
            }
            case 7: {
                mo = new AiDeviceMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal device type");
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        String name;
        switch (this.eqcDeviceType) {
            case 1: {
                name = "TimDevice";
                break;
            }
            case 3: {
                name = "DbccDevice";
                break;
            }
            case 4: {
                name = "TrDevice";
                break;
            }
            case 5: {
                name = "DpclDevice";
                break;
            }
            case 7: {
                name = "AiDevice";
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal device type");
                name = "UnknownDevice";
            }
        }
        return name;
    }

    public DeviceSetMoImpl findDeviceSetMo(DeviceSetMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 15, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (DeviceSetMoImpl)moIter.nextMo();
        }
        return null;
    }

    public DeviceMoImpl findDeviceMo(DeviceMoFilter filter, ManagedObject root) {
        MoIterator moIter = MoRepository.instance().select(root, 15, (MoFilter)filter);
        if (moIter.hasMoreElements()) {
            return (DeviceMoImpl)moIter.nextMo();
        }
        return null;
    }

    public static int getCounterValue() {
        return devCounter;
    }

    static {
        devCounter = 0;
    }
}

