/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSetFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AiDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.DbccDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.DbchDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.DpclDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.EDbchDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.EScDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.HsDbchDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TrDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.UbchDeviceSetMoImpl;

public class DeviceSetMoFactory
implements MoFactory {
    private static DeviceSetMoFactory dbchInstance;
    private static DeviceSetMoFactory dbccInstance;
    private static DeviceSetMoFactory trxInstance;
    private static DeviceSetMoFactory dpclInstance;
    private static DeviceSetMoFactory ubchInstance;
    private static DeviceSetMoFactory aiInstance;
    private static DeviceSetMoFactory hsDbchInstance;
    private static DeviceSetMoFactory escInstance;
    private static DeviceSetMoFactory edbchInstance;
    private int eqcSetType = 0;

    private DeviceSetMoFactory(int setType) {
        MessageLog.traceEnter(this.getClass(), setType + "DeviceSetMoFactory normal constructor");
        this.eqcSetType = setType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized DeviceSetMoFactory instance(int setType) {
        DeviceSetMoFactory instance;
        switch (setType) {
            case 49775: {
                if (hsDbchInstance == null) {
                    hsDbchInstance = new DeviceSetMoFactory(setType);
                }
                instance = hsDbchInstance;
                break;
            }
            case 49754: {
                if (dbchInstance == null) {
                    dbchInstance = new DeviceSetMoFactory(setType);
                }
                instance = dbchInstance;
                break;
            }
            case 49755: {
                if (dbccInstance == null) {
                    dbccInstance = new DeviceSetMoFactory(setType);
                }
                instance = dbccInstance;
                break;
            }
            case 49756: {
                if (trxInstance == null) {
                    trxInstance = new DeviceSetMoFactory(setType);
                }
                instance = trxInstance;
                break;
            }
            case 49757: {
                if (dpclInstance == null) {
                    dpclInstance = new DeviceSetMoFactory(setType);
                }
                instance = dpclInstance;
                break;
            }
            case 49758: {
                if (ubchInstance == null) {
                    ubchInstance = new DeviceSetMoFactory(setType);
                }
                instance = ubchInstance;
                break;
            }
            case 49759: {
                if (aiInstance == null) {
                    aiInstance = new DeviceSetMoFactory(setType);
                }
                instance = aiInstance;
                break;
            }
            case 49777: {
                if (escInstance == null) {
                    escInstance = new DeviceSetMoFactory(setType);
                }
                instance = escInstance;
                break;
            }
            case 49776: {
                if (edbchInstance == null) {
                    edbchInstance = new DeviceSetMoFactory(setType);
                }
                instance = edbchInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public void createDeviceSetMoTree(ManagedObject parentGroupMo, RbsSetFroInfoT devSetFroInfo, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "Creating DeviceSetMo with identity = " + identity);
        MessageLog.trace(1, this.getClass(), "Creating DeviceSetMo with setFroId = " + devSetFroInfo.devSetFroId);
        ManagedObject createdMo = this.createTheMo(parentGroupMo, (int)devSetFroInfo.devSetFroId, identity, userLabel, context);
        MessageLog.trace(1, this.getClass(), "Device Set MO Created");
        for (int i = 0; i < devSetFroInfo.numberOfDevices; ++i) {
            String deviceIdentity = "" + (i + 1);
            DeviceMoFactory deviceFactory = DeviceMoFactory.instance(this.getDeviceType());
            deviceFactory.createDeviceMo(createdMo, devSetFroInfo.deviceFroInfo[i], deviceIdentity, userLabel, context);
        }
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        String msg = "Device Set MOs cannot be created over Mub";
        MessageLog.traceError(this.getClass(), msg);
        throw new MoCanNotBeCreatedException(msg);
    }

    public ManagedObject createTheMo(ManagedObject parent, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcSetType) {
            case 49775: {
                mo = new HsDbchDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49754: {
                mo = new DbchDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49776: {
                mo = new EDbchDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49777: {
                mo = new EScDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49755: {
                mo = new DbccDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49756: {
                mo = new TrDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49757: {
                mo = new DpclDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49758: {
                mo = new UbchDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            case 49759: {
                mo = new AiDeviceSetMoImpl(parent, this.getMoTypeName(), devSetFroId, identity, userLabel, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal set type ..");
            }
        }
        MessageLog.trace(1, this.getClass(), "createMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcSetType) {
            case 49775: {
                mo = new HsDbchDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49754: {
                mo = new DbchDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49776: {
                mo = new EDbchDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49777: {
                mo = new EScDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49755: {
                mo = new DbccDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49756: {
                mo = new TrDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49757: {
                mo = new DpclDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49758: {
                mo = new UbchDeviceSetMoImpl(recoveredData);
                break;
            }
            case 49759: {
                mo = new AiDeviceSetMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal set type");
            }
        }
        return mo;
    }

    private int getDeviceType() {
        int deviceType = 0;
        switch (this.eqcSetType) {
            case 49755: {
                deviceType = 3;
                break;
            }
            case 49754: {
                deviceType = 2;
                break;
            }
            case 49756: {
                deviceType = 4;
                break;
            }
            case 49757: {
                deviceType = 5;
                break;
            }
            case 49758: {
                deviceType = 6;
                break;
            }
            case 49759: {
                deviceType = 7;
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal device type");
            }
        }
        return deviceType;
    }

    public String getMoTypeName() {
        String name = "UnknownDeviceSet";
        switch (this.eqcSetType) {
            case 49775: {
                name = "HsDbchDeviceSet";
                break;
            }
            case 49756: {
                name = "TrDeviceSet";
                break;
            }
            case 49755: {
                name = "DbccDeviceSet";
                break;
            }
            case 49754: {
                name = "DbchDeviceSet";
                break;
            }
            case 49757: {
                name = "DpclDeviceSet";
                break;
            }
            case 49758: {
                name = "UbchDeviceSet";
                break;
            }
            case 49759: {
                name = "AiDeviceSet";
                break;
            }
            case 49777: {
                name = "EScDeviceSet";
                break;
            }
            case 49776: {
                name = "EDbchDeviceSet";
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal set type: " + this.eqcSetType);
            }
        }
        return name;
    }
}

