/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.timing;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateDevSetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsSetFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TimDeviceSetMo;

public class TimDeviceSetMoImpl
extends DeviceSetMoImpl
implements TimDeviceSetMo {
    public static final int MO_DATA_REVISION = 3020001;
    private static final int CLIENT_ID = 0;

    private TimDeviceSetMoImpl(ManagedObject parent, String identity, String userLabel, int alarmStatus, Coordinator context) throws MoAccessException {
        super(parent, "TimDeviceSet", 0, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int parentPiuResId = -1;
        parentPiuResId = "Cbu".equals(parent.getType()) ? BoamHelper.getPlugInUnitFroId(parent.getParent(), context) : BoamHelper.getPlugInUnitFroId(parent, context);
        EqcCreateDevSetRspS rspSig = this.eqcDeviceSetProxy.createDevSet(this.getTxIdTransactional(context), 0L, 49773, parentPiuResId);
        IntegerAttribute devSetFroId = (IntegerAttribute)this.myData.getAttribute("devSetFroId");
        devSetFroId.setValue((int)rspSig.devSetFroId);
        DeviceMoFactory devFactory = DeviceMoFactory.instance(1);
        devFactory.createTheMo(this, (int)rspSig.deviceFroId, identity, userLabel, context);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(3020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49773, context);
        MessageLog.trace(1, this.getClass(), "TimDeviceSet created.");
    }

    private TimDeviceSetMoImpl(ManagedObject parent, String identity, RbsSetFroInfoT devSetFroInfo, String userLabel, int alarmStatus, Coordinator context) throws MoAccessException {
        super(parent, "TimDeviceSet", (int)devSetFroInfo.devSetFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        for (int i = 0; i < devSetFroInfo.numberOfDevices; ++i) {
            String deviceIdentity = "" + (i + 1);
            DeviceMoFactory deviceFactory = DeviceMoFactory.instance(1);
            deviceFactory.createDeviceMo(this, devSetFroInfo.deviceFroInfo[i], deviceIdentity, userLabel, context);
        }
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(3020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49773, context);
        MessageLog.trace(1, this.getClass(), "TimDeviceSet created.");
    }

    public TimDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        try {
            this.addObservers(49773, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(TimDeviceSetMoImpl.class, "create()");
        TimDeviceSetMoImpl.checkTransaction(context);
        TimDeviceSetMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "TimDeviceSet");
        int checkedAlarmStatus = TimDeviceSetMoImpl.checkAndGetAlarmStatus(attributes, 0, "TimDeviceSet", context);
        ValidateAttributes.checkOtherAttributes(attributes, "TimDeviceSet");
        return new TimDeviceSetMoImpl(parent, identity, checkedUserLabel, checkedAlarmStatus, context);
    }

    public static synchronized ManagedObject createTimDeviceSetTree4TuDeviceGroup(ManagedObject parent, RbsSetFroInfoT devSetFroInfo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(TimDeviceSetMoImpl.class, "createTimDeviceSetTree4TuDeviceGroup()");
        return new TimDeviceSetMoImpl(parent, "1", devSetFroInfo, "", 0, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        PlugInUnitMo piuMo = (PlugInUnitMo)TimDeviceSetMoImpl.getAncestor(this, "PlugInUnit");
        if (piuMo.getAdministrativeState(context) != 0) {
            String errMsg = "To delete TIM, PIU must be locked.";
            MessageLog.trace(1, this.getClass(), errMsg);
            throw new UndeletableMoException((ManagedObject)this);
        }
        if (this.getParent().getType().equals("TuDeviceGroup") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(this.getParent(), "TU")) {
            super.delete(context);
        } else {
            super.sysDelete(context);
        }
    }

    public String getType() {
        return "TimDeviceSet";
    }

    public static void checkParent(ManagedObject parent) throws MoAccessException {
        if (parent == null) {
            throw new IllegalParentException("Parent is null!!");
        }
        if (!parent.getType().equals("Cbu") && !parent.getType().equals("PlugInUnit")) {
            throw new IllegalParentException("Expecting:Cbu or PlugInUnit, but recived:" + parent.getType());
        }
    }
}

