/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaDeviceGroupMo;

public class McpaDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements McpaDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020001;

    public McpaDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "McpaDeviceGroupMoImpl() Recovery constructor");
        StringAttribute userLabel = (StringAttribute)recoveredData.getAttribute("userLabel");
        IntegerAttribute froId = (IntegerAttribute)recoveredData.getAttribute("auxGroupFroId");
        IntegerAttribute alarmStatus = (IntegerAttribute)recoveredData.getAttribute("alarmStatus");
        ErrorMgr.shotDownIfNull(userLabel, "userLabel");
        ErrorMgr.shotDownIfNull(froId, "auxGroupFroId");
        ErrorMgr.shotDownIfNull(alarmStatus, "alarmStatus");
        try {
            this.addObservers(49553, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private McpaDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "McpaDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49553, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49553).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49553, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(McpaDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 1) {
            throw new IllegalParentException("McpaDeviceGroup");
        }
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "McpaDeviceGroup");
        int checkedAlarmStatus = McpaDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "McpaDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "McpaDeviceGroup");
        return new McpaDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public String getType() {
        return "McpaDeviceGroup";
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3020001);
    }
}

