/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import java.io.File;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.FtpUtil;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetRetDeviceParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRetGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccRetDeviceDataS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FileMissingOnServerException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FtpServerNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoConnectionWithAuxiliaryUnitException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.SendAntennaConfigurationFileException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.AretDeviceDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;

public class RetDeviceMoImpl
extends AuxDeviceMoImpl
implements RetDeviceMo {
    public static final int MO_DATA_REVISION = 2020001;
    private String aretLocalFilePath = "/c/systemfiles/rbs/antenna_system_config/";
    private String aretLocalFileName = "aret_config_file.bin";

    public RetDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 17, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        AuxPlugInUnitMo auxPlugInUnitMo = (AuxPlugInUnitMo)RetDeviceMoImpl.getAncestor(parent, "AuxPlugInUnit");
        ManagedObject antenna = auxPlugInUnitMo.getParent();
        eqcDeviceProxy.setRetDeviceParam(0L, this.getTxIdTransactional(context), deviceFroId, ((MaoHasFro)antenna).getFroId(context));
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(2020001);
        this.addMyObservers(context);
    }

    public RetDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addMyObservers(null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        super.sysDelete(context);
    }

    public String getType() {
        return "RetDevice";
    }

    public String getRetDeviceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetDeviceId()");
        return this.getIdentity(context);
    }

    public void actionForceCalibration(Coordinator context) throws MoAccessException {
        block2: {
            MessageLog.traceEnter(this.getClass(), "actionForceCalibration()");
            this.myData.handleTransaction(context, MoData.READ_ACCESS);
            try {
                scRfAccessProxy.rfapCalibrateRet(this.getTxIdTransactional(context), 0, this.getRfapFroId(context), this.getFroId(context));
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() != 7) break block2;
                throw new MoDisabledException();
            }
        }
    }

    public void setElectricalAntennaTilt(int tilt, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalAntennaTilt()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalAntennaTilt", tilt, ELECTRICAL_ANTENNA_TILT_MIN_VALUES, ELECTRICAL_ANTENNA_TILT_MAX_VALUES, this.getType());
        eqcDeviceProxy.setTilt(0L, this.getTxIdNonTransactional(context), this.getFroId(context), tilt);
        this.sendAVC("electricalAntennaTilt", tilt, context);
    }

    public int getElectricalAntennaTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalAntennaTilt()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EcGetRetDeviceParamRspS rspSig = eqcDeviceProxy.getElectricalAntennaTilt(this.getTxIdNonTransactional(context), 0L, this.getFroId(context));
        return (int)rspSig.electricalAntennaTiltValue;
    }

    public int getMaxTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxTilt()");
        LrsRetGetParamRspS rspSig = scRfAccessProxy.retGetParam(0, this.getRfapFroId(context), this.getFroId(context));
        int mxT = rspSig.maxTilt;
        if (!this.maxTiltIsValid(mxT)) {
            MessageLog.info(this.getClass(), "MaxTilt out of range(" + mxT + "),taking default value(-1)");
            return 0;
        }
        return mxT;
    }

    public int getMinTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinTilt()");
        LrsRetGetParamRspS rspSig = scRfAccessProxy.retGetParam(0, this.getRfapFroId(context), this.getFroId(context));
        int mnT = rspSig.minTilt;
        if (!this.minTiltIsValid(mnT)) {
            MessageLog.info(this.getClass(), "MinTilt out of range(" + mnT + "), taking default value(-1)");
            return 0;
        }
        return mnT;
    }

    private boolean maxTiltIsValid(int maxTilt) {
        MessageLog.traceEnter(this.getClass(), "maxTiltIsValid() <---");
        boolean valid = false;
        for (int i = 0; i < MAX_TILT_MIN_VALUES.length; ++i) {
            if (maxTilt < MAX_TILT_MIN_VALUES[i] || maxTilt > MAX_TILT_MAX_VALUES[i]) continue;
            valid = true;
        }
        return valid;
    }

    private boolean minTiltIsValid(int minTilt) {
        MessageLog.traceEnter(this.getClass(), "maxTiltIsValid() <---");
        boolean valid = false;
        for (int i = 0; i < MIN_TILT_MIN_VALUES.length; ++i) {
            if (minTilt < MIN_TILT_MIN_VALUES[i] || minTilt > MIN_TILT_MAX_VALUES[i]) continue;
            valid = true;
        }
        return valid;
    }

    private int getRfapFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfapFroId()");
        ManagedObject auxPluginUnit = RetDeviceMoImpl.getAncestor(this, "AuxPlugInUnit");
        ManagedObject antennaMo = auxPluginUnit.getParent();
        ManagedObject[] antennaReservers = new ManagedObject[1];
        if (antennaMo instanceof SectorAntennaMo) {
            antennaReservers = ((SectorAntennaMo)antennaMo).getReservedBy(context);
        } else if (antennaMo instanceof ExternalAntennaMo) {
            antennaReservers[0] = ((ExternalAntennaMo)antennaMo).getSectorRef(context);
        }
        if (antennaReservers.length != 0 && antennaReservers[0] instanceof SectorMo) {
            SectorMo sector = (SectorMo)antennaReservers[0];
            return sector.getRfAccessPointFroId(context);
        }
        MessageLog.traceError(this.getClass(), "getRfapFroId(): Sector (holding froId) not found.");
        throw new MoNotFoundException(this.getType());
    }

    private void addMyObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{ScRfAccessProxy.instance(), eqcBdhIndProxy}, 17, this.getFroId(context), context);
    }

    public Struct getAretDeviceData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAretDeviceData()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        int retDeviceFroId = this.getFroId(c);
        LrsRetGetParamRspS rspSig = scRfAccessProxy.retGetParam(0, this.getRfapFroId(c), retDeviceFroId);
        return RetDeviceMoImpl.buildAretDeviceDataStruct(rspSig.deviceData);
    }

    public static AretDeviceDataStruct buildAretDeviceDataStruct(SccRetDeviceDataS deviceData) {
        return new AretDeviceDataStruct(deviceData.antennaModelNumber, deviceData.antennaSerialNumber, deviceData.antennaOperatingBand, deviceData.beamwidth, deviceData.gain, new Integer(deviceData.maxTilt), deviceData.installationDate, deviceData.installerID, deviceData.baseStationID, deviceData.sectorID, deviceData.antennaBearing, new Integer(deviceData.installedMechanicalTilt), new Integer(deviceData.minTilt));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionSendAntennaConfigurationFile(String server, String path, String userName, String password, Coordinator c) throws MoAccessException, FileMissingOnServerException, FtpServerNotAccessibleException, FunctionNotSupportedException, NoConnectionWithAuxiliaryUnitException, NotInitiatedException, SendAntennaConfigurationFileException {
        block10: {
            MessageLog.traceEnter(this.getClass(), "actionSendAntennaConfigurationFile()");
            AccessControlHelper.performAccessControl();
            AuxPlugInUnitMo auxPlugInUnitMo = (AuxPlugInUnitMo)RetDeviceMoImpl.getAncestor(this.getParent(), "AuxPlugInUnit");
            if (auxPlugInUnitMo.getOperationalState(c) != 1) {
                throw new NoConnectionWithAuxiliaryUnitException("OperState is not enabled!");
            }
            if (auxPlugInUnitMo.getAuType(c) != 18) {
                throw new FunctionNotSupportedException("AuType is not Aret type!");
            }
            this.fetchAretFileFromFtpserver(server, path, userName, password);
            try {
                try {
                    scRfAccessProxy.sendAretAntennaConfigFile(0, this.getRfapFroId(c), this.getFroId(c), this.aretLocalFilePath, this.aretLocalFileName);
                }
                catch (FroRequestFailedException e) {
                    if (e.getOrgErrorCode() == 2) {
                        throw new NoConnectionWithAuxiliaryUnitException(e.getErrorCode());
                    }
                    if (e.getOrgErrorCode() == 30) {
                        throw new FunctionNotSupportedException(e.getErrorCode());
                    }
                    if (e.getOrgErrorCode() == 22) throw new NotInitiatedException();
                    if (e.getOrgErrorCode() != 14) throw new SendAntennaConfigurationFileException(e.getErrorCode());
                    throw new NotInitiatedException();
                }
                Object var9_7 = null;
                File f = new File(this.aretLocalFilePath + this.aretLocalFileName);
                if (!f.exists()) return;
                if (f.delete()) break block10;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                File f = new File(this.aretLocalFilePath + this.aretLocalFileName);
                if (!f.exists()) throw throwable;
                if (!f.delete()) {
                    MessageLog.traceError(this.getClass(), "Delete the Aret file failed!");
                    throw throwable;
                }
                MessageLog.trace(2, this.getClass(), "Delete the Aret file is successful!");
                throw throwable;
            }
            MessageLog.traceError(this.getClass(), "Delete the Aret file failed!");
            return;
        }
        MessageLog.trace(2, this.getClass(), "Delete the Aret file is successful!");
    }

    private void fetchAretFileFromFtpserver(String ip_address, String remote_path, String username, String password) throws OperationFailedException, FileMissingOnServerException, FtpServerNotAccessibleException {
        MessageLog.trace(2, this.getClass(), "Fetching of " + remote_path + " begin:");
        File d = new File(this.aretLocalFilePath);
        if (!d.exists() && !d.mkdirs()) {
            MessageLog.traceError(this.getClass(), "Creating file folder " + this.aretLocalFilePath + " is failed!");
        }
        File f = new File(this.aretLocalFilePath + this.aretLocalFileName);
        FtpUtil.ftpGet(ip_address, username, password, remote_path, f.getAbsolutePath());
        MessageLog.trace(2, this.getClass(), "Fetching of " + remote_path + " completed.!");
    }

    public void _setLocalPath_ForTestOnly() {
        this.aretLocalFilePath = AiMessageLog.getTempDirPath() + "/rbs_auto_cfg/";
    }
}

