/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuDeviceGroupMo;

public class RuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements RuDeviceGroupMo {
    public static final int MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 3010001;

    public RuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "RuDeviceGroupMoImpl()  Recovery constructor <---");
        ErrorMgr.shotDownIfDiffRev(this.getMyMoData().getRevision(), 3010001);
        StringAttribute userLabel = (StringAttribute)recoveredData.getAttribute("userLabel");
        IntegerAttribute froId = (IntegerAttribute)recoveredData.getAttribute("auxGroupFroId");
        IntegerAttribute alarmStatus = (IntegerAttribute)recoveredData.getAttribute("alarmStatus");
        ErrorMgr.shotDownIfNull(userLabel, "userLabel");
        ErrorMgr.shotDownIfNull(froId, "auxGroupFroId");
        ErrorMgr.shotDownIfNull(alarmStatus, "alarmStatus");
        try {
            this.addObservers(49563, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private RuDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "RuDeviceGroup", identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "RetuDeviceGroupMoImpl() <---");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49563, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49563).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49563, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RuDeviceGroupMoImpl.class, "create () <---");
        ValidateAttributes.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RuDeviceGroup");
        int checkedAlarmStatus = RuDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "RuDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "RuDeviceGroup");
        return new RuDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public String getType() {
        return "RuDeviceGroup";
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3010001);
    }

    public String checkSpecificEvent(int eventType) {
        if (49160 == eventType) {
            return this.getType() + "_MaintenanceButtonInitiatedBoardRestart";
        }
        return null;
    }
}

