/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import java.io.File;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetTmasParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FileMissingOnDiskException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.SectorInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.TmfDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TmaDeviceSetMo;

public class TmaDeviceSetMoImpl
extends AuxDeviceSetMoImpl
implements TmaDeviceSetMo {
    public static final int MO_DATA_REVISION = 6041001;
    public static final int DL_ATTENUATION_INDEX = 1;
    public static final int DL_DELAY_INDEX = 2;
    public static final int UL_DELAY_INDEX = 3;
    public static final int TMF_FILE_PATH_INDEX = 4;
    public static final int TMF_FILE_NAME_INDEX = 5;
    public static final int IRRELEVANT_VALUE = -1;
    public static final String IRRELEVANT_STRING = "";

    public TmaDeviceSetMoImpl(ManagedObject parent, String thisMoName, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 49766, devSetFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(6041001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(49766, context);
    }

    public TmaDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(49766, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public String getTmaDeviceSetId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTmaDeviceSetId()");
        return this.getIdentity(context);
    }

    public String getType() {
        return "TmaDeviceSet";
    }

    public int getDlAttenuation(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation()");
        return (int)this.eqcDeviceSetProxy.getTmaDevSetParameters((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDevSetFroId((Coordinator)c))).dlAttenuation;
    }

    public int getDlTrafficDelay(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlTrafficDelay()");
        return (int)this.eqcDeviceSetProxy.getTmaDevSetParameters((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDevSetFroId((Coordinator)c))).dlDelay;
    }

    public int getUlTrafficDelay(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlTrafficDelay()");
        return (int)this.eqcDeviceSetProxy.getTmaDevSetParameters((long)((long)this.getTxIdNonTransactional((Coordinator)c)), (long)0L, (long)((long)this.getAuxDevSetFroId((Coordinator)c))).ulDelay;
    }

    public void setDlAttenuation(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, "TmaDeviceSet");
        this.eqcDeviceSetProxy.setTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c), 1L, value, -1L, -1L, IRRELEVANT_STRING, IRRELEVANT_STRING);
        this.sendAVC("dlAttenuation", value, c);
    }

    public void setDlTrafficDelay(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlTrafficDelay()");
        ValidateAttributes.intValueRangeCheck("dlTrafficDelay", value, DL_TRAFFIC_DELAY_MIN_VALUES, DL_TRAFFIC_DELAY_MAX_VALUES, "TmaDeviceSet");
        this.eqcDeviceSetProxy.setTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c), 2L, -1L, value, -1L, IRRELEVANT_STRING, IRRELEVANT_STRING);
        this.sendAVC("dlTrafficDelay", value, c);
    }

    public void setUlTrafficDelay(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUlTrafficDelay()");
        ValidateAttributes.intValueRangeCheck("ulTrafficDelay", value, UL_TRAFFIC_DELAY_MIN_VALUES, UL_TRAFFIC_DELAY_MAX_VALUES, "TmaDeviceSet");
        this.eqcDeviceSetProxy.setTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c), 3L, -1L, -1L, value, IRRELEVANT_STRING, IRRELEVANT_STRING);
        this.sendAVC("ulTrafficDelay", value, c);
    }

    public void actionConfigureTmf(Coordinator c) throws MoAccessException, FileMissingOnDiskException, SectorInitiatedException {
        MessageLog.traceEnter(this.getClass(), "actionConfigureTmf");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ManagedObject sector = this.getCorrespondingSector(c);
        if (((SectorMo)sector).isSectorInitialized(c)) {
            throw new SectorInitiatedException("Sector must be uninitiated");
        }
        String sectorNo = sector.getNamingAttributeValue();
        File f = new File(RbsConfigurationMoImpl.getLocAntSysConfig());
        String[] fileArray = f.list();
        int finalVersionNo = -1;
        String finalFileName = null;
        for (int i = 0; i < fileArray.length; ++i) {
            String patternStr = "TmfData_S" + sectorNo + "_V";
            int iVersionNo = this.getVersionNum(patternStr, fileArray[i]);
            if (iVersionNo <= finalVersionNo) continue;
            finalVersionNo = iVersionNo;
            finalFileName = fileArray[i];
        }
        if (null == finalFileName) {
            throw new FileMissingOnDiskException("no tmfData file exist for sector=" + sectorNo);
        }
        this.sendTmfDataPath(c);
        this.sendTmfDataFileName(finalFileName, c);
    }

    private void sendTmfDataFileName(String fileName, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sendTmfDataFileName()");
        this.eqcDeviceSetProxy.setTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c), 5L, -1L, -1L, -1L, IRRELEVANT_STRING, fileName);
    }

    private void sendTmfDataPath(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sendTmfDataPath()");
        this.eqcDeviceSetProxy.setTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c), 4L, -1L, -1L, -1L, RbsConfigurationMoImpl.getLocAntSysConfig(), IRRELEVANT_STRING);
    }

    public Struct getTmfData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTmfData()");
        EcGetTmasParamRspS rsp = this.eqcDeviceSetProxy.getTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c));
        return new TmfDataStruct(rsp.tmfData.airCarrier, rsp.tmfData.feederCarrier, rsp.tmfData.ifBandwidth, rsp.tmfData.ulDelay, rsp.tmfData.dlDelay);
    }

    public String getTmfDataFileName(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTmfDataFileName()");
        EcGetTmasParamRspS rsp = this.eqcDeviceSetProxy.getTmaDevSetParameters(this.getTxIdNonTransactional(c), 0L, this.getAuxDevSetFroId(c));
        return rsp.tmfFileName;
    }

    private ManagedObject getCorrespondingSector(Coordinator c) throws MoAccessException {
        ManagedObject obj = this.getParent();
        if (null == obj || !(obj instanceof DeviceGroupMo)) {
            throw new IllegalParentException("DeviceGroup");
        }
        DeviceGroupMo devicegroup = (DeviceGroupMo)obj;
        obj = devicegroup.getParent();
        if (null == obj || !(obj instanceof AuxPlugInUnitMo)) {
            throw new IllegalParentException("AuxPlugInUnit");
        }
        AuxPlugInUnitMo piu = (AuxPlugInUnitMo)obj;
        obj = piu.getParent();
        if (null == obj || !(obj instanceof SectorAntennaMo)) {
            throw new IllegalParentException("SectorAntenna");
        }
        SectorAntennaMo sa = (SectorAntennaMo)obj;
        ManagedObject[] sectorByList = sa.getReservedBy(null);
        if (sectorByList != null && sectorByList.length > 0) {
            for (int i = 0; i < sectorByList.length; ++i) {
                if (!(sectorByList[i] instanceof SectorMo)) continue;
                return sectorByList[i];
            }
        }
        throw new ConfigNotSupportedException("no sector found in SectorAntennaMo.getReservedBy");
    }

    private int getVersionNum(String prefix, String fileName) {
        StringBuffer sVersion = new StringBuffer();
        if (!fileName.startsWith(prefix)) {
            return -2;
        }
        for (int i = prefix.length(); i < fileName.length() && fileName.charAt(i) >= '0' && fileName.charAt(i) <= '9'; ++i) {
            sVersion.append(fileName.charAt(i));
        }
        if (sVersion.length() == 0) {
            return -2;
        }
        return Integer.parseInt(sVersion.toString());
    }
}

