/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAntFeedCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntFeederCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntennaBranchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ConnectionFieldMo;

public class AntFeederCableMoImpl
extends BoamManagedObjectWithAlarms
implements AntFeederCableMo {
    private static final String LDN_RX_EXT = "_EXT";
    private static final int DEFAULT_VALUE = 0;
    private static final int NOT_SET = 0;
    private static final int[] NOT_SET_ARRAY = new int[15];
    public static final String ANTFEEDER_CABLE_FRO_ID = "AntFeederCableFroId";
    public static final int MO_DATA_REVISION = 3040401;
    private EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();

    public AntFeederCableMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, int checkedAlarmStatus, AttrList attributes, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " Normal AntFeederCableMoImpl() <---");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "AntFeederCable");
        String[] classNamesAllowedA = new String[]{"RruDeviceGroup", "ConnectionField", "AuxPlugInUnit", "DeviceGroup"};
        ManagedObject checkedConnectedToObjectARef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectARef", attributes, "mandatory", classNamesAllowedA, "AntFeederCable");
        String[] classNamesAllowedB = new String[]{"AntennaBranch"};
        ManagedObject checkedConnectedAntennaBranchRef = ValidateAttributes.checkAndGetReferenceAttribute("antennaBranchRef", attributes, "mandatory", classNamesAllowedB, "AntFeederCable");
        int checkedObjectAConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectAConnector", "mandatory", 0, 0, 24, "AntFeederCable");
        int[] checkedElectricalUlDelay = this.checkAndGetIntSeqAttribute(attributes, "electricalUlDelay", "mandatory", -1, ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, 15, "AntFeederCable", context);
        int[] checkedElectricalDlDelay = this.checkAndGetIntSeqAttribute(attributes, "electricalDlDelay", "mandatory", -1, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, 15, "AntFeederCable", context);
        int[] checkedDlAttenuation = this.checkAndGetIntSeqAttribute(attributes, "dlAttenuation", "mandatory", -500, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, 15, "AntFeederCable", context);
        int[] checkedUlAttenuation = this.checkAndGetIntSeqAttribute(attributes, "ulAttenuation", "mandatory", -500, UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, 15, "AntFeederCable", context);
        ValidateAttributes.checkOtherAttributes(attributes, "AntFeederCable");
        try {
            this.initMoData(checkedUserLabel, checkedConnectedToObjectARef, checkedConnectedAntennaBranchRef, checkedObjectAConnector, checkedAlarmStatus, context);
            this.setDlAttenuation(checkedDlAttenuation, context);
            this.setElectricalDlDelay(checkedElectricalDlDelay, context);
            this.setUlAttenuation(checkedUlAttenuation, context);
            this.setElectricalUlDelay(checkedElectricalUlDelay, context);
            this.addObservers(50155, context);
            MessageLog.trace(1, this.getClass(), "MO is created");
        }
        catch (MoAccessException e) {
            if (this.getAntennaBranchRef(context) != null) {
                ((Reservable)this.getAntennaBranchRef(context)).release((ManagedObject)this, context);
            }
            if (this.getConnectedToObjectARef(context) != null) {
                ((Reservable)this.getConnectedToObjectARef(context)).release((ManagedObject)this, context);
            }
            super.delete(context);
            MessageLog.trace(1, this.getClass(), "AntFeederCableMoImpl() : problem occured during creation, deletion done !");
            throw e;
        }
    }

    public AntFeederCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        this.myData = recoveredData;
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute(ANTFEEDER_CABLE_FRO_ID), ANTFEEDER_CABLE_FRO_ID);
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("connectedToObjectARef"), "connectedToObjectARef");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("antennaBranchRef"), "antennaBranchRef");
        try {
            this.addObservers(50155, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "AntFeederCableis restored !!");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AntFeederCableMoImpl.class, "create()<---");
        AntFeederCableMoImpl.checkTransaction(context);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, AntFeederCableMo.ALARM_STATUS_MIN_VALUES, AntFeederCableMo.ALARM_STATUS_MAX_VALUES, "AntFeederCable");
        ValidateAttributes.checkParent(parent, "Equipment");
        MessageLog.trace(1, AntFeederCableMoImpl.class, "Parent into create() =" + parent.getType());
        return new AntFeederCableMoImpl(parent, "AntFeederCable", identity, context, checkedAlarmStatus, attributes, source);
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        ManagedObject connectedToARef;
        MessageLog.traceEnter(this.getClass(), "delete() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute antFeederCableFroIdAttr = (IntegerAttribute)this.getMyMoData().getAttribute(ANTFEEDER_CABLE_FRO_ID);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, antFeederCableFroIdAttr.getValue(context), 50155);
        ManagedObject antBranchRef = this.getAntennaBranchRef(context);
        if (antBranchRef != null) {
            MessageLog.trace(1, this.getClass(), "antBranchRef " + antBranchRef.getFullDistinguishedName());
            ((Reservable)antBranchRef).release((ManagedObject)this, context);
        }
        if ((connectedToARef = this.getConnectedToObjectARef(context)) != null) {
            MessageLog.trace(1, this.getClass(), "connectedToARef " + connectedToARef.getFullDistinguishedName());
            ((Reservable)connectedToARef).release((ManagedObject)this, context);
        }
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public String getType() {
        return "AntFeederCable";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData() <---");
        if (this.myData == null) {
            MessageLog.trace(1, this.getClass(), "getMyMoData() : myData is NULL !");
        }
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent() <---");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() <---");
        this.getMyMoData().handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute userLabAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()<--- ");
        ValidateAttributes.stringValueRangeCheck("userLabel", value, 128, this.getType());
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        userLabelAttr.setValue(value);
        this.sendAVC("userLabel", value, context);
    }

    public int getAntFeederCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAntFeederCableFroId() <---");
        this.getMyMoData().handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute antFeederCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(ANTFEEDER_CABLE_FRO_ID);
        return antFeederCableFroIdAttr.getValue(context);
    }

    public ManagedObject getConnectedToObjectARef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectARef() <---");
        this.getMyMoData().handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute connectedToObjectARefAttr = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        return connectedToObjectARefAttr.getValue(context);
    }

    public void setConnectedToObjectARef(ManagedObject value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setConnectedToObjectARef() <---");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 1, this.getObjectARefFroId(value, context), 0, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY);
        ReferenceAttribute connectedToObjectARefAttr = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        ManagedObject moOldRef = connectedToObjectARefAttr.getValue(context);
        if (moOldRef != null) {
            ((Reservable)moOldRef).release((ManagedObject)this, context);
        }
        connectedToObjectARefAttr.setValue(value);
        ((Reservable)value).reserve((ManagedObject)this, context);
        this.sendAVC("connectedToObjectARef", value, context);
    }

    public ManagedObject getAntennaBranchRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAntennaBranchRef() <---");
        this.getMyMoData().handleTransaction(context, MoData.READ_ACCESS);
        ReferenceAttribute connectedAntennaBranchRefAttr = (ReferenceAttribute)this.myData.getAttribute("antennaBranchRef");
        return connectedAntennaBranchRefAttr.getValue(context);
    }

    public int getObjectAConnector(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnector() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        int objectAConnector = 0;
        switch (rspSig.objectAConnectorId) {
            case 68: {
                objectAConnector = 0;
                break;
            }
            case 4: {
                objectAConnector = 4;
                break;
            }
            case 5: {
                objectAConnector = 6;
                break;
            }
            case 6: {
                objectAConnector = 8;
                break;
            }
            case 7: {
                objectAConnector = 3;
                break;
            }
            case 8: {
                objectAConnector = 5;
                break;
            }
            case 9: {
                objectAConnector = 7;
                break;
            }
            case 25: {
                objectAConnector = 9;
                break;
            }
            case 26: {
                objectAConnector = 10;
                break;
            }
            case 27: {
                objectAConnector = 11;
                break;
            }
            case 28: {
                objectAConnector = 12;
                break;
            }
            case 29: {
                objectAConnector = 13;
                break;
            }
            case 30: {
                objectAConnector = 14;
                break;
            }
            case 18: {
                objectAConnector = 1;
                break;
            }
            case 19: {
                objectAConnector = 2;
                break;
            }
            case 69: {
                objectAConnector = 15;
                break;
            }
            case 70: {
                objectAConnector = 16;
                break;
            }
            case 71: {
                objectAConnector = 18;
                break;
            }
            case 72: {
                objectAConnector = 17;
                break;
            }
            case 73: {
                objectAConnector = 19;
                break;
            }
            case 90: {
                objectAConnector = 20;
                break;
            }
            case 92: {
                objectAConnector = 21;
                break;
            }
            case 93: {
                objectAConnector = 22;
                break;
            }
            case 96: {
                objectAConnector = 23;
                break;
            }
            case 97: {
                objectAConnector = 24;
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "Mub value out of range: objectAConnector = " + rspSig.objectAConnectorId);
            }
        }
        return objectAConnector;
    }

    public void setObjectAConnector(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setObjectAConnector() <---");
        ValidateAttributes.checkTransaction(context);
        int objectAConnector = 0;
        switch (value) {
            case 9: {
                objectAConnector = 25;
                break;
            }
            case 10: {
                objectAConnector = 26;
                break;
            }
            case 11: {
                objectAConnector = 27;
                break;
            }
            case 12: {
                objectAConnector = 28;
                break;
            }
            case 13: {
                objectAConnector = 29;
                break;
            }
            case 14: {
                objectAConnector = 30;
                break;
            }
            case 1: {
                objectAConnector = 18;
                break;
            }
            case 2: {
                objectAConnector = 19;
                break;
            }
            case 4: {
                objectAConnector = 4;
                break;
            }
            case 6: {
                objectAConnector = 5;
                break;
            }
            case 8: {
                objectAConnector = 6;
                break;
            }
            case 3: {
                objectAConnector = 7;
                break;
            }
            case 5: {
                objectAConnector = 8;
                break;
            }
            case 7: {
                objectAConnector = 9;
                break;
            }
            case 15: {
                objectAConnector = 69;
                break;
            }
            case 16: {
                objectAConnector = 70;
                break;
            }
            case 18: {
                objectAConnector = 71;
                break;
            }
            case 17: {
                objectAConnector = 72;
                break;
            }
            case 19: {
                objectAConnector = 73;
                break;
            }
            case 20: {
                objectAConnector = 90;
                break;
            }
            case 21: {
                objectAConnector = 92;
                break;
            }
            case 22: {
                objectAConnector = 93;
                break;
            }
            case 0: {
                objectAConnector = 68;
                break;
            }
            case 23: {
                objectAConnector = 96;
                break;
            }
            case 24: {
                objectAConnector = 97;
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "Mub value out of range: objectAConnector = " + value);
                throw new ValueOutOfRangeException("objectAConnector", "AntFeederCable");
            }
        }
        this.verifyObjectAConnector(objectAConnector);
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 2, 0L, objectAConnector, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY);
        this.sendAVC("objectAConnector", value, context);
    }

    private void verifyObjectAConnector(int objectAConnector) throws MoAccessException {
        String ldn = this.getNamingAttributeValue();
        if (ldn.endsWith(LDN_RX_EXT) && objectAConnector != 90 && objectAConnector != 92 && objectAConnector != 68) {
            throw new ConfigurationNotSupportedException("Configuration invalid, the objectAConnector shall point to RX IO.");
        }
    }

    public int[] getDlAttenuation(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        return rspSig.dlAttenuation;
    }

    public void setDlAttenuation(int[] dlAttenuationArgArr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        if (dlAttenuationArgArr.length != 15) {
            MessageLog.trace(2, this.getClass(), "dlAttenuation must have 15elements");
            throw new WrongAttributeTypeException("dlAttenuation", "AntFeederCable");
        }
        for (int i = 0; i < dlAttenuationArgArr.length; ++i) {
            ValidateAttributes.intValueRangeCheck("dlAttenuation", dlAttenuationArgArr[i], DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, "AntFeederCable");
        }
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 3, 0L, 0, dlAttenuationArgArr, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY);
        this.sendAVC("dlAttenuation", dlAttenuationArgArr, context);
    }

    public int[] getElectricalDlDelay(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        return rspSig.electricalDlDelay;
    }

    public void setElectricalDlDelay(int[] electricalDlDelayArgArr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        if (electricalDlDelayArgArr.length != 15) {
            MessageLog.trace(2, this.getClass(), "electricalDlDelay must have 15elements");
            throw new WrongAttributeTypeException("electricalDlDelay", "AntFeederCable");
        }
        for (int i = 0; i < electricalDlDelayArgArr.length; ++i) {
            ValidateAttributes.intValueRangeCheck("electricalDlDelay", electricalDlDelayArgArr[i], ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, "AntFeederCable");
        }
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 4, 0L, 0, NOT_SET_ARRAY, electricalDlDelayArgArr, NOT_SET_ARRAY, NOT_SET_ARRAY);
        this.sendAVC("electricalDlDelay", electricalDlDelayArgArr, context);
    }

    public int[] getUlAttenuation(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getUlAttenuation() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        return rspSig.ulAttenuation;
    }

    public void setUlAttenuation(int[] ulAttenuationArgArr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        if (ulAttenuationArgArr.length != 15) {
            MessageLog.trace(2, this.getClass(), "ulAttenuation must have 15elements");
            throw new WrongAttributeTypeException("ulAttenuation", "AntFeederCable");
        }
        for (int i = 0; i < ulAttenuationArgArr.length; ++i) {
            ValidateAttributes.intValueRangeCheck("ulAttenuation", ulAttenuationArgArr[i], UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, "AntFeederCable");
        }
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 5, 0L, 0, NOT_SET_ARRAY, NOT_SET_ARRAY, ulAttenuationArgArr, NOT_SET_ARRAY);
        this.sendAVC("ulAttenuation", ulAttenuationArgArr, context);
    }

    public int[] getElectricalUlDelay(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getElectricalUlDelay() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        return rspSig.electricalUlDelay;
    }

    public void setElectricalUlDelay(int[] electricalUlDelayArgArr, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalUlDelay() <---");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        if (electricalUlDelayArgArr.length != 15) {
            MessageLog.trace(2, this.getClass(), "electricalUlDelay must have 15elements");
            throw new WrongAttributeTypeException("electricalUlDelay", "AntFeederCable");
        }
        for (int i = 0; i < electricalUlDelayArgArr.length; ++i) {
            ValidateAttributes.intValueRangeCheck("electricalUlDelay", electricalUlDelayArgArr[i], ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, "AntFeederCable");
        }
        this.eqcCableProxy.setAntFeedCableParameters(this.getTxIdTransactional(context), 0L, this.getAntFeederCableFroId(context), 6, 0L, 0, NOT_SET_ARRAY, NOT_SET_ARRAY, NOT_SET_ARRAY, electricalUlDelayArgArr);
        this.sendAVC("electricalUlDelay", electricalUlDelayArgArr, context);
    }

    public String getConnFieldConnector(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        String str;
        MessageLog.traceEnter(this.getClass(), "getConnFieldConnector() <---");
        EqcGetAntFeedCableParamRspS rspSig = this.eqcCableProxy.getAntFeedCableParameters(this.getTxIdNonTransactional(context), 0, this.getAntFeederCableFroId(context));
        switch (rspSig.objectAConnectorId) {
            case 4: {
                str = "H1";
                break;
            }
            case 5: {
                str = "H2";
                break;
            }
            case 6: {
                str = "H3";
                break;
            }
            case 7: {
                str = "J1";
                break;
            }
            case 8: {
                str = "J2";
                break;
            }
            case 9: {
                str = "J3";
                break;
            }
            case 25: {
                str = "A1";
                break;
            }
            case 26: {
                str = "A2";
                break;
            }
            case 27: {
                str = "A3";
                break;
            }
            case 28: {
                str = "A4";
                break;
            }
            case 29: {
                str = "A5";
                break;
            }
            case 30: {
                str = "A6";
                break;
            }
            case 69: {
                str = "J1_AND_K1";
                break;
            }
            case 70: {
                str = "J3_AND_K2";
                break;
            }
            case 71: {
                str = "J5_AND_K3";
                break;
            }
            case 72: {
                str = "J4";
                break;
            }
            case 73: {
                str = "J6";
                break;
            }
            case 18: {
                str = "ANT_A";
                break;
            }
            case 19: {
                str = "ANT_B";
                break;
            }
            case 90: {
                str = "RXA_IO";
                break;
            }
            case 92: {
                str = "RXB_IO";
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "ObjectAConnectorId bad type : " + rspSig.objectAConnectorId);
                str = "--";
            }
        }
        return str;
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedConnectedToObjectARef, ManagedObject checkedConnectedAntennaBranchRef, int checkedObjectAConnector, int checkedAlarmStatus, Coordinator context) throws MoAccessException, TransactionRequiredException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        MessageLog.trace(1, this.getClass(), "ObjAConn=" + checkedObjectAConnector);
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        MessageLog.trace(1, this.getClass(), "initMoData() : myData is built");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MoDataHelper.createAndRegisterPersistentStringAttribute(this.myData, "userLabel", checkedUserLabel, true);
        MoDataHelper.createAndRegisterPersistentReferenceAttribute(this.myData, "connectedToObjectARef", checkedConnectedToObjectARef, true);
        ((Reservable)checkedConnectedToObjectARef).reserve((ManagedObject)this, context);
        MoDataHelper.createAndRegisterPersistentReferenceAttribute(this.myData, "antennaBranchRef", checkedConnectedAntennaBranchRef, true);
        MessageLog.trace(1, this.getClass(), "set reservedBy of " + checkedConnectedAntennaBranchRef.getLocalDistinguishedName());
        ((Reservable)checkedConnectedAntennaBranchRef).reserve((ManagedObject)this, context);
        MoDataHelper.createAndRegisterPersistentIntAttribute(this.myData, ANTFEEDER_CABLE_FRO_ID, this.createAndGetRo(checkedObjectAConnector, 1, context), false);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(3040401);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getAntFeederCableFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    private int getObjectARefFroId(ManagedObject connectedToObjectARef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectARefFroId() <---");
        if (connectedToObjectARef instanceof ConnectionFieldMo) {
            return 0;
        }
        if (connectedToObjectARef instanceof AuxPlugInUnitMo) {
            return ((AuxPlugInUnitMo)connectedToObjectARef).getAuxPlugInUnitFroId(context);
        }
        MessageLog.trace(2, this.getClass(), "Wrong object reference");
        throw new ValueOutOfRangeException("Wrong object reference", "AntFeederCable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] checkAndGetIntSeqAttribute(AttrList attributes, String attrName, String attrType, int defaultValue, int[] minValues, int[] maxValues, int intSeqSize, String thisTypeName, Coordinator context) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException {
        String notMandOptType = "Type other than mandatory or optional :";
        String wrongAttrType = "Wrong attribute type :";
        String wrongIntSeqSize = "Wrong Sequence size";
        String mandatoryAttr = "mandatory";
        String optionalAttr = "optional";
        int missingAttr = -1;
        int index = attributes.indexOf(attrName);
        int[] intSeq = new int[intSeqSize];
        if (index == missingAttr) {
            if (attrType.equalsIgnoreCase(mandatoryAttr)) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (!attrType.equalsIgnoreCase(optionalAttr)) throw new WrongAttributeTypeException(notMandOptType + attrName, thisTypeName);
            ValidateAttributes.intValueRangeCheck(attrName, defaultValue, minValues, maxValues, thisTypeName);
            for (int i = 0; i < intSeqSize; ++i) {
                intSeq[i] = defaultValue;
            }
        } else {
            if (!(attributes.getValue(index) instanceof int[])) {
                throw new WrongAttributeTypeException(wrongAttrType + attrName, thisTypeName);
            }
            if (((int[])attributes.getValue(index)).length != intSeqSize) {
                throw new ValueOutOfRangeException(wrongIntSeqSize, thisTypeName);
            }
            intSeq = (int[])attributes.getValue(index);
            for (int i = 0; i < intSeq.length; ++i) {
                ValidateAttributes.intValueRangeCheck(attrName, intSeq[i], minValues, maxValues, thisTypeName);
            }
        }
        attributes.removeElementAt(index);
        return intSeq;
    }

    private int createAndGetRo(int objAConn, int objBConn, Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createAndGetRo() <---");
        MessageLog.trace(1, this.getClass(), "createRo() : objAConn =" + objAConn + " ; ObjBConn=" + objBConn);
        int objectAConnector = 0;
        String branchName = ((AntennaBranchMo)this.getAntennaBranchRef(context)).getBranchName(context);
        int objectBConnector = branchName.equalsIgnoreCase("B") || branchName.equalsIgnoreCase("D") ? 65 : 64;
        switch (objAConn) {
            case 4: {
                objectAConnector = 4;
                break;
            }
            case 6: {
                objectAConnector = 5;
                break;
            }
            case 8: {
                objectAConnector = 6;
                break;
            }
            case 3: {
                objectAConnector = 7;
                break;
            }
            case 5: {
                objectAConnector = 8;
                break;
            }
            case 7: {
                objectAConnector = 9;
                break;
            }
            case 9: {
                objectAConnector = 25;
                break;
            }
            case 10: {
                objectAConnector = 26;
                break;
            }
            case 11: {
                objectAConnector = 27;
                break;
            }
            case 12: {
                objectAConnector = 28;
                break;
            }
            case 13: {
                objectAConnector = 29;
                break;
            }
            case 14: {
                objectAConnector = 30;
                break;
            }
            case 1: {
                objectAConnector = 18;
                break;
            }
            case 2: {
                objectAConnector = 19;
                break;
            }
            case 15: {
                objectAConnector = 69;
                break;
            }
            case 16: {
                objectAConnector = 70;
                break;
            }
            case 18: {
                objectAConnector = 71;
                break;
            }
            case 17: {
                objectAConnector = 72;
                break;
            }
            case 19: {
                objectAConnector = 73;
                break;
            }
            case 20: {
                objectAConnector = 90;
                break;
            }
            case 21: {
                objectAConnector = 92;
                break;
            }
            case 22: {
                objectAConnector = 93;
                break;
            }
            case 23: {
                objectAConnector = 96;
                break;
            }
            case 24: {
                objectAConnector = 97;
                break;
            }
            default: {
                objectAConnector = -1;
            }
        }
        this.verifyObjectAConnector(objectAConnector);
        int objectAFroId = 0;
        if (!(this.getConnectedToObjectARef(context) instanceof ConnectionFieldMo)) {
            objectAFroId = ((AuxPlugInUnitMo)this.getConnectedToObjectARef(context)).getAuxPlugInUnitFroId(context);
        }
        int objectBFroId = 0;
        objectBFroId = ((AntennaBranchMo)this.getAntennaBranchRef(context)).getAbFroId(context);
        EqcCreateCableRspS rspSig = null;
        try {
            rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50155, 0L, objectAFroId, objectAConnector, objectBFroId, objectBConnector);
        }
        catch (FroNotAccessibleException e) {
            if (this.getAntennaBranchRef(context) != null) {
                ((Reservable)this.getAntennaBranchRef(context)).release((ManagedObject)this, context);
            }
            if (this.getConnectedToObjectARef(context) != null) {
                ((Reservable)this.getConnectedToObjectARef(context)).release((ManagedObject)this, context);
            }
            super.delete(context);
            throw e;
        }
        catch (FroRequestFailedException e) {
            if (this.getAntennaBranchRef(context) != null) {
                ((Reservable)this.getAntennaBranchRef(context)).release((ManagedObject)this, context);
            }
            if (this.getConnectedToObjectARef(context) != null) {
                ((Reservable)this.getConnectedToObjectARef(context)).release((ManagedObject)this, context);
            }
            super.delete(context);
            throw e;
        }
        MessageLog.trace(1, this.getClass(), " createAndGetRO() : RO is created ");
        return (int)rspSig.cableFroId;
    }
}

